/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.draw;

import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import ro.amiq.dvt.diagrams.DConstants;
import ro.amiq.dvt.draw.DCanvas;
import ro.amiq.dvt.draw.obj.base.DObject;
import ro.amiq.dvt.startup.core.DVTLogger;

public class DViewport {
    private static final double SCALE_RESOLUTION = 10.0;
    private static final int SCALE_RANGE = 40;
    private static final double FIT_MARGIN_FACTOR = Math.pow(2.0, 0.01);
    private static final double MIN_OBJECT_ZOOM_SIZE = 6.0;
    private static final double DEFAULT_OBJECT_ZOOM_SIZE = 10.0;
    private final DCanvas canvas;
    private final AffineTransform transform = new AffineTransform();
    private ZoomType currentZoomType = ZoomType.FIT;
    protected double scaleCenterX;
    protected double scaleCenterY;
    protected double panX;
    protected double panY;
    private int fitContentScale;
    private int scale;
    private Rectangle canvasSize = new Rectangle(0, 0, 1, 1);
    private Rectangle contentSize = new Rectangle(0, 0, 1, 1);

    public DViewport(DCanvas canvas) {
        this.canvas = canvas;
    }

    public float[] getTransformMatrix() {
        double[] doubleMatrix = new double[6];
        float[] transformMatrix = new float[6];
        this.transform.getMatrix(doubleMatrix);
        int i = 0;
        while (i < doubleMatrix.length) {
            transformMatrix[i] = (float)doubleMatrix[i];
            ++i;
        }
        return transformMatrix;
    }

    public void setCanvasSize(Rectangle size) {
        this.canvasSize = size;
        if (DConstants.DEBUG) {
            this.canvas.getDebug().log("size/canvas", "[" + this.canvasSize.width + ", " + this.canvasSize.height + "]");
        }
        this.updateFitCotentScale();
    }

    public Rectangle getCanvasSize() {
        return this.canvasSize;
    }

    public void setContentSize(Rectangle size) {
        this.contentSize = size;
        if (DConstants.DEBUG) {
            this.canvas.getDebug().log("size/image", "[" + this.contentSize.width + ", " + this.contentSize.height + "]");
        }
        this.updateFitCotentScale();
    }

    public void applyCurentZoom() {
        if (this.currentZoomType == ZoomType.FIT) {
            this.zoomToFitCanvas();
        } else {
            this.canvas.getRenderer().render();
        }
    }

    public void zoomIncrementedScaleAboutPoint(int amount, double x, double y) {
        this.zoomFixedScaleAboutPoint(this.scale + amount, x, y);
    }

    public void zoomIncrementedScaleAboutCenter(int amount) {
        this.zoomFixedScaleAboutPoint(this.scale + amount, (double)this.canvasSize.width / 2.0, (double)this.canvasSize.height / 2.0);
    }

    public void zoomToCurrentContentObject(DObject object) {
        Rectangle cb = this.getTransformedBounds();
        Rectangle ob = object.getBounds();
        int newScale = this.scale;
        double objectMinSize = Math.min(ob.width, ob.height);
        if (objectMinSize * this.getExpScale() < 6.0) {
            newScale = this.expScaleToScale(10.0 / objectMinSize / FIT_MARGIN_FACTOR);
        }
        if (newScale != this.scale || cb.x > ob.x || cb.y > ob.y || cb.x + cb.width < ob.x + ob.width || cb.y + cb.height < ob.y + ob.height) {
            this.currentZoomType = ZoomType.MANUAL;
            this.scaleCenterX = (double)ob.x + (double)ob.width / 2.0;
            this.scaleCenterY = (double)ob.y + (double)ob.height / 2.0;
            this.panX = (double)this.canvasSize.width / 2.0;
            this.panY = (double)this.canvasSize.height / 2.0;
            this.setScale(newScale);
            this.updateTransform();
        }
        this.canvas.getRenderer().render();
    }

    public void zoomToNewContentObject(DObject[] objects, double lastScale) {
        Rectangle sb = null;
        DObject[] dObjectArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            DObject object = dObjectArray[n2];
            Rectangle ob = object.getBounds();
            if (ob != null) {
                if (sb == null) {
                    sb = new Rectangle(ob.x, ob.y, ob.width, ob.height);
                } else {
                    sb.add(ob);
                }
            }
            ++n2;
        }
        if (sb == null) {
            this.zoomToFitCanvas();
            return;
        }
        this.currentZoomType = ZoomType.MANUAL;
        this.scaleCenterX = (double)sb.width / 2.0 + (double)sb.x;
        this.scaleCenterY = (double)sb.height / 2.0 + (double)sb.y;
        this.panX = (double)this.canvasSize.width / 2.0;
        this.panY = (double)this.canvasSize.height / 2.0;
        double newScale = Math.min((double)this.canvasSize.width / (double)sb.width, (double)this.canvasSize.height / (double)sb.height);
        newScale = Math.min(lastScale, newScale);
        double objectMinSize = Math.min(sb.width, sb.height);
        if (objectMinSize * newScale < 6.0) {
            newScale = 10.0 / objectMinSize;
        }
        this.setScale(this.expScaleToScale(newScale));
        this.updateTransform();
        this.canvas.getRenderer().render();
    }

    public void zoomFixedScaleAboutPoint(int scale, double x, double y) {
        this.currentZoomType = ZoomType.MANUAL;
        Point2D scaleCenter = this.getInverseTransformPoint(x, y);
        this.scaleCenterX = scaleCenter.getX();
        this.scaleCenterY = scaleCenter.getY();
        this.panX = x;
        this.panY = y;
        this.setScale(scale);
        this.updateTransform();
        this.canvas.getRenderer().render();
    }

    public void zoomToFitCanvas() {
        this.currentZoomType = ZoomType.FIT;
        this.scaleCenterX = (double)this.contentSize.width / 2.0 + (double)this.contentSize.x;
        this.scaleCenterY = (double)this.contentSize.height / 2.0 + (double)this.contentSize.y;
        this.panX = (double)this.canvasSize.width / 2.0;
        this.panY = (double)this.canvasSize.height / 2.0;
        this.setScale(this.fitContentScale);
        this.updateTransform();
        this.canvas.getRenderer().render();
    }

    public void zoomReset() {
        this.zoomFixedScaleAboutPoint(0, (double)this.canvasSize.width / 2.0, (double)this.canvasSize.height / 2.0);
    }

    public void pan(double dx, double dy) {
        this.currentZoomType = ZoomType.MANUAL;
        this.panX += dx;
        this.panY += dy;
        this.updateTransform();
        this.canvas.getRenderer().render();
    }

    public Rectangle getTransformedBounds() {
        Point2D p1 = this.getInverseTransformPoint(0.0, 0.0);
        Point2D p2 = this.getInverseTransformPoint(this.canvasSize.width, this.canvasSize.height);
        return new Rectangle(Math.round((float)(p1.getX() - 1.0)), Math.round((float)(p1.getY() - 1.0)), Math.round((float)(p2.getX() - p1.getX() + 2.0)), Math.round((float)(p2.getY() - p1.getY() + 2.0)));
    }

    public Point getTransformedPoint(int x, int y) {
        Point2D point = this.getInverseTransformPoint(x, y);
        return new Point(Math.round((float)point.getX()), Math.round((float)point.getY()));
    }

    protected void updateTransform() {
        double expScale = this.getExpScale();
        this.transform.setToIdentity();
        this.transform.translate(this.panX, this.panY);
        this.transform.scale(expScale, expScale);
        this.transform.translate(-this.scaleCenterX, -this.scaleCenterY);
        if (DConstants.DEBUG) {
            this.canvas.getDebug().log("viewport/scale", this.scale);
            this.canvas.getDebug().log("viewport/expScale", expScale);
            this.canvas.getDebug().log("viewport/panX", this.panX);
            this.canvas.getDebug().log("viewport/panY", this.panY);
            this.canvas.getDebug().log("viewport/scaleCenterX", this.scaleCenterX);
            this.canvas.getDebug().log("viewport/scaleCenterY", this.scaleCenterY);
        }
    }

    private void updateFitCotentScale() {
        this.fitContentScale = this.expScaleToScale(Math.min((double)this.canvasSize.width / (double)this.contentSize.width, (double)this.canvasSize.height / (double)this.contentSize.height) / FIT_MARGIN_FACTOR);
    }

    protected int expScaleToScale(double expScale) {
        return Math.round((float)Math.floor(Math.log(expScale) / Math.log(2.0) * 10.0));
    }

    protected void setScale(int scale) {
        this.scale = scale;
        if (scale < this.fitContentScale - 40) {
            this.scale = this.fitContentScale - 40;
        } else if (scale > 40) {
            this.scale = 40;
        }
    }

    public double getExpScale() {
        return Math.pow(2.0, (double)this.scale / 10.0);
    }

    public double getPanX() {
        return this.panX;
    }

    public double getPanY() {
        return this.panY;
    }

    public double getScaleCenterX() {
        return this.scaleCenterX;
    }

    public double getScaleCenterY() {
        return this.scaleCenterY;
    }

    public int getScale() {
        return this.scale;
    }

    private Point2D getInverseTransformPoint(double x, double y) {
        Point2D.Double point = new Point2D.Double(x, y);
        try {
            this.transform.inverseTransform(point, point);
        }
        catch (NoninvertibleTransformException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return point;
    }

    private static enum ZoomType {
        FIT,
        MANUAL;

    }
}

