/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.draw.handlers;

import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.Set;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Point;
import ro.amiq.dvt.draw.handlers.DClickEventCommon;
import ro.amiq.dvt.draw.obj.base.DObject;

public class DClickEvent
extends DClickEventCommon {
    private final MouseEvent event;
    private final Set<Integer> keyCodes;

    public DClickEvent(MouseEvent event, Set<Integer> keyCodes, Point transformedPoint, Deque<DObject> hits) {
        this.event = event;
        this.keyCodes = keyCodes;
        this.transformedPoint = transformedPoint;
        this.hits = hits;
    }

    @Override
    public Point getTransformedPoint() {
        return new Point(this.transformedPoint.x, this.transformedPoint.y);
    }

    public Point getPoint() {
        return new Point(this.event.x, this.event.y);
    }

    @Override
    public int getButton() {
        return this.event.button;
    }

    @Override
    public int getStateMask() {
        return this.event.stateMask;
    }

    public Set<Integer> getKeyCodes() {
        return this.keyCodes;
    }

    public Collection<DObject> getHits() {
        return Collections.unmodifiableCollection(this.hits);
    }

    public DObject getLastHit() {
        return (DObject)this.hits.peekLast();
    }
}

