/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.draw.handlers;

import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Point;
import ro.amiq.dvt.diagrams.DConstants;
import ro.amiq.dvt.draw.DCanvas;
import ro.amiq.dvt.draw.debug.DDebug;
import ro.amiq.dvt.draw.handlers.DClickEvent;
import ro.amiq.dvt.draw.handlers.DClickHandlerCommon;
import ro.amiq.dvt.draw.handlers.DClickListener;
import ro.amiq.dvt.draw.handlers.MouseEventProcessorCommon;
import ro.amiq.dvt.draw.obj.base.DGroup;
import ro.amiq.dvt.draw.obj.base.DObject;

public class DClickHandler
extends DClickHandlerCommon
implements MouseListener,
KeyListener,
DisposeListener {
    private static final int MOVE_THRESHOLD = 10;
    private final MouseEvent[] downEvents;
    private final Set<Integer> downKeyCodes;
    private final ThreadPoolExecutor eventExecutor;

    public DClickHandler(DCanvas canvas) {
        this.canvas = canvas;
        this.canvas.addMouseListener(this);
        this.canvas.addKeyListener(this);
        this.canvas.addDisposeListener(this);
        this.downEvents = new MouseEvent[3];
        this.downKeyCodes = new HashSet<Integer>();
        this.listeners = Collections.synchronizedSet(new LinkedHashSet());
        this.eventExecutor = new ThreadPoolExecutor(0, 1, 30L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadPoolExecutor.DiscardPolicy());
    }

    public void mouseDown(MouseEvent e) {
        if (e.button < 1 || e.button > 3) {
            return;
        }
        this.downEvents[e.button - 1] = e;
    }

    public void mouseUp(MouseEvent e) {
        DObject content;
        if (e.button < 1 || e.button > 3) {
            return;
        }
        MouseEvent pe = this.downEvents[e.button - 1];
        this.downEvents[e.button - 1] = null;
        if (pe != null && !this.listeners.isEmpty() && Math.abs(e.x - pe.x) < 10 && Math.abs(e.y - pe.y) < 10 && !this.eventExecutor.isShutdown() && (content = this.canvas.getContent()) != null) {
            this.eventExecutor.execute(new MouseEventProcessor(content, pe, Collections.unmodifiableSet(new HashSet<Integer>(this.downKeyCodes)), this.canvas.getViewport().getTransformedPoint(pe.x, pe.y), new LinkedHashSet<DClickListener>(this.listeners), this.canvas.getDebug()));
        }
    }

    public void mouseDoubleClick(MouseEvent e) {
    }

    public void widgetDisposed(DisposeEvent e) {
        this.eventExecutor.shutdownNow();
        this.canvas.removeKeyListener(this);
        this.canvas.removeMouseListener(this);
        this.canvas.removeDisposeListener(this);
    }

    public void keyPressed(KeyEvent e) {
        if (e.keyCode == 262144 || e.keyCode == 65536 || e.keyCode == 131072 || e.keyCode == 16777298) {
            return;
        }
        this.downKeyCodes.add(e.keyCode);
    }

    public void keyReleased(KeyEvent e) {
        if (e.keyCode == 262144 || e.keyCode == 65536 || e.keyCode == 131072 || e.keyCode == 16777298) {
            return;
        }
        this.downKeyCodes.remove(e.keyCode);
    }

    private static final class MouseEventProcessor
    extends MouseEventProcessorCommon
    implements Runnable {
        private final MouseEvent mouseEvent;
        private final Set<Integer> keyCodes;
        private final DDebug debug;

        public MouseEventProcessor(DObject content, MouseEvent mouseEvent, Set<Integer> keyCodes, Point transformedPoint, Set<DClickListener> listeners, DDebug debug) {
            this.content = content;
            this.mouseEvent = mouseEvent;
            this.keyCodes = keyCodes;
            this.transformedPoint = transformedPoint;
            this.listeners = listeners;
            this.debug = debug;
        }

        @Override
        public void run() {
            LinkedList<DObject> hits = new LinkedList<DObject>();
            if (DConstants.DEBUG) {
                this.debug.startTimer("mouse/hit/time/detection");
            }
            this.detectHit(this.content, hits);
            if (DConstants.DEBUG) {
                this.debug.endTimer("mouse/hit/time/detection");
            }
            DClickEvent event = new DClickEvent(this.mouseEvent, this.keyCodes, this.transformedPoint, hits);
            if (DConstants.DEBUG) {
                this.debug.startTimer("mouse/hit/time/listeners");
            }
            for (DClickListener listener : this.listeners) {
                listener.handleEvent(event);
            }
            if (DConstants.DEBUG) {
                this.debug.endTimer("mouse/hit/time/listeners");
            }
        }

        @Override
        protected boolean detectHit(DObject object, Deque<DObject> hits) {
            if (!object.contains(this.transformedPoint)) {
                return false;
            }
            hits.add(object);
            if (object instanceof DGroup) {
                List<DObject> children = ((DGroup)object).getChildren();
                if (children != null) {
                    ListIterator<DObject> iterator = children.listIterator(children.size());
                    while (iterator.hasPrevious()) {
                        if (this.detectHit(iterator.previous(), hits)) break;
                    }
                }
                if (hits.peekLast() == object) {
                    hits.pollLast();
                    return false;
                }
            }
            return true;
        }
    }
}

