/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.draw.handlers;

import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseWheelListener;
import org.eclipse.swt.graphics.Rectangle;
import ro.amiq.dvt.draw.DCanvas;
import ro.amiq.dvt.draw.DMagnifier;

public class DMagnifierHandler
implements MouseListener,
MouseMoveListener,
MouseWheelListener,
KeyListener,
DisposeListener {
    private final DCanvas canvas;
    private boolean isEnabled;
    private boolean isVisible;

    public DMagnifierHandler(DCanvas canvas) {
        this.canvas = canvas;
        this.installListeners();
    }

    public void installListeners() {
        this.canvas.addMouseListener(this);
        this.canvas.addMouseMoveListener(this);
        this.canvas.addMouseWheelListener(this);
        this.canvas.addKeyListener(this);
        this.canvas.addDisposeListener(this);
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public void setIsEnabled(boolean isEnabled) {
        this.isEnabled = isEnabled;
    }

    public void setIsVisible(boolean isVisible) {
        this.isVisible = isVisible;
    }

    public void keyPressed(KeyEvent e) {
        if (e.character == 'm' || e.character == 'M') {
            this.isVisible = this.isEnabled = !this.isEnabled;
            this.manageMagnifier();
            return;
        }
        if (e.character == 'z' || e.character == 'Z') {
            boolean prevIsVisible = this.isVisible;
            boolean bl = this.isVisible = !this.isEnabled;
            if (prevIsVisible == this.isVisible) {
                return;
            }
            this.manageMagnifier();
            return;
        }
        if (e.stateMask == 262144 && e.character == '0') {
            this.resetMagnifierState();
            return;
        }
    }

    public void keyReleased(KeyEvent e) {
        if (e.character == 'z' || e.character == 'Z') {
            this.isVisible = !this.isVisible;
            this.manageMagnifier();
            return;
        }
    }

    public void mouseMove(MouseEvent e) {
        if (this.isVisible) {
            this.renderMagnifier();
        }
        int x = e.x;
        int y = e.y;
        this.canvas.getMagnifier().setContentX(x);
        this.canvas.getMagnifier().setContentY(y);
        this.fitMagnifierInBounds(x, y, false);
    }

    public void mouseDoubleClick(MouseEvent e) {
    }

    public void mouseDown(MouseEvent e) {
    }

    public void mouseUp(MouseEvent e) {
    }

    public void widgetDisposed(DisposeEvent e) {
        this.canvas.removeMouseMoveListener(this);
        this.canvas.removeMouseListener(this);
        this.canvas.removeKeyListener(this);
        this.canvas.removeDisposeListener(this);
    }

    public void mouseScrolled(MouseEvent e) {
        if (!this.isVisible) {
            return;
        }
        if (e.stateMask == 131072) {
            this.canvas.getMagnifier().updateZoom(Integer.signum(e.count));
            this.renderMagnifier();
            return;
        }
        if (e.stateMask == 262144) {
            this.canvas.getMagnifier().updateSizeRatio(Integer.signum(e.count));
            this.fitMagnifierInBounds(e.x, e.y, true);
            this.renderMagnifier();
            return;
        }
    }

    private void manageMagnifier() {
        if (this.isVisible) {
            this.renderMagnifier();
            return;
        }
        if (!this.isEnabled) {
            this.hideMagnifier();
            return;
        }
        if (!this.isVisible) {
            this.temporaryHideMagnifier();
            return;
        }
    }

    public void fitMagnifierInBounds(int x, int y, boolean updateSizeRatio) {
        Rectangle bounds = this.canvas.getBounds();
        if (bounds == null) {
            return;
        }
        DMagnifier magnifier = this.canvas.getMagnifier();
        int width = bounds.width;
        int height = bounds.height;
        int diameter = magnifier.getDiameter();
        if (diameter > width || diameter > height) {
            diameter = Math.min(width, height);
        }
        if (x + diameter > width) {
            x = width - diameter;
        } else if (x < 0) {
            x = 0;
        }
        if (y + diameter > height) {
            y = height - diameter;
        } else if (y < 0) {
            y = 0;
        }
        magnifier.setBorderX(x);
        magnifier.setBorderY(y);
        if (updateSizeRatio) {
            magnifier.setSizeRatio(diameter);
        }
    }

    private void renderMagnifier() {
        DMagnifier magnifier = this.canvas.getMagnifier();
        if (magnifier == null) {
            return;
        }
        magnifier.matchTransformToParentViewport(this.canvas.getViewport());
        magnifier.zoomFixedScaleAboutPoint(magnifier.getZoom(), magnifier.getContentX(), magnifier.getContentY());
        magnifier.pan((double)magnifier.getRadius() + (double)(magnifier.getBorderX() - magnifier.getContentX()), (double)magnifier.getRadius() + (double)(magnifier.getBorderY() - magnifier.getContentY()));
    }

    private void temporaryHideMagnifier() {
        this.canvas.getRenderer().render();
    }

    private void hideMagnifier() {
        this.canvas.getRenderer().render();
    }

    private void resetMagnifierState() {
        this.canvas.getMagnifier().resetZoom();
        this.canvas.getMagnifier().resetSizeRatio();
        this.renderMagnifier();
    }
}

