/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.draw.handlers;

import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import ro.amiq.dvt.diagrams.preferences.DiagramPreferenceAdapter;
import ro.amiq.dvt.draw.DCanvas;

public class DPanHandler
implements MouseListener,
MouseMoveListener,
KeyListener,
DisposeListener {
    private final DCanvas canvas;
    private final Cursor[] cursors;
    private boolean inProgress = false;
    private int prevX = 0;
    private int prevY = 0;

    public DPanHandler(DCanvas canvas) {
        this.canvas = canvas;
        this.canvas.addMouseListener(this);
        this.canvas.addMouseMoveListener(this);
        this.canvas.addKeyListener(this);
        this.canvas.addDisposeListener(this);
        this.cursors = new Cursor[]{new Cursor((Device)canvas.getDisplay(), 0), new Cursor((Device)canvas.getDisplay(), 21)};
    }

    public void mouseMove(MouseEvent e) {
        if (this.inProgress) {
            this.setHandCursor(true);
            this.canvas.getViewport().pan((double)e.x - (double)this.prevX, (double)e.y - (double)this.prevY);
            this.prevX = e.x;
            this.prevY = e.y;
        }
    }

    public void mouseDown(MouseEvent e) {
        if (e.button == 1) {
            this.inProgress = true;
            this.prevX = e.x;
            this.prevY = e.y;
        }
    }

    public void mouseUp(MouseEvent e) {
        if (e.button == 1) {
            this.setHandCursor(false);
            this.inProgress = false;
        }
    }

    private void setHandCursor(boolean enabled) {
        if (this.canvas != null && !this.canvas.isDisposed()) {
            this.canvas.setCursor(enabled ? this.cursors[1] : this.cursors[0]);
        }
    }

    public void mouseDoubleClick(MouseEvent e) {
    }

    public void keyPressed(KeyEvent e) {
        boolean reverse = DiagramPreferenceAdapter.getInstance().getDiagramReverseArrows();
        if (e.keyCode == (reverse ? 0x1000002 : 0x1000001)) {
            this.canvas.getViewport().pan(0.0, -50.0);
        } else if (e.keyCode == (reverse ? 0x1000001 : 0x1000002)) {
            this.canvas.getViewport().pan(0.0, 50.0);
        } else if (e.keyCode == (reverse ? 0x1000004 : 0x1000003)) {
            this.canvas.getViewport().pan(-50.0, 0.0);
        }
        if (e.keyCode == (reverse ? 0x1000003 : 0x1000004)) {
            this.canvas.getViewport().pan(50.0, 0.0);
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    public void widgetDisposed(DisposeEvent e) {
        Cursor[] cursorArray = this.cursors;
        int n = this.cursors.length;
        int n2 = 0;
        while (n2 < n) {
            Cursor cursor = cursorArray[n2];
            if (cursor != null && !cursor.isDisposed()) {
                cursor.dispose();
            }
            ++n2;
        }
        this.canvas.removeMouseMoveListener(this);
        this.canvas.removeMouseListener(this);
        this.canvas.removeKeyListener(this);
        this.canvas.removeDisposeListener(this);
    }
}

