/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.draw.handlers;

import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseWheelListener;
import ro.amiq.dvt.draw.DCanvas;
import ro.amiq.dvt.draw.DMagnifier;
import ro.amiq.dvt.draw.handlers.DMagnifierHandler;

public class DZoomHandler
implements MouseWheelListener,
KeyListener,
DisposeListener {
    private final DCanvas canvas;

    public DZoomHandler(DCanvas canvas) {
        this.canvas = canvas;
        this.canvas.addMouseWheelListener(this);
        this.canvas.addKeyListener(this);
        this.canvas.addDisposeListener(this);
    }

    public void mouseScrolled(MouseEvent e) {
        DMagnifier magnifier = this.canvas.getMagnifier();
        DMagnifierHandler handler = magnifier.getHandler();
        if (handler != null && handler.isVisible() && ((e.stateMask & 0x20000) != 0 || (e.stateMask & 0x40000) != 0)) {
            return;
        }
        this.canvas.getViewport().zoomIncrementedScaleAboutPoint(Integer.signum(e.count), e.x, e.y);
    }

    public void keyPressed(KeyEvent e) {
        if (e.character == '+') {
            this.canvas.getViewport().zoomIncrementedScaleAboutCenter(5);
        } else if (e.character == '-') {
            this.canvas.getViewport().zoomIncrementedScaleAboutCenter(-5);
        } else if ((e.stateMask & 0x40000) == 0 && e.character == '0') {
            this.canvas.getViewport().zoomToFitCanvas();
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    public void widgetDisposed(DisposeEvent e) {
        this.canvas.removeMouseWheelListener(this);
        this.canvas.removeKeyListener(this);
        this.canvas.removeDisposeListener(this);
    }
}

