/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.draw.handlers;

import java.util.Deque;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.eclipse.swt.graphics.Point;
import ro.amiq.dvt.draw.handlers.DClickListener;
import ro.amiq.dvt.draw.obj.base.DGroup;
import ro.amiq.dvt.draw.obj.base.DObject;

public abstract class MouseEventProcessorCommon {
    protected DObject content;
    protected Point transformedPoint;
    protected Set<DClickListener> listeners;

    protected boolean detectHit(DObject object, Deque<DObject> hits) {
        if (!object.contains(this.transformedPoint)) {
            return false;
        }
        hits.add(object);
        if (object instanceof DGroup) {
            List<DObject> children = ((DGroup)object).getChildren();
            if (children != null) {
                ListIterator<DObject> iterator = children.listIterator(children.size());
                while (iterator.hasPrevious()) {
                    if (this.detectHit(iterator.previous(), hits)) break;
                }
            }
            if (hits.peekLast() == object) {
                hits.pollLast();
                return false;
            }
        }
        return true;
    }
}

