/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.draw.obj.base;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import ro.amiq.dvt.draw.render.DContext;

public abstract class DObject {
    private boolean dirtyBounds = true;
    private Rectangle bounds = null;

    public abstract void paint(DContext var1);

    public abstract Rectangle computeBounds();

    public void setDirtyBounds() {
        this.dirtyBounds = true;
    }

    public Rectangle getBounds() {
        if (this.dirtyBounds) {
            this.bounds = this.computeBounds();
            this.dirtyBounds = false;
        }
        return this.bounds;
    }

    public Rectangle intersection(Rectangle rectangle) {
        Rectangle bounds = this.getBounds();
        if (bounds == null) {
            return null;
        }
        return bounds.intersection(rectangle);
    }

    public boolean contains(Point point) {
        Rectangle bounds = this.getBounds();
        if (bounds == null) {
            return false;
        }
        return bounds.contains(point);
    }

    public String nameString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append("@").append(Integer.toHexString(System.identityHashCode(this)));
        return sb.toString();
    }

    public String valueString() {
        String longValue;
        String boundsString;
        StringBuilder sb = new StringBuilder();
        String shortValue = this.shortValueString();
        if (shortValue != null) {
            sb.append(shortValue.trim()).append('\n');
        }
        if ((boundsString = this.boundsString()) != null) {
            sb.append(boundsString.trim()).append('\n');
        }
        if ((longValue = this.longValueString()) != null) {
            sb.append(longValue.trim());
        }
        return sb.toString();
    }

    public String shortValueString() {
        return null;
    }

    public String longValueString() {
        return null;
    }

    public String boundsString() {
        StringBuilder sb = new StringBuilder();
        Rectangle bounds = this.getBounds();
        if (bounds == null) {
            return null;
        }
        sb.append("BOUNDS = [").append(bounds.x).append(", ").append(bounds.y).append(", ").append(bounds.width).append(", ").append(bounds.height).append("]");
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.nameString()).append('\n').append(this.valueString());
        return sb.toString();
    }
}

