/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.draw.obj.base;

import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import ro.amiq.dvt.draw.obj.base.DPrimitive;
import ro.amiq.dvt.draw.obj.utils.RGBV;
import ro.amiq.dvt.draw.render.DContext;
import ro.amiq.dvt.draw.utils.ColorFactory;

public abstract class DPath
extends DPrimitive {
    private RGB lineColor = ColorFactory.getInstance().getRGB(0, 0, 0);
    private int lineWidth = 1;
    private int lineCap = 2;
    private int lineJoin = 2;
    private int lineStyle = 1;
    private boolean lineVisible = true;
    private boolean lineAutoScale = false;
    private double lineAutoScaleThreshold = 0.5;

    public void setLineColor(RGB color) {
        this.lineColor = color;
    }

    public void setLineWidth(int width) {
        this.lineWidth = width;
        this.setDirtyBounds();
    }

    public int getLineWidth() {
        return this.lineWidth;
    }

    public void setLineCap(int cap) {
        this.lineCap = cap;
    }

    public void setLineJoin(int join) {
        this.lineJoin = join;
    }

    public void setLineStyle(int style) {
        this.lineStyle = style;
    }

    public void setLineVisible(boolean visible) {
        this.lineVisible = visible;
    }

    public boolean isLineVisible() {
        return this.lineVisible;
    }

    public void setLineAutoScale(boolean autoScale) {
        this.lineAutoScale = autoScale;
    }

    public void setLineColor(RGBV color) {
        this.lineColor = color.getRGB();
        this.lineVisible = color.isVisible();
    }

    @Override
    public void paint(DContext dc) {
        if (this.lineVisible && (this.lineAutoScale || dc.getQuality().isPathVisible(dc.getExpScale(), this.getLineWidth()))) {
            dc.setForeground(this.lineColor);
            dc.setLineWidth(this.lineAutoScale && dc.getExpScale() < this.lineAutoScaleThreshold ? (int)((double)this.lineWidth * this.lineAutoScaleThreshold / dc.getExpScale()) : this.lineWidth);
            dc.setLineCap(this.lineCap);
            dc.setLineJoin(this.lineJoin);
            dc.setLineStyle(this.lineStyle);
            this.paintPath(dc);
        }
    }

    protected abstract void paintPath(DContext var1);

    protected Rectangle computeBoundsWithLineWidthOverflow(int x, int y, int width, int height) {
        int lwo = this.getLineWidthOverflow();
        return new Rectangle(x - lwo, y - lwo, width + lwo * 2, height + lwo * 2);
    }

    protected int getLineWidthOverflow() {
        return (this.lineWidth + 1) / 2;
    }
}

