/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.draw.obj.base;

import org.eclipse.swt.graphics.RGB;
import ro.amiq.dvt.draw.obj.base.DPath;
import ro.amiq.dvt.draw.obj.utils.RGBV;
import ro.amiq.dvt.draw.render.DContext;
import ro.amiq.dvt.draw.utils.ColorFactory;

public abstract class DShape
extends DPath {
    private RGB fillColor = ColorFactory.getInstance().getRGB(255, 255, 255);
    private boolean fillVisible = true;

    public void setFillColor(RGB color) {
        this.fillColor = color;
    }

    public void setFillVisible(boolean visible) {
        this.fillVisible = visible;
    }

    public boolean isFillVisible() {
        return this.fillVisible;
    }

    public void setFillColor(RGBV color) {
        if (color == null) {
            return;
        }
        this.fillColor = color.getRGB();
        this.fillVisible = color.isVisible();
    }

    @Override
    public void paint(DContext dc) {
        if (this.fillVisible && dc.getQuality().isShapeVisible(dc.getExpScale(), this.getBounds())) {
            dc.setBackground(this.fillColor);
            this.paintFill(dc);
        }
        super.paint(dc);
    }

    protected abstract void paintFill(DContext var1);
}

