/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.draw.obj.base;

import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import ro.amiq.dvt.draw.obj.base.DPrimitive;
import ro.amiq.dvt.draw.obj.utils.RGBV;
import ro.amiq.dvt.draw.render.DContext;
import ro.amiq.dvt.draw.utils.ColorFactory;

public abstract class DSymbol
extends DPrimitive {
    private RGB symbolColor = ColorFactory.getInstance().getRGB(0, 0, 0);
    private boolean symbolVisible = true;
    protected final int x;
    protected final int y;
    protected final int width;
    protected final int height;
    protected final int m;

    protected DSymbol(int gx, int gy, int x, int y, int width, int height) {
        this.m = Math.min((width - 2) / gx, (height - 2) / gy);
        this.width = this.m * gx;
        this.height = this.m * gy;
        this.x = x + Math.round((float)(width - this.width) / 2.0f);
        this.y = y + Math.round((float)(height - this.height) / 2.0f);
    }

    public void setSymbolColor(RGB color) {
        this.symbolColor = color;
    }

    public void setSymbolVisible(boolean visible) {
        this.symbolVisible = visible;
    }

    public boolean isSymbolVisible() {
        return this.symbolVisible;
    }

    public void setSymbolColor(RGBV color) {
        this.symbolColor = color.getRGB();
        this.symbolVisible = color.isVisible();
    }

    @Override
    public void paint(DContext dc) {
        if (this.symbolVisible && dc.getQuality().isShapeVisible(dc.getExpScale(), this.getBounds())) {
            dc.setForeground(this.symbolColor);
            dc.setBackground(this.symbolColor);
            this.paintSymbol(dc);
        }
    }

    protected abstract void paintSymbol(DContext var1);

    @Override
    public Rectangle computeBounds() {
        return new Rectangle(this.x - 1, this.y - 1, this.width + 2, this.height + 2);
    }
}

