/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.draw.obj.design;

import de.cau.cs.kieler.core.kgraph.KGraphElement;
import java.util.Comparator;
import org.eclipse.swt.graphics.Rectangle;
import ro.amiq.dvt.diagrams.klay.utils.KLayDrawUtils;
import ro.amiq.dvt.draw.obj.base.DGroup;
import ro.amiq.dvt.draw.obj.design.DEdge;
import ro.amiq.dvt.draw.obj.design.DLabel;
import ro.amiq.dvt.draw.obj.design.DModule;
import ro.amiq.dvt.draw.obj.design.DPort;
import ro.amiq.dvt.draw.obj.utils.DProperties;
import ro.amiq.dvt.draw.obj.utils.RGBV;

public abstract class DDesignObject
extends DGroup {
    public static final Comparator<DDesignObject> COMPARATOR = new Comparator<DDesignObject>(){

        @Override
        public int compare(DDesignObject o1, DDesignObject o2) {
            return Integer.compare(this.position(o1), this.position(o2));
        }

        private int position(DDesignObject o) {
            if (o == null) {
                return -1;
            }
            if (o instanceof DModule) {
                return 1;
            }
            if (o instanceof DLabel) {
                return 2;
            }
            if (o instanceof DEdge) {
                return 3;
            }
            if (o instanceof DPort) {
                return 4;
            }
            return 0;
        }
    };
    public static final DProperties.Key<KGraphElement> KELEMENT = new DProperties.Key("DDesignObject.KELEMENT");
    public static final DProperties.Key<Rectangle> LAYOUT = new DProperties.Key("DDesignObject.LAYOUT");
    public static final DProperties.Key<RGBV> LINE_COLOR = new DProperties.Key("DDesignObject.LINE_COLOR");
    public static final DProperties.Key<RGBV> SELECTED_LINE_COLOR = new DProperties.Key("DDesignObject.SELECTED_LINE_COLOR");
    public static final DProperties.Key<RGBV> FILL_COLOR = new DProperties.Key("DDesignObject.FILL_COLOR");
    public static final DProperties.Key<RGBV> SELECTED_FILL_COLOR = new DProperties.Key("DDesignObject.SELECTED_FILL_COLOR");
    public static final DProperties.Key<Integer> LINE_WIDTH = new DProperties.Key("DDesignObject.LINE_WIDTH");
    public static final DProperties.Key<Integer> SELECTED_LINE_WIDTH = new DProperties.Key("DDesignObject.SELECTED_LINE_WIDTH");
    public static final DProperties.Key<Integer> LINE_STYLE = new DProperties.Key("DDesignObject.LINE_STYLE");
    private final DProperties properties = new DProperties();

    public <T> T getProperty(DProperties.Key<T> key) {
        return this.properties.get(key);
    }

    public <T> void removeProperty(DProperties.Key<T> key) {
        this.properties.remove(key);
    }

    public <T> void setProperty(DProperties.Key<T> key, T value) {
        this.properties.put(key, value);
    }

    public abstract void create();

    @Override
    public String shortValueString() {
        return KLayDrawUtils.getNLObjectName(this);
    }

    @Override
    public String longValueString() {
        return this.properties.toString();
    }
}

