/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.draw.obj.design;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.swt.graphics.Point;
import ro.amiq.dvt.diagrams.klay.utils.KLayDrawUtils;
import ro.amiq.dvt.diagrams.netlist.model.NLAbstractBase;
import ro.amiq.dvt.diagrams.netlist.model.NLConnection;
import ro.amiq.dvt.diagrams.netlist.rendering.NLDefaultRenderingConstants;
import ro.amiq.dvt.draw.obj.base.DObject;
import ro.amiq.dvt.draw.obj.design.DDesignObject;
import ro.amiq.dvt.draw.obj.design.DLabel;
import ro.amiq.dvt.draw.obj.interaction.DSelectable;
import ro.amiq.dvt.draw.obj.primitive.DHeadClosedArrow;
import ro.amiq.dvt.draw.obj.primitive.DLine;
import ro.amiq.dvt.draw.obj.primitive.DOval;
import ro.amiq.dvt.draw.obj.utils.DProperties;
import ro.amiq.dvt.draw.obj.utils.RGBV;

public class DEdge
extends DDesignObject {
    public static final DProperties.Key<List<Point>> BENDING_POINTS = new DProperties.Key("DEdge.BENDING_POINTS");
    public static final DProperties.Key<List<Point>> JUNCTION_POINTS = new DProperties.Key("DEdge.JUNCTION_POINTS");
    public static final DProperties.Key<Integer> SOURCE_ARROW_SIZE = new DProperties.Key("DEdge.SOURCE_ARROW_SIZE");
    public static final DProperties.Key<Integer> TARGET_ARROW_SIZE = new DProperties.Key("DEdge.TARGET_ARROW_SIZE");
    public static final DProperties.Key<Type> TYPE = new DProperties.Key("DEdge.TYPE");
    private static final int JUNCTION_SIZE = 4;
    private DLine line;
    private List<DHeadClosedArrow> arrowHeads;
    private List<DOval> junctionCircles;

    @Override
    public void create() {
        int y2;
        int x2;
        int y1;
        int x1;
        List<Point> bendingPoints = this.getProperty(BENDING_POINTS);
        this.line = new DLine(bendingPoints);
        this.line.setLineWidth((Integer)this.getProperty(LINE_WIDTH));
        this.line.setLineStyle((Integer)this.getProperty(LINE_STYLE));
        this.line.setLineColor((RGBV)this.getProperty(LINE_COLOR));
        this.line.setLineCap(3);
        this.addChild(this.line);
        this.arrowHeads = new ArrayList<DHeadClosedArrow>();
        Type type = this.getProperty(TYPE);
        if (type == Type.DIRECTED || type == Type.UNDIRECTED) {
            x1 = bendingPoints.get((int)(bendingPoints.size() - 1)).x;
            y1 = bendingPoints.get((int)(bendingPoints.size() - 1)).y;
            x2 = bendingPoints.get((int)(bendingPoints.size() - 2)).x;
            y2 = bendingPoints.get((int)(bendingPoints.size() - 2)).y;
            this.arrowHeads.add(new DHeadClosedArrow(this.getProperty(TARGET_ARROW_SIZE), x1 + 3 * Integer.signum(x1 - x2), y1, x2, y2));
        }
        if (type == Type.UNDIRECTED) {
            x1 = bendingPoints.get((int)0).x;
            y1 = bendingPoints.get((int)0).y;
            x2 = bendingPoints.get((int)1).x;
            y2 = bendingPoints.get((int)1).y;
            this.arrowHeads.add(new DHeadClosedArrow(this.getProperty(SOURCE_ARROW_SIZE), x1 + 3 * Integer.signum(x1 - x2), y1, x2, y2));
        }
        this.addChildren(this.arrowHeads);
        this.junctionCircles = new ArrayList<DOval>();
        List<Point> junctionPoints = this.getProperty(JUNCTION_POINTS);
        for (Point junctionPoint : junctionPoints) {
            this.junctionCircles.add(new DOval(4, junctionPoint));
        }
        this.addChildren(this.junctionCircles);
    }

    public static class DSelectableEdge
    extends DEdge
    implements DSelectable {
        private static final double IMPLICIT_EDGE_LENGTH_MULTIPLIER = 4.85;
        private List<DLabel.DSelectableLabel> labels;

        @Override
        public void select(boolean selected, String type) {
            RGBV lineColor = selected ? (RGBV)this.getProperty(SELECTED_LINE_COLOR) : (RGBV)this.getProperty(LINE_COLOR);
            int lineWidth = selected ? ((Integer)this.getProperty(SELECTED_LINE_WIDTH)).intValue() : ((Integer)this.getProperty(LINE_WIDTH)).intValue();
            this.line.setLineColor(lineColor);
            this.line.setLineWidth(lineWidth);
            if (this.arrowHeads != null) {
                for (DHeadClosedArrow arrowHead : this.arrowHeads) {
                    arrowHead.setLineColor(lineColor);
                    arrowHead.setFillColor(lineColor);
                    arrowHead.setLineWidth(lineWidth);
                }
            }
            if (this.junctionCircles != null) {
                for (DOval junctionCircle : this.junctionCircles) {
                    junctionCircle.setLineColor(lineColor);
                    junctionCircle.setFillColor(lineColor);
                    junctionCircle.setLineWidth(lineWidth);
                }
            }
        }

        @Override
        public List<DObject> getSelectedObjects() {
            ArrayList<DObject> selectedObjects = new ArrayList<DObject>();
            selectedObjects.add(this.line);
            selectedObjects.addAll(this.arrowHeads);
            selectedObjects.addAll(this.junctionCircles);
            return selectedObjects;
        }

        @Override
        public void create() {
            NLAbstractBase nlObject = KLayDrawUtils.getNLObject(this);
            if (nlObject instanceof NLConnection && ((NLConnection)nlObject).isImplicitSignal() && this.labels != null) {
                for (DLabel.DSelectableLabel label : this.labels) {
                    this.addLabelUnderlyingLine(label);
                }
                return;
            }
            super.create();
            this.select(false, "MAIN_SELECTION");
        }

        public List<DLabel.DSelectableLabel> getLabels() {
            if (this.labels == null) {
                this.labels = new ArrayList<DLabel.DSelectableLabel>();
            }
            return this.labels;
        }

        public void addLabel(DLabel.DSelectableLabel label) {
            if (this.labels == null) {
                this.labels = new ArrayList<DLabel.DSelectableLabel>();
            }
            this.labels.add(label);
        }

        private void addLabelUnderlyingLine(DLabel.DSelectableLabel label) {
            List bendingPoints = (List)this.getProperty(BENDING_POINTS);
            Point lastPoint = (Point)bendingPoints.get(bendingPoints.size() - 1);
            int x1 = lastPoint.x;
            int x2 = ((Point)bendingPoints.get((int)(bendingPoints.size() - 2))).x;
            double labelLength = (double)(Integer.signum(x1 - x2) * label.getSearchText().length()) * 4.85;
            Point startPoint = new Point(lastPoint.x, lastPoint.y);
            Point endPoint = new Point((int)((double)startPoint.x - labelLength), startPoint.y);
            List<Point> underlyingBendingPoints = Arrays.asList(startPoint, endPoint);
            this.line = new DLine(underlyingBendingPoints);
            this.line.setLineWidth((Integer)this.getProperty(LINE_WIDTH));
            this.line.setLineStyle((Integer)this.getProperty(LINE_WIDTH));
            this.line.setLineColor(new RGBV(NLDefaultRenderingConstants.BLACK, true));
            this.line.setLineCap(3);
            this.addChild(this.line);
            this.select(false, "MAIN_SELECTION");
        }
    }

    public static enum Type {
        NONE,
        DIRECTED,
        UNDIRECTED;

    }
}

