/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.draw.obj.design;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Rectangle;
import ro.amiq.dvt.draw.obj.base.DObject;
import ro.amiq.dvt.draw.obj.design.DDesignObject;
import ro.amiq.dvt.draw.obj.interaction.DSearchable;
import ro.amiq.dvt.draw.obj.interaction.DSelectable;
import ro.amiq.dvt.draw.obj.primitive.DLogicCombinationalSym;
import ro.amiq.dvt.draw.obj.primitive.DLogicSequentialSym;
import ro.amiq.dvt.draw.obj.primitive.DPDSwitchSym;
import ro.amiq.dvt.draw.obj.primitive.DText;
import ro.amiq.dvt.draw.obj.utils.DProperties;
import ro.amiq.dvt.draw.obj.utils.RGBV;

public class DLabel
extends DDesignObject
implements DSearchable {
    public static final DProperties.Key<Type> TYPE = new DProperties.Key("DLabel.TYPE");
    public static final DProperties.Key<FontData> FONT = new DProperties.Key("DLabel.FONT");
    public static final DProperties.Key<String> TEXT = new DProperties.Key("DLabel.TEXT");
    protected DText text;

    @Override
    public void create() {
        Rectangle layout = (Rectangle)this.getProperty(LAYOUT);
        Type type = this.getProperty(TYPE);
        if (type == Type.TEXT) {
            this.text = new DText(this.getProperty(TEXT), layout.x, layout.y, layout.width, layout.height, this.getProperty(FONT));
            this.text.setTextColor((RGBV)this.getProperty(LINE_COLOR));
            this.addChild(this.text);
        } else if (type == Type.SEQUENTIAL) {
            DLogicSequentialSym symbol = new DLogicSequentialSym(layout.x, layout.y, layout.width, layout.height);
            this.addChild(symbol);
        } else if (type == Type.COMBINATIONAL) {
            DLogicCombinationalSym symbol = new DLogicCombinationalSym(layout.x, layout.y, layout.width, layout.height);
            this.addChild(symbol);
        } else if (type == Type.POWER_SWITCH) {
            DPDSwitchSym symbol = new DPDSwitchSym(layout.x, layout.y, layout.width, layout.height);
            this.addChild(symbol);
        }
    }

    @Override
    public String getSearchText() {
        return this.getProperty(TYPE) == Type.TEXT ? this.getProperty(TEXT) : null;
    }

    @Override
    public void highlightSearchMatch(DSearchable.Highlight highlight) {
        DText text = (DText)this.getChildren().get(0);
        if (highlight == DSearchable.Highlight.NONE) {
            text.setHighlight(-1, -1);
        } else {
            text.setHighlightColor(highlight.getColor());
            text.setHighlight(1, this.getProperty(TEXT).length() - 1);
        }
    }

    @Override
    public String shortValueString() {
        Type type = this.getProperty(TYPE);
        if (type == Type.TEXT) {
            return this.getProperty(TEXT);
        }
        if (type == Type.SEQUENTIAL) {
            return "SEQUENTIAL";
        }
        if (type == Type.COMBINATIONAL) {
            return "COMBINATIONAL";
        }
        if (type == Type.POWER_SWITCH) {
            return "PDSWITCH";
        }
        return null;
    }

    public static class DSelectableLabel
    extends DLabel
    implements DSelectable {
        private DDesignObject connectedDesignObject;

        public DSelectableLabel(DDesignObject object) {
            this.connectedDesignObject = object;
        }

        public DDesignObject getConnectedDesignObject() {
            return this.connectedDesignObject;
        }

        @Override
        public void select(boolean selected, String type) {
            RGBV lineColor = selected ? (RGBV)this.getProperty(SELECTED_LINE_COLOR) : (RGBV)this.getProperty(LINE_COLOR);
            this.text.setTextColor(lineColor);
        }

        @Override
        public List<DObject> getSelectedObjects() {
            ArrayList<DObject> selectedObjects = new ArrayList<DObject>();
            selectedObjects.add(this.text);
            return selectedObjects;
        }
    }

    public static enum Type {
        TEXT,
        SEQUENTIAL,
        COMBINATIONAL,
        POWER_SWITCH;

    }
}

