/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.draw.obj.design;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.graphics.Rectangle;
import ro.amiq.dvt.draw.obj.base.DObject;
import ro.amiq.dvt.draw.obj.base.DShape;
import ro.amiq.dvt.draw.obj.design.DDesignObject;
import ro.amiq.dvt.draw.obj.interaction.DSelectable;
import ro.amiq.dvt.draw.obj.primitive.DRectangle;
import ro.amiq.dvt.draw.obj.primitive.DRoundRectangle;
import ro.amiq.dvt.draw.obj.utils.DProperties;
import ro.amiq.dvt.draw.obj.utils.RGBV;

public class DModule
extends DDesignObject {
    public static final DProperties.Key<Boolean> ROUNDED = new DProperties.Key("DModule.ROUNDED");
    public static final DProperties.Key<Integer> PD_LINE_Y = new DProperties.Key("DModule.SECTION_YPOSITIONS");
    public static final DProperties.Key<RGBV> PD_FILL_COLOR = new DProperties.Key("DModule.PD_FILL_COLOR");
    public static final DProperties.Key<String> URL = new DProperties.Key("DModule.URL");
    protected DShape rectangle;
    protected DShape pdRectangle;

    @Override
    public void create() {
        Rectangle layout = (Rectangle)this.getProperty(LAYOUT);
        this.rectangle = this.getProperty(ROUNDED) != false ? new DRoundRectangle(layout.x, layout.y, layout.width, layout.height, 10) : new DRectangle(layout.x, layout.y, layout.width, layout.height);
        this.rectangle.setLineStyle((Integer)this.getProperty(LINE_STYLE));
        this.rectangle.setLineWidth((Integer)this.getProperty(LINE_WIDTH));
        this.rectangle.setLineColor((RGBV)this.getProperty(LINE_COLOR));
        this.rectangle.setFillColor((RGBV)this.getProperty(FILL_COLOR));
        this.rectangle.setLineCap(1);
        this.rectangle.setLineAutoScale(true);
        this.addChild(this.rectangle);
        Integer pdLineY = this.getProperty(PD_LINE_Y);
        if (pdLineY != null && this.getProperty(PD_FILL_COLOR) != null) {
            this.pdRectangle = new DRectangle(layout.x, layout.y, layout.width, pdLineY - layout.y);
            this.pdRectangle.setFillColor(this.getProperty(PD_FILL_COLOR));
            this.pdRectangle.setLineStyle((Integer)this.getProperty(LINE_STYLE));
            this.pdRectangle.setLineWidth((Integer)this.getProperty(LINE_WIDTH));
            this.pdRectangle.setLineColor((RGBV)this.getProperty(LINE_COLOR));
            this.pdRectangle.setLineCap(1);
            this.pdRectangle.setLineAutoScale(true);
            this.addChild(this.pdRectangle);
        }
    }

    @Override
    public <T> void setProperty(DProperties.Key<T> key, T value) {
        super.setProperty(key, value);
        if (key == URL) {
            this.rectangle.setURL((String)value);
        }
    }

    public static DModule newInstance(boolean isSelectable, boolean isTop) {
        return isSelectable ? new DSModule(isTop) : new DModule();
    }

    private static class DSModule
    extends DModule
    implements DSelectable {
        private boolean isTop;

        public DSModule(boolean isTop) {
            this.isTop = isTop;
        }

        @Override
        public void select(boolean selected, String type) {
            this.rectangle.setLineColor(selected ? (RGBV)this.getProperty(SELECTED_LINE_COLOR) : (RGBV)this.getProperty(LINE_COLOR));
            this.rectangle.setFillColor(selected && !this.isTop ? (RGBV)this.getProperty(SELECTED_FILL_COLOR) : (RGBV)this.getProperty(FILL_COLOR));
            this.rectangle.setLineWidth(selected ? ((Integer)this.getProperty(SELECTED_LINE_WIDTH)).intValue() : ((Integer)this.getProperty(LINE_WIDTH)).intValue());
            if (this.pdRectangle != null) {
                this.pdRectangle.setLineColor(selected ? (RGBV)this.getProperty(SELECTED_LINE_COLOR) : (RGBV)this.getProperty(LINE_COLOR));
                this.pdRectangle.setFillColor(selected ? (RGBV)this.getProperty(SELECTED_FILL_COLOR) : (RGBV)this.getProperty(PD_FILL_COLOR));
                this.pdRectangle.setLineWidth(selected ? ((Integer)this.getProperty(SELECTED_LINE_WIDTH)).intValue() : ((Integer)this.getProperty(LINE_WIDTH)).intValue());
            }
        }

        @Override
        public List<DObject> getSelectedObjects() {
            ArrayList<DObject> selectedObjects = new ArrayList<DObject>();
            selectedObjects.add(this.rectangle);
            if (this.pdRectangle != null) {
                selectedObjects.add(this.pdRectangle);
            }
            return selectedObjects;
        }
    }
}

