/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.draw.obj.design;

import org.eclipse.swt.graphics.Rectangle;
import ro.amiq.dvt.draw.obj.base.DPath;
import ro.amiq.dvt.draw.obj.base.DShape;
import ro.amiq.dvt.draw.obj.design.DDesignObject;
import ro.amiq.dvt.draw.obj.primitive.DLine;
import ro.amiq.dvt.draw.obj.primitive.DPolygon;
import ro.amiq.dvt.draw.obj.primitive.DRectangle;
import ro.amiq.dvt.draw.obj.utils.DProperties;
import ro.amiq.dvt.draw.obj.utils.RGBV;

public class DPort
extends DDesignObject {
    public static final DProperties.Key<Type> TYPE = new DProperties.Key("DPORT.TYPE");
    private final boolean innerGatePort;

    public boolean isInnerGatePort() {
        return this.innerGatePort;
    }

    public DPort(boolean innerGatePort) {
        this.innerGatePort = innerGatePort;
    }

    @Override
    public void create() {
        Rectangle layout = (Rectangle)this.getProperty(LAYOUT);
        DRectangle rectangle = new DRectangle(layout.x, layout.y, layout.width, layout.height);
        rectangle.setFillColor((RGBV)this.getProperty(LINE_COLOR));
        rectangle.setLineColor((RGBV)this.getProperty(LINE_COLOR));
        rectangle.setLineAutoScale(true);
        this.addChild(rectangle);
        Type type = this.getProperty(TYPE);
        if (type.ordinal() >= Type.DIAMOND.ordinal()) {
            DPath polygon = null;
            switch (type) {
                case DIAMOND: {
                    polygon = new DPolygon(new int[]{layout.x + layout.width / 2, layout.y + 1, layout.x + layout.width - 1, layout.y + layout.height / 2, layout.x + layout.width / 2, layout.y + layout.height - 1, layout.x + 1, layout.y + layout.height / 2});
                    break;
                }
                case NORTH: {
                    polygon = new DPolygon(new int[]{layout.x + 1, layout.y + layout.height - 1, layout.x + layout.width / 2, layout.y + 1, layout.x + layout.width - 1, layout.y + layout.height - 1});
                    break;
                }
                case EAST: {
                    polygon = new DPolygon(new int[]{layout.x + 1, layout.y + 1, layout.x + layout.width - 1, layout.y + layout.height / 2, layout.x + 1, layout.y + layout.height - 1});
                    break;
                }
                case SOUTH: {
                    polygon = new DPolygon(new int[]{layout.x + 1, layout.y + 1, layout.x + layout.width / 2, layout.y + layout.height - 1, layout.x + layout.width - 1, layout.y + 1});
                    break;
                }
                case WEST: {
                    polygon = new DPolygon(new int[]{layout.x + layout.width - 1, layout.y + 1, layout.x + 1, layout.y + layout.height / 2, layout.x + layout.width - 1, layout.y + layout.height - 1});
                    break;
                }
                case BAR: {
                    polygon = new DPolygon(new int[]{layout.x + layout.width + 10, layout.y + 1, layout.x + 1, layout.y + layout.height / 2, layout.x + layout.width - 1, layout.y + layout.height - 1});
                    break;
                }
            }
            if (polygon != null) {
                polygon.setLineColor((RGBV)this.getProperty(FILL_COLOR));
                ((DShape)polygon).setFillColor((RGBV)this.getProperty(FILL_COLOR));
                this.addChild(polygon);
            }
        } else if (type == Type.BAR) {
            int barHeight = layout.height / 3;
            int barOffset = (layout.height - barHeight) / 2;
            DRectangle bar = new DRectangle(layout.x + 1, layout.y + barOffset, layout.width - 2, barHeight);
            bar.setLineColor((RGBV)this.getProperty(FILL_COLOR));
            bar.setFillColor((RGBV)this.getProperty(FILL_COLOR));
            this.addChild(bar);
        } else if (type == Type.CROSS) {
            DLine line1 = new DLine(new int[]{layout.x + 1, layout.y + 1, layout.x + layout.width - 1, layout.y + layout.height - 1});
            line1.setLineColor((RGBV)this.getProperty(FILL_COLOR));
            this.addChild(line1);
            DLine line2 = new DLine(new int[]{layout.x + layout.width - 1, layout.y + 1, layout.x + 1, layout.y + layout.height - 1});
            line2.setLineColor((RGBV)this.getProperty(FILL_COLOR));
            this.addChild(line2);
        }
    }

    public static enum Type {
        NONE,
        BAR,
        CROSS,
        DIAMOND,
        NORTH,
        EAST,
        SOUTH,
        WEST;

    }
}

