/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.draw.obj.primitive;

import java.util.Arrays;
import java.util.List;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import ro.amiq.dvt.draw.obj.base.DPath;
import ro.amiq.dvt.draw.render.DContext;

public class DLine
extends DPath {
    protected final int[] points;
    protected int tolerance;

    public DLine(int[] points) {
        if (points == null || points.length < 4 || points.length % 2 == 1) {
            throw new IllegalArgumentException("DLine must contain at least 2 points (4 coordinates) and an even number of coordinates!");
        }
        this.points = points;
        this.tolerance = 2;
    }

    public DLine(List<Point> points) {
        if (points == null || points.size() < 2) {
            throw new IllegalArgumentException("DLine must contain at least 2 points!");
        }
        int size = points.size();
        this.points = new int[size * 2];
        int i = 0;
        while (i < size) {
            this.points[i * 2] = points.get((int)i).x;
            this.points[i * 2 + 1] = points.get((int)i).y;
            ++i;
        }
        this.tolerance = 2;
    }

    @Override
    protected void paintPath(DContext dc) {
        dc.drawLine(this.points);
    }

    @Override
    public Rectangle computeBounds() {
        int minX = this.points[0];
        int minY = this.points[1];
        int maxX = this.points[0];
        int maxY = this.points[1];
        int i = 2;
        while (i < this.points.length) {
            minX = Math.min(minX, this.points[i]);
            minY = Math.min(minY, this.points[i + 1]);
            maxX = Math.max(maxX, this.points[i]);
            maxY = Math.max(maxY, this.points[i + 1]);
            i += 2;
        }
        return this.computeBoundsWithLineWidthOverflow(minX - this.tolerance, minY - this.tolerance, maxX - minX + this.tolerance * 2, maxY - minY + this.tolerance * 2);
    }

    @Override
    public boolean contains(Point point) {
        if (!super.contains(point)) {
            return false;
        }
        int lwo = this.getLineWidthOverflow();
        Rectangle rectangle = new Rectangle(0, 0, 0, 0);
        int i = 0;
        while (i < this.points.length - 3) {
            int x1 = Math.min(this.points[i], this.points[i + 2]);
            int y1 = Math.min(this.points[i + 1], this.points[i + 3]);
            int x2 = Math.max(this.points[i], this.points[i + 2]);
            int y2 = Math.max(this.points[i + 1], this.points[i + 3]);
            rectangle.x = x1 - this.tolerance - lwo;
            rectangle.y = y1 - this.tolerance - lwo;
            rectangle.width = x2 - x1 + (this.tolerance + lwo) * 2;
            rectangle.height = y2 - y1 + (this.tolerance + lwo) * 2;
            if (rectangle.contains(point)) {
                if (x1 == x2 || y1 == y2) {
                    return true;
                }
                long v2x = (long)point.x - (long)x1;
                long v1y = (long)y2 - (long)y1;
                long v1x = (long)x2 - (long)x1;
                long v2y = (long)point.y - (long)y1;
                long numerator = v2x * v1y - v1x * v2y;
                long denominator = v1x * v1x + v1y * v1y;
                long squareDistance = numerator * numerator / denominator;
                if (squareDistance <= (long)((this.tolerance + lwo) * (this.tolerance + lwo))) {
                    return true;
                }
            }
            i += 2;
        }
        return false;
    }

    @Override
    public String longValueString() {
        return "POINTS = " + Arrays.toString(this.points);
    }
}

