/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.draw.obj.primitive;

import java.util.Arrays;
import java.util.List;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import ro.amiq.dvt.draw.obj.base.DShape;
import ro.amiq.dvt.draw.render.DContext;

public class DPolygon
extends DShape {
    protected final int[] points;

    public DPolygon(int[] points) {
        if (points == null || points.length < 6) {
            throw new IllegalArgumentException("DPolygon must contain at least 3 points!");
        }
        this.points = points;
    }

    public DPolygon(List<Point> points) {
        if (points == null || points.size() < 3) {
            throw new IllegalArgumentException("DPolygon must contain at least 3 points!");
        }
        int size = points.size();
        this.points = new int[size * 2];
        int i = 0;
        while (i < size) {
            this.points[i * 2] = points.get((int)i).x;
            this.points[i * 2 + 1] = points.get((int)i).y;
            ++i;
        }
    }

    @Override
    protected void paintFill(DContext dc) {
        dc.fillPolygon(this.points);
    }

    @Override
    protected void paintPath(DContext dc) {
        dc.drawPolygon(this.points);
    }

    @Override
    public Rectangle computeBounds() {
        int minX = this.points[0];
        int minY = this.points[1];
        int maxX = this.points[0];
        int maxY = this.points[1];
        int i = 2;
        while (i < this.points.length) {
            minX = Math.min(minX, this.points[i]);
            minY = Math.min(minY, this.points[i + 1]);
            maxX = Math.max(maxX, this.points[i]);
            maxY = Math.max(maxY, this.points[i + 1]);
            i += 2;
        }
        return this.computeBoundsWithLineWidthOverflow(minX, minY, maxX - minX, maxY - minY);
    }

    @Override
    public boolean contains(Point point) {
        if (!super.contains(point)) {
            return false;
        }
        boolean isOdd = false;
        int n = this.points.length;
        int px = this.points[n - 2];
        int py = this.points[n - 1];
        int i = 0;
        while (i < n) {
            int cx = this.points[i++];
            int cy = this.points[i++];
            if (!(point.y < py && point.y < cy || point.y > py && point.y > cy)) {
                int crossProduct = (cx - point.x) * (py - point.y) - (cy - point.y) * (px - point.x);
                if (crossProduct == 0) {
                    if (!(point.x < px && point.x < cx || point.x > px && point.x > cx)) {
                        return true;
                    }
                } else if (py <= point.y && point.y < cy && crossProduct > 0 || cy <= point.y && point.y < py && crossProduct < 0) {
                    isOdd = !isOdd;
                }
            }
            px = cx;
            py = cy;
        }
        return isOdd;
    }

    @Override
    public String longValueString() {
        return "POINTS = " + Arrays.toString(this.points);
    }
}

