/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.draw.obj.primitive;

import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import ro.amiq.dvt.draw.obj.base.DGroup;
import ro.amiq.dvt.draw.obj.base.DPrimitive;
import ro.amiq.dvt.draw.obj.utils.RGBV;
import ro.amiq.dvt.draw.render.DContext;
import ro.amiq.dvt.draw.utils.ColorFactory;
import ro.amiq.dvt.draw.utils.FontFactory;

public class DText
extends DPrimitive {
    private RGB textColor = ColorFactory.getInstance().getRGB(0, 0, 0);
    private boolean textVisible = true;
    private final String text;
    private final FontData fontData;
    private final int x;
    private final int y;
    private final int width;
    private final int height;
    private RGB highlightColor = ColorFactory.getInstance().getRGB(255, 255, 255);
    private Rectangle highlightBounds = null;

    public DText(String text, int x, int y, FontData fontData) {
        this(text, x, y, FontFactory.getInstance().stringExtent(text, fontData), fontData);
    }

    private DText(String text, int x, int y, Point size, FontData fontData) {
        this(text, x, y, size.x, size.y, fontData);
    }

    public DText(String text, int x, int y, int width, int height, FontData fontData) {
        this.text = text;
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.fontData = fontData;
    }

    public RGB getHighlightColor() {
        return this.highlightColor;
    }

    public Rectangle getHighlightBounds() {
        return this.highlightBounds;
    }

    public String getText() {
        return this.text;
    }

    public FontData getFontData() {
        return this.fontData;
    }

    public void setTextColor(RGB color) {
        this.textColor = color;
    }

    public void setTextVisible(boolean visible) {
        this.textVisible = visible;
    }

    public boolean isTextVisible() {
        return this.textVisible;
    }

    public void setTextColor(RGBV color) {
        this.textColor = color.getRGB();
        this.textVisible = color.isVisible();
    }

    public void setHighlightColor(RGB color) {
        this.highlightColor = color;
    }

    public void setHighlight(int start, int end) {
        if (start > end || end > this.text.length()) {
            throw new IllegalArgumentException("DText highlight ranges must have start < end < text length!");
        }
        if (start == end || start == -1 || end == -1) {
            this.highlightBounds = null;
            return;
        }
        Point p1 = FontFactory.getInstance().stringExtent(this.text.substring(0, start), this.fontData);
        Point p2 = FontFactory.getInstance().stringExtent(this.text.substring(start, end), this.fontData);
        this.highlightBounds = new Rectangle(this.x + p1.x, this.y, p2.x, this.height);
    }

    @Override
    public void paint(DContext dc) {
        if (this.textVisible && dc.getQuality().isTextVisible(dc.getExpScale(), this.getBounds())) {
            if (this.highlightBounds != null) {
                dc.setBackground(this.highlightColor);
                dc.fillRectangle(this.highlightBounds.x, this.highlightBounds.y, this.highlightBounds.width, this.highlightBounds.height, null);
            }
            dc.setForeground(this.textColor);
            dc.setFont(this.fontData);
            dc.drawText(this.text, this.x, this.y, this.width, this.height);
        }
    }

    @Override
    public Rectangle computeBounds() {
        return new Rectangle(this.x, this.y, this.width, this.height);
    }

    @Override
    public String shortValueString() {
        return this.text;
    }

    @Override
    public String longValueString() {
        StringBuilder sb = new StringBuilder();
        sb.append('[').append(this.fontData.getName()).append(", ").append(this.fontData.getHeight()).append(", ").append(this.fontData.getStyle()).append(']');
        return sb.toString();
    }

    public static DGroup createCenteredMultiline(String text, FontData fontData) {
        String[] lines;
        DGroup group = new DGroup();
        int width = 0;
        String[] stringArray = lines = text.split("\\R");
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            width = Math.max(width, FontFactory.getInstance().stringExtent((String)line, (FontData)fontData).x);
            ++n2;
        }
        int height = 0;
        String[] stringArray2 = lines;
        int n3 = lines.length;
        n = 0;
        while (n < n3) {
            String line = stringArray2[n];
            Point size = FontFactory.getInstance().stringExtent(line, fontData);
            group.addChild(new DText(line, (width - size.x) / 2, height, size.x, size.y, fontData));
            height += size.y;
            ++n;
        }
        return group;
    }
}

