/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.draw.render;

import java.util.ArrayList;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import ro.amiq.dvt.draw.render.DGraphics;
import ro.amiq.dvt.draw.render.DQuality;
import ro.amiq.dvt.draw.utils.ColorFactory;
import ro.amiq.dvt.draw.utils.FontFactory;

public class DContext {
    public long debugPaintsTotal = 0L;
    public long debugPaintsVisible = 0L;
    public long debugPaintsGroup = 0L;
    public long debugPaintsPrimitive = 0L;
    public long debugGCSets = 0L;
    public long debugGCDraws = 0L;
    public static final int S_DRAW = 1;
    public static final int S_LINE = 2;
    public static final int S_FILL = 4;
    public static final int S_TEXT = 8;
    private final State defaultState;
    private final StateStack stateStack;
    private final double expScale;
    private State cxState;
    private State gcState;
    private final DGraphics graphics;

    public DContext(DGraphics graphics, double expScale) {
        this.graphics = graphics;
        this.expScale = expScale;
        this.defaultState = new State();
        this.defaultState.bounds = graphics.getBounds();
        this.defaultState.fontData = FontFactory.getInstance().getFontData("Sans", 10, 0);
        this.defaultState.lineWidth = 1;
        this.defaultState.lineCap = 2;
        this.defaultState.lineJoin = 2;
        this.defaultState.lineStyle = 1;
        this.defaultState.foreground = ColorFactory.getInstance().getRGB(0, 0, 0);
        this.defaultState.background = ColorFactory.getInstance().getRGB(255, 255, 255);
        this.stateStack = new StateStack(this.defaultState);
        this.gcState = new State();
        this.gcState.set(this.defaultState);
        this.cxState = this.stateStack.pushState();
        this.updateAllStates();
    }

    public DGraphics getGraphics() {
        return this.graphics;
    }

    public void dispose() {
        this.stateStack.clear();
        this.graphics.dispose();
    }

    private final void updateAllStates() {
        this.updateState(-1, true);
    }

    private final void updateState(int s) {
        this.updateState(s, false);
    }

    private final void updateState(int s, boolean force) {
        if ((1 & s) != 0 && (!this.gcState.bounds.equals((Object)this.cxState.bounds) || force)) {
            this.gcState.bounds = this.cxState.bounds;
            this.graphics.setClipping(this.gcState.bounds.x, this.gcState.bounds.y, this.gcState.bounds.width, this.gcState.bounds.height);
            ++this.debugGCSets;
        }
        if ((2 & s) != 0) {
            if (this.gcState.lineWidth != this.cxState.lineWidth || force) {
                this.gcState.lineWidth = this.cxState.lineWidth;
                this.graphics.setLineWidth(this.gcState.lineWidth);
                ++this.debugGCSets;
            }
            if (this.gcState.lineCap != this.cxState.lineCap || force) {
                this.gcState.lineCap = this.cxState.lineCap;
                this.graphics.setLineCap(this.gcState.lineCap);
                ++this.debugGCSets;
            }
            if (this.gcState.lineJoin != this.cxState.lineJoin || force) {
                this.gcState.lineJoin = this.cxState.lineJoin;
                this.graphics.setLineJoin(this.gcState.lineJoin);
                ++this.debugGCSets;
            }
            if (this.gcState.lineStyle != this.cxState.lineStyle || force) {
                this.gcState.lineStyle = this.cxState.lineStyle;
                this.graphics.setLineStyle(this.gcState.lineStyle);
                ++this.debugGCSets;
            }
            if (!this.gcState.foreground.equals((Object)this.cxState.foreground) || force) {
                this.gcState.foreground = this.cxState.foreground;
                this.graphics.setForeground(this.gcState.foreground);
                ++this.debugGCSets;
            }
        }
        if ((4 & s) != 0 && (!this.gcState.background.equals((Object)this.cxState.background) || force)) {
            this.gcState.background = this.cxState.background;
            this.graphics.setBackground(this.gcState.background);
            ++this.debugGCSets;
        }
        if ((8 & s) != 0) {
            if (!this.gcState.fontData.equals((Object)this.cxState.fontData) || force) {
                this.gcState.fontData = this.cxState.fontData;
                this.graphics.setFont(this.gcState.fontData);
                ++this.debugGCSets;
            }
            if (!this.gcState.foreground.equals((Object)this.cxState.foreground) || force) {
                this.gcState.foreground = this.cxState.foreground;
                this.graphics.setForeground(this.gcState.foreground);
                ++this.debugGCSets;
            }
        }
        this.graphics.updateState(s);
    }

    public final void openContext() {
        this.cxState = this.stateStack.pushState();
    }

    public final void closeContext() {
        this.cxState = this.stateStack.popState();
    }

    public final double getExpScale() {
        return this.expScale;
    }

    public final DQuality getQuality() {
        return this.graphics.getQuality();
    }

    public final Rectangle getBounds() {
        return this.cxState.bounds;
    }

    public final void setFont(FontData fontData) {
        this.cxState.fontData = fontData;
    }

    public void setLineWidth(int width) {
        this.cxState.lineWidth = width;
    }

    public void setLineCap(int cap) {
        this.cxState.lineCap = cap;
    }

    public void setLineJoin(int join) {
        this.cxState.lineJoin = join;
    }

    public void setLineStyle(int style) {
        this.cxState.lineStyle = style;
    }

    public void setForeground(RGB color) {
        this.cxState.foreground = color;
    }

    public void setBackground(RGB color) {
        this.cxState.background = color;
    }

    public void drawLine(int ... points) {
        this.updateState(3);
        if (points.length == 4) {
            this.graphics.drawLine(points[0], points[1], points[2], points[3]);
        } else {
            this.graphics.drawPolyline(points);
        }
        ++this.debugGCDraws;
    }

    public void drawPath(int ... points) {
        this.updateState(3);
        if (points.length == 4) {
            this.graphics.drawLine(points[0], points[1], points[2], points[3]);
        } else {
            this.graphics.drawPath(points);
        }
        ++this.debugGCDraws;
    }

    public void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.updateState(3);
        this.graphics.drawArc(x, y, width, height, startAngle, arcAngle);
        ++this.debugGCDraws;
    }

    public final void drawPolygon(int ... points) {
        this.updateState(3);
        this.graphics.drawPolygon(points);
        ++this.debugGCDraws;
    }

    public final void fillPolygon(int ... points) {
        this.updateState(5);
        this.graphics.fillPolygon(points);
        ++this.debugGCDraws;
    }

    public final void drawRectangle(int x, int y, int width, int height) {
        this.updateState(3);
        this.graphics.drawRectangle(x, y, width, height);
        ++this.debugGCDraws;
    }

    public final void fillRectangle(int x, int y, int width, int height, String url) {
        this.updateState(5);
        this.graphics.fillRectangle(x, y, width, height, url);
        ++this.debugGCDraws;
    }

    public final void drawRoundRectangle(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.updateState(3);
        this.graphics.drawRoundRectangle(x, y, width, height, arcWidth, arcHeight);
        ++this.debugGCDraws;
    }

    public final void fillRoundRectangle(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.updateState(5);
        this.graphics.fillRoundRectangle(x, y, width, height, arcWidth, arcHeight);
        ++this.debugGCDraws;
    }

    public final void drawOval(int x, int y, int width, int height) {
        this.updateState(3);
        this.graphics.drawOval(x, y, width, height);
        ++this.debugGCDraws;
    }

    public final void fillOval(int x, int y, int width, int height) {
        this.updateState(5);
        this.graphics.fillOval(x, y, width, height);
        ++this.debugGCDraws;
    }

    public final void drawText(String text, int x, int y, int width, int height) {
        this.updateState(9);
        this.graphics.drawText(text, x, y, width, height);
        ++this.debugGCDraws;
    }

    private static final class State {
        public Rectangle bounds;
        public FontData fontData;
        public int lineWidth;
        public int lineCap;
        public int lineJoin;
        public int lineStyle;
        public RGB foreground;
        public RGB background;

        public void set(State state) {
            this.bounds = state.bounds;
            this.fontData = state.fontData;
            this.lineWidth = state.lineWidth;
            this.lineCap = state.lineCap;
            this.lineJoin = state.lineJoin;
            this.lineStyle = state.lineStyle;
            this.foreground = state.foreground;
            this.background = state.background;
        }
    }

    private static final class StateStack {
        private final State defaultState;
        private final ArrayList<State> stack;
        private int index;

        public StateStack(State defaultState) {
            this.defaultState = defaultState;
            this.stack = new ArrayList();
            this.index = -1;
        }

        public State pushState() {
            ++this.index;
            State newState = null;
            if (this.stack.size() > this.index) {
                newState = this.stack.get(this.index);
            } else {
                newState = new State();
                this.stack.add(newState);
            }
            newState.set(this.defaultState);
            return newState;
        }

        public State popState() {
            return this.stack.get(--this.index);
        }

        public void clear() {
            this.stack.clear();
            this.index = -1;
        }
    }
}

