/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.draw.render;

import java.util.List;
import org.eclipse.swt.graphics.Rectangle;
import ro.amiq.dvt.diagrams.uml.draw.obj.DUMLContainer;
import ro.amiq.dvt.draw.obj.base.DGroup;
import ro.amiq.dvt.draw.obj.base.DObject;
import ro.amiq.dvt.draw.obj.design.DModule;
import ro.amiq.dvt.draw.obj.design.DPort;
import ro.amiq.dvt.draw.render.DContext;
import ro.amiq.dvt.draw.render.DGraphics;
import ro.amiq.dvt.draw.render.svg.DSVGGraphics;

public interface DRenderer {
    default public void paint(DObject object, DContext dc) {
        DGraphics graphics = dc.getGraphics();
        if (dc.debugPaintsTotal == 0L && graphics instanceof DSVGGraphics) {
            ((DSVGGraphics)graphics).resetMarkerID();
        }
        ++dc.debugPaintsTotal;
        Rectangle intersection = object.intersection(dc.getBounds());
        if (intersection == null || intersection.isEmpty()) {
            return;
        }
        ++dc.debugPaintsVisible;
        dc.openContext();
        object.paint(dc);
        if (object instanceof DGroup) {
            if (!dc.getQuality().isShapeVisible(dc.getExpScale(), object.getBounds())) {
                return;
            }
            ++dc.debugPaintsGroup;
            List<DObject> children = ((DGroup)object).getChildren();
            if (children != null) {
                if (graphics instanceof DSVGGraphics) {
                    DSVGGraphics svgGraphics = (DSVGGraphics)graphics;
                    int parentID = svgGraphics.getRectangleID();
                    for (DObject child : children) {
                        if (child instanceof DModule || child instanceof DUMLContainer || child instanceof DPort) {
                            svgGraphics.incrementRectangleID();
                            this.paint(child, dc);
                            continue;
                        }
                        int currentID = svgGraphics.getRectangleID();
                        svgGraphics.setRectangleID(parentID);
                        this.paint(child, dc);
                        svgGraphics.setRectangleID(currentID);
                    }
                } else {
                    for (DObject child : children) {
                        this.paint(child, dc);
                    }
                }
            }
        } else {
            ++dc.debugPaintsPrimitive;
        }
        dc.closeContext();
    }
}

