/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.draw.render.canvas;

import com.google.gson.JsonArray;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import ro.amiq.dvt.diagrams.wave.draw.obj.IWDModel;
import ro.amiq.dvt.draw.DExporter;
import ro.amiq.dvt.draw.obj.base.DObject;
import ro.amiq.dvt.draw.obj.utils.DProperties;
import ro.amiq.dvt.draw.render.DContext;
import ro.amiq.dvt.draw.render.DRenderer;
import ro.amiq.dvt.draw.render.canvas.DCanvasGraphics;
import ro.amiq.dvt.draw.render.canvas.DWaveGraphics;
import ro.amiq.dvt.draw.render.canvas.Instructions;
import ro.amiq.dvt.draw.render.svg.DSVGGraphics;
import ro.amiq.dvt.startup.core.DVTLogger;

public enum DCanvasExporter implements DExporter.DExporterImplementation,
DRenderer
{
    INSTANCE;


    @Override
    public void export(File file, DObject content, double expScale, DProperties properties) throws IOException {
    }

    @Override
    public String export(DObject content, double expScale, DProperties properties) {
        return null;
    }

    public JsonArray export(DObject content) {
        DContext dc = null;
        DCanvasGraphics graphics = null;
        try {
            graphics = new DCanvasGraphics(content.getBounds());
            dc = new DContext(graphics, 1.0);
            this.paint(content, dc);
            JsonArray jsonArray = graphics.getInstructions();
            return jsonArray;
        }
        finally {
            if (dc != null) {
                dc.dispose();
            }
        }
    }

    public Instructions.Builder exportWaveViewer(IWDModel drawModel) {
        DContext dc = null;
        DWaveGraphics graphics = null;
        try {
            graphics = new DWaveGraphics(drawModel.getCanvasBackground().getBounds());
            dc = new DContext(graphics, 1.0);
            drawModel.paint(dc);
            Instructions.Builder builder = graphics.getInstructions();
            return builder;
        }
        finally {
            if (dc != null) {
                dc.dispose();
            }
        }
    }

    public void exportAsSVG(Path path, IWDModel drawModel) {
        DContext dc = null;
        DSVGGraphics graphics = null;
        try {
            try {
                graphics = new DSVGGraphics(drawModel.getCanvasBackground().getBounds(), true, false);
                dc = new DContext(graphics, 1.0);
                drawModel.paint(dc);
                String[] svgDocument = graphics.getSVGDocument();
                Files.write(path, svgDocument[0].getBytes(), new OpenOption[0]);
            }
            catch (IOException e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                if (dc != null) {
                    dc.dispose();
                }
            }
        }
        finally {
            if (dc != null) {
                dc.dispose();
            }
        }
    }
}

