/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.draw.render.canvas;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Arrays;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import ro.amiq.dvt.draw.render.DGraphics;
import ro.amiq.dvt.draw.render.DQuality;
import ro.amiq.dvt.draw.utils.AWTUtils;
import ro.amiq.dvt.draw.utils.ColorFactory;
import ro.amiq.dvt.draw.utils.FontFactory;

public class DCanvasGraphics
implements DGraphics {
    private static final String INSTR = "instruction";
    private static final String X = "x";
    private static final String Y = "y";
    private static final String X1 = "x1";
    private static final String Y1 = "y1";
    private static final String X2 = "x2";
    private static final String Y2 = "y2";
    private static final String WIDTH = "width";
    private static final String HEIGHT = "height";
    private static final String STROKE_COLOR = "strokeColor";
    private static final String FILL_COLOR = "fillColor";
    private static final String POINTS = "points";
    private static final String CAP = "lineCap";
    private static final String JOIN = "lineJoin";
    private static final String LINE_WIDTH = "lineWidth";
    private static final String LINE_STYLE = "lineStyle";
    private static final String ARC_ANGLE = "arcAngle";
    private static final String ARC_WIDTH = "arcWidth";
    private static final String ARC_HEIGHT = "arcHeight";
    private static final String START_ANGLE = "startAngle";
    private static final String TEXT = "text";
    private static final String FONT_NAME = "fontName";
    private static final String FONT_WEIGHT = "fontWeight";
    private static final String CAP_BUTT = "butt";
    private static final String CAP_ROUND = "round";
    private static final String CAP_SQUARE = "square";
    private static final String JOIN_BEVEL = "bevel";
    private static final String JOIN_MITER = "miter";
    private static final String JOIN_ROUND = "round";
    private static final String FONT_NORMAL = "normal";
    private static final String FONT_BOLD = "bold";
    private final Rectangle bounds;
    private JsonArray instructions = new JsonArray();
    private int fontAscent;
    private int lineWidth;
    private String fontName;
    private String fontWeight;
    private String foreground;
    private String background;
    private String lineCap;
    private String lineJoin;

    public DCanvasGraphics(Rectangle bounds) {
        this.bounds = bounds;
    }

    @Override
    public Rectangle getBounds() {
        return this.bounds;
    }

    @Override
    public void setClipping(int x, int y, int width, int height) {
        JsonObject setContentBounds = new JsonObject();
        setContentBounds.addProperty(INSTR, "setContentBounds");
        setContentBounds.addProperty(X, (Number)x);
        setContentBounds.addProperty(Y, (Number)y);
        setContentBounds.addProperty(WIDTH, (Number)width);
        setContentBounds.addProperty(HEIGHT, (Number)height);
        this.instructions.add((JsonElement)setContentBounds);
    }

    @Override
    public void setFont(FontData fontData) {
        int style = fontData.getStyle();
        if (style == 0) {
            this.fontWeight = FONT_NORMAL;
        } else if (style == 1) {
            this.fontWeight = FONT_BOLD;
        }
        this.fontName = fontData.getName();
        this.fontAscent = FontFactory.getInstance().fontAscent(fontData);
    }

    @Override
    public void setLineWidth(int width) {
        this.lineWidth = width;
    }

    @Override
    public void setLineCap(int cap) {
        if (cap == 1) {
            this.lineCap = CAP_BUTT;
        } else if (cap == 2) {
            this.lineCap = "round";
        } else if (cap == 3) {
            this.lineCap = CAP_SQUARE;
        }
    }

    @Override
    public void setLineJoin(int join) {
        if (join == 1) {
            this.lineJoin = JOIN_MITER;
        } else if (join == 2) {
            this.lineJoin = "round";
        } else if (join == 3) {
            this.lineJoin = JOIN_BEVEL;
        }
    }

    @Override
    public void setLineStyle(int style) {
        int[] lineStyle;
        float[] floatValues = AWTUtils.convertSWTLineStyleToAWTDashPattern(style);
        if (floatValues == null) {
            lineStyle = new int[]{};
        } else {
            lineStyle = new int[floatValues.length];
            int i = 0;
            while (i < floatValues.length) {
                lineStyle[i] = (int)floatValues[i];
                ++i;
            }
        }
        JsonObject setLineStyle = new JsonObject();
        setLineStyle.addProperty(INSTR, "setLineStyle");
        setLineStyle.addProperty(LINE_STYLE, Arrays.toString(lineStyle));
        this.instructions.add((JsonElement)setLineStyle);
    }

    @Override
    public void setForeground(RGB rgb) {
        this.foreground = String.format("#%02x%02x%02x", rgb.red, rgb.green, rgb.blue);
    }

    @Override
    public void setBackground(RGB rgb) {
        ColorFactory.getInstance().invertRGB(rgb);
        this.background = String.format("#%02x%02x%02x", rgb.red, rgb.green, rgb.blue);
    }

    @Override
    public void drawLine(int x1, int y1, int x2, int y2) {
        JsonObject drawLine = new JsonObject();
        drawLine.addProperty(INSTR, "d");
        drawLine.addProperty(X1, (Number)x1);
        drawLine.addProperty(Y1, (Number)y1);
        drawLine.addProperty(X2, (Number)x2);
        drawLine.addProperty(Y2, (Number)y2);
        this.setStrokeAttrs(drawLine);
        this.instructions.add((JsonElement)drawLine);
    }

    @Override
    public void drawPolyline(int[] points) {
        JsonObject drawPolyline = new JsonObject();
        drawPolyline.addProperty(INSTR, "drawPolyline");
        drawPolyline.addProperty(POINTS, Arrays.toString(points));
        this.setStrokeAttrs(drawPolyline);
        this.instructions.add((JsonElement)drawPolyline);
    }

    @Override
    public void drawPath(int[] points) {
        JsonObject drawPath = new JsonObject();
        drawPath.addProperty(INSTR, "drawPath");
        drawPath.addProperty(POINTS, Arrays.toString(points));
        this.setStrokeAttrs(drawPath);
        this.instructions.add((JsonElement)drawPath);
    }

    @Override
    public void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        JsonObject drawArc = new JsonObject();
        drawArc.addProperty(INSTR, "drawArc");
        drawArc.addProperty(X, (Number)x);
        drawArc.addProperty(Y, (Number)y);
        drawArc.addProperty(WIDTH, (Number)width);
        drawArc.addProperty(HEIGHT, (Number)height);
        drawArc.addProperty(START_ANGLE, (Number)startAngle);
        drawArc.addProperty(ARC_ANGLE, (Number)arcAngle);
        this.instructions.add((JsonElement)drawArc);
    }

    @Override
    public void drawPolygon(int[] points) {
        JsonObject drawPolygon = new JsonObject();
        drawPolygon.addProperty(INSTR, "drawPolygon");
        drawPolygon.addProperty(POINTS, Arrays.toString(points));
        drawPolygon.addProperty(FILL_COLOR, this.background);
        this.setStrokeAttrs(drawPolygon);
        this.instructions.add((JsonElement)drawPolygon);
    }

    @Override
    public void fillPolygon(int[] points) {
        JsonObject fillPolygon = new JsonObject();
        fillPolygon.addProperty(INSTR, "fillPolygon");
        fillPolygon.addProperty(POINTS, Arrays.toString(points));
        fillPolygon.addProperty(FILL_COLOR, this.background);
        this.setStrokeAttrs(fillPolygon);
        this.instructions.add((JsonElement)fillPolygon);
    }

    @Override
    public void drawRectangle(int x, int y, int width, int height) {
        JsonObject drawRectangle = new JsonObject();
        drawRectangle.addProperty(INSTR, "drawRectangle");
        drawRectangle.addProperty(X, (Number)x);
        drawRectangle.addProperty(Y, (Number)y);
        drawRectangle.addProperty(WIDTH, (Number)width);
        drawRectangle.addProperty(HEIGHT, (Number)height);
        drawRectangle.addProperty(FILL_COLOR, this.background);
        this.setStrokeAttrs(drawRectangle);
        this.instructions.add((JsonElement)drawRectangle);
    }

    @Override
    public void fillRectangle(int x, int y, int width, int height, String url) {
        JsonObject fillRectangle = new JsonObject();
        fillRectangle.addProperty(INSTR, "fillRectangle");
        fillRectangle.addProperty(X, (Number)x);
        fillRectangle.addProperty(Y, (Number)y);
        fillRectangle.addProperty(WIDTH, (Number)width);
        fillRectangle.addProperty(HEIGHT, (Number)height);
        fillRectangle.addProperty(FILL_COLOR, this.background);
        this.setStrokeAttrs(fillRectangle);
        this.instructions.add((JsonElement)fillRectangle);
    }

    @Override
    public void drawRoundRectangle(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        JsonObject drawRoundRectangle = new JsonObject();
        drawRoundRectangle.addProperty(INSTR, "drawRoundRectangle");
        drawRoundRectangle.addProperty(X, (Number)x);
        drawRoundRectangle.addProperty(Y, (Number)y);
        drawRoundRectangle.addProperty(WIDTH, (Number)width);
        drawRoundRectangle.addProperty(HEIGHT, (Number)height);
        drawRoundRectangle.addProperty(ARC_WIDTH, (Number)arcWidth);
        drawRoundRectangle.addProperty(ARC_HEIGHT, (Number)arcHeight);
        drawRoundRectangle.addProperty(FILL_COLOR, this.background);
        this.setStrokeAttrs(drawRoundRectangle);
        this.instructions.add((JsonElement)drawRoundRectangle);
    }

    @Override
    public void fillRoundRectangle(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        JsonObject fillRoundRectangle = new JsonObject();
        fillRoundRectangle.addProperty(INSTR, "fillRoundRectangle");
        fillRoundRectangle.addProperty(X, (Number)x);
        fillRoundRectangle.addProperty(Y, (Number)y);
        fillRoundRectangle.addProperty(WIDTH, (Number)width);
        fillRoundRectangle.addProperty(HEIGHT, (Number)height);
        fillRoundRectangle.addProperty(ARC_WIDTH, (Number)arcWidth);
        fillRoundRectangle.addProperty(ARC_HEIGHT, (Number)arcHeight);
        fillRoundRectangle.addProperty(FILL_COLOR, this.background);
        this.setStrokeAttrs(fillRoundRectangle);
        this.instructions.add((JsonElement)fillRoundRectangle);
    }

    @Override
    public void drawOval(int x, int y, int width, int height) {
        JsonObject drawOval = new JsonObject();
        drawOval.addProperty(INSTR, "drawOval");
        drawOval.addProperty(X, (Number)x);
        drawOval.addProperty(Y, (Number)y);
        drawOval.addProperty(WIDTH, (Number)width);
        drawOval.addProperty(HEIGHT, (Number)height);
        drawOval.addProperty(FILL_COLOR, this.background);
        this.setStrokeAttrs(drawOval);
        this.instructions.add((JsonElement)drawOval);
    }

    @Override
    public void fillOval(int x, int y, int width, int height) {
        JsonObject fillOval = new JsonObject();
        fillOval.addProperty(INSTR, "fillOval");
        fillOval.addProperty(X, (Number)x);
        fillOval.addProperty(Y, (Number)y);
        fillOval.addProperty(WIDTH, (Number)width);
        fillOval.addProperty(HEIGHT, (Number)height);
        fillOval.addProperty(FILL_COLOR, this.background);
        this.setStrokeAttrs(fillOval);
        this.instructions.add((JsonElement)fillOval);
    }

    @Override
    public void drawText(String text, int x, int y, int width, int height) {
        JsonObject drawText = new JsonObject();
        drawText.addProperty(INSTR, "drawText");
        drawText.addProperty(TEXT, text);
        drawText.addProperty(X, (Number)x);
        drawText.addProperty(Y, (Number)(y + this.fontAscent));
        drawText.addProperty(WIDTH, (Number)width);
        drawText.addProperty(FONT_WEIGHT, this.fontWeight);
        drawText.addProperty(HEIGHT, (Number)height);
        drawText.addProperty(FONT_NAME, this.fontName);
        drawText.addProperty(FILL_COLOR, this.foreground);
        this.instructions.add((JsonElement)drawText);
    }

    @Override
    public void updateState(int state) {
    }

    @Override
    public DQuality getQuality() {
        return DQuality.SUPER;
    }

    @Override
    public void dispose() {
    }

    public JsonArray getInstructions() {
        return this.instructions;
    }

    private void setStrokeAttrs(JsonObject obj) {
        obj.addProperty(STROKE_COLOR, this.foreground);
        obj.addProperty(CAP, this.lineCap);
        obj.addProperty(JOIN, this.lineJoin);
        obj.addProperty(LINE_WIDTH, (Number)this.lineWidth);
    }
}

