/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.draw.render.canvas;

import java.util.Arrays;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import ro.amiq.dvt.draw.render.DGraphics;
import ro.amiq.dvt.draw.render.DQuality;
import ro.amiq.dvt.draw.render.canvas.Instruction;
import ro.amiq.dvt.draw.render.canvas.Instructions;
import ro.amiq.dvt.draw.utils.AWTUtils;
import ro.amiq.dvt.draw.utils.ColorFactory;
import ro.amiq.dvt.draw.utils.FontFactory;

public class DWaveGraphics
implements DGraphics {
    private static final String CAP_BUTT = "butt";
    private static final String CAP_ROUND = "round";
    private static final String CAP_SQUARE = "square";
    private static final String JOIN_BEVEL = "bevel";
    private static final String JOIN_MITER = "miter";
    private static final String JOIN_ROUND = "round";
    private static final String FONT_NORMAL = "normal";
    private static final String FONT_BOLD = "bold";
    private final Rectangle bounds;
    private Instructions.Builder instructions = Instructions.newBuilder();
    private int fontAscent;
    private int lineWidth;
    private String fontName;
    private String fontWeight;
    private String foreground;
    private String background;
    private String lineCap;
    private String lineJoin;

    public DWaveGraphics(Rectangle bounds) {
        this.bounds = bounds;
    }

    @Override
    public Rectangle getBounds() {
        return this.bounds;
    }

    @Override
    public void setClipping(int x, int y, int width, int height) {
        Instruction.Builder setContentBoundsInstruction = Instruction.newBuilder();
        setContentBoundsInstruction.setInstruction("setContentBounds");
        setContentBoundsInstruction.setX(x);
        setContentBoundsInstruction.setY(y);
        setContentBoundsInstruction.setWidth(width);
        setContentBoundsInstruction.setHeight(height);
        this.instructions.addInstruction(setContentBoundsInstruction);
    }

    @Override
    public void setFont(FontData fontData) {
        int style = fontData.getStyle();
        if (style == 0) {
            this.fontWeight = FONT_NORMAL;
        } else if (style == 1) {
            this.fontWeight = FONT_BOLD;
        }
        this.fontName = fontData.getName();
        this.fontAscent = FontFactory.getInstance().fontAscent(fontData);
    }

    @Override
    public void setLineWidth(int width) {
        this.lineWidth = width;
    }

    @Override
    public void setLineCap(int cap) {
        if (cap == 1) {
            this.lineCap = CAP_BUTT;
        } else if (cap == 2) {
            this.lineCap = "round";
        } else if (cap == 3) {
            this.lineCap = CAP_SQUARE;
        }
    }

    @Override
    public void setLineJoin(int join) {
        if (join == 1) {
            this.lineJoin = JOIN_MITER;
        } else if (join == 2) {
            this.lineJoin = "round";
        } else if (join == 3) {
            this.lineJoin = JOIN_BEVEL;
        }
    }

    @Override
    public void setLineStyle(int style) {
        int[] lineStyle;
        float[] floatValues = AWTUtils.convertSWTLineStyleToAWTDashPattern(style);
        if (floatValues == null) {
            lineStyle = new int[]{};
        } else {
            lineStyle = new int[floatValues.length];
            int i = 0;
            while (i < floatValues.length) {
                lineStyle[i] = (int)floatValues[i];
                ++i;
            }
        }
        Instruction.Builder setLineStyleInstruction = Instruction.newBuilder();
        setLineStyleInstruction.setInstruction("setLineStyle");
        setLineStyleInstruction.setLineStyle(Arrays.toString(lineStyle));
        this.instructions.addInstruction(setLineStyleInstruction);
    }

    @Override
    public void setForeground(RGB rgb) {
        this.foreground = String.format("#%02x%02x%02x", rgb.red, rgb.green, rgb.blue);
    }

    @Override
    public void setBackground(RGB rgb) {
        ColorFactory.getInstance().invertRGB(rgb);
        this.background = String.format("#%02x%02x%02x", rgb.red, rgb.green, rgb.blue);
    }

    @Override
    public void drawLine(int x1, int y1, int x2, int y2) {
        Instruction.Builder drawLineInstruction = Instruction.newBuilder();
        drawLineInstruction.setInstruction("d");
        drawLineInstruction.setX1(x1);
        drawLineInstruction.setY1(y1);
        drawLineInstruction.setX2(x2);
        drawLineInstruction.setY2(y2);
        this.setStrokeAttrs(drawLineInstruction);
        this.instructions.addInstruction(drawLineInstruction);
    }

    @Override
    public void drawPolyline(int[] points) {
        Instruction.Builder drawPolylineInstruction = Instruction.newBuilder();
        drawPolylineInstruction.setInstruction("drawPolyline");
        drawPolylineInstruction.setPoints(Arrays.toString(points));
        this.setStrokeAttrs(drawPolylineInstruction);
        this.instructions.addInstruction(drawPolylineInstruction);
    }

    @Override
    public void drawPath(int[] points) {
        Instruction.Builder drawPathInstruction = Instruction.newBuilder();
        drawPathInstruction.setInstruction("drawPath");
        drawPathInstruction.setPoints(Arrays.toString(points));
        this.setStrokeAttrs(drawPathInstruction);
        this.instructions.addInstruction(drawPathInstruction);
    }

    @Override
    public void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        Instruction.Builder drawArcInstruction = Instruction.newBuilder();
        drawArcInstruction.setInstruction("drawArc");
        drawArcInstruction.setX(x);
        drawArcInstruction.setY(y);
        drawArcInstruction.setWidth(width);
        drawArcInstruction.setHeight(height);
        drawArcInstruction.setStartAngle(startAngle);
        drawArcInstruction.setArcAngle(arcAngle);
        this.instructions.addInstruction(drawArcInstruction);
    }

    @Override
    public void drawPolygon(int[] points) {
        Instruction.Builder drawPolygonInstruction = Instruction.newBuilder();
        drawPolygonInstruction.setInstruction("drawPolygon");
        drawPolygonInstruction.setPoints(Arrays.toString(points));
        drawPolygonInstruction.setFillColor(this.background);
        this.setStrokeAttrs(drawPolygonInstruction);
        this.instructions.addInstruction(drawPolygonInstruction);
    }

    @Override
    public void fillPolygon(int[] points) {
        Instruction.Builder fillPolygonInstruction = Instruction.newBuilder();
        fillPolygonInstruction.setInstruction("fillPolygon");
        fillPolygonInstruction.setPoints(Arrays.toString(points));
        fillPolygonInstruction.setFillColor(this.background);
        this.setStrokeAttrs(fillPolygonInstruction);
        this.instructions.addInstruction(fillPolygonInstruction);
    }

    @Override
    public void drawRectangle(int x, int y, int width, int height) {
        Instruction.Builder drawRectangleInstruction = Instruction.newBuilder();
        drawRectangleInstruction.setInstruction("drawRectangle");
        drawRectangleInstruction.setX(x);
        drawRectangleInstruction.setY(y);
        drawRectangleInstruction.setWidth(width);
        drawRectangleInstruction.setHeight(height);
        drawRectangleInstruction.setFillColor(this.background);
        this.setStrokeAttrs(drawRectangleInstruction);
        this.instructions.addInstruction(drawRectangleInstruction);
    }

    @Override
    public void fillRectangle(int x, int y, int width, int height, String url) {
        Instruction.Builder fillRectangleInstruction = Instruction.newBuilder();
        fillRectangleInstruction.setInstruction("fillRectangle");
        fillRectangleInstruction.setX(x);
        fillRectangleInstruction.setY(y);
        fillRectangleInstruction.setWidth(width);
        fillRectangleInstruction.setHeight(height);
        fillRectangleInstruction.setFillColor(this.background);
        this.setStrokeAttrs(fillRectangleInstruction);
        this.instructions.addInstruction(fillRectangleInstruction);
    }

    @Override
    public void drawRoundRectangle(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        Instruction.Builder drawRoundRectangleInstruction = Instruction.newBuilder();
        drawRoundRectangleInstruction.setInstruction("drawRoundRectangle");
        drawRoundRectangleInstruction.setX(x);
        drawRoundRectangleInstruction.setY(y);
        drawRoundRectangleInstruction.setWidth(width);
        drawRoundRectangleInstruction.setHeight(height);
        drawRoundRectangleInstruction.setArcWidth(arcWidth);
        drawRoundRectangleInstruction.setArcHeight(arcHeight);
        drawRoundRectangleInstruction.setFillColor(this.background);
        this.setStrokeAttrs(drawRoundRectangleInstruction);
        this.instructions.addInstruction(drawRoundRectangleInstruction);
    }

    @Override
    public void fillRoundRectangle(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        Instruction.Builder fillRoundRectangleInstruction = Instruction.newBuilder();
        fillRoundRectangleInstruction.setInstruction("fillRoundRectangle");
        fillRoundRectangleInstruction.setX(x);
        fillRoundRectangleInstruction.setY(y);
        fillRoundRectangleInstruction.setWidth(width);
        fillRoundRectangleInstruction.setHeight(height);
        fillRoundRectangleInstruction.setArcWidth(arcWidth);
        fillRoundRectangleInstruction.setArcHeight(arcHeight);
        fillRoundRectangleInstruction.setFillColor(this.background);
        this.setStrokeAttrs(fillRoundRectangleInstruction);
        this.instructions.addInstruction(fillRoundRectangleInstruction);
    }

    @Override
    public void drawOval(int x, int y, int width, int height) {
        Instruction.Builder drawOval = Instruction.newBuilder();
        drawOval.setInstruction("drawOval");
        drawOval.setX(x);
        drawOval.setY(y);
        drawOval.setWidth(width);
        drawOval.setHeight(height);
        drawOval.setFillColor(this.background);
        this.setStrokeAttrs(drawOval);
        this.instructions.addInstruction(drawOval);
    }

    @Override
    public void fillOval(int x, int y, int width, int height) {
        Instruction.Builder fillOvalInstruction = Instruction.newBuilder();
        fillOvalInstruction.setInstruction("fillOval");
        fillOvalInstruction.setX(x);
        fillOvalInstruction.setY(y);
        fillOvalInstruction.setWidth(width);
        fillOvalInstruction.setHeight(height);
        fillOvalInstruction.setFillColor(this.background);
        this.setStrokeAttrs(fillOvalInstruction);
        this.instructions.addInstruction(fillOvalInstruction);
    }

    @Override
    public void drawText(String text, int x, int y, int width, int height) {
        Instruction.Builder drawTextInstruction = Instruction.newBuilder();
        drawTextInstruction.setInstruction("drawText");
        drawTextInstruction.setText(text);
        drawTextInstruction.setX(x);
        drawTextInstruction.setY(y + this.fontAscent);
        drawTextInstruction.setWidth(width);
        drawTextInstruction.setFontWeight(this.fontWeight);
        drawTextInstruction.setHeight(height);
        drawTextInstruction.setFontName(this.fontName);
        drawTextInstruction.setFillColor(this.foreground);
        this.instructions.addInstruction(drawTextInstruction);
    }

    @Override
    public void updateState(int state) {
    }

    @Override
    public DQuality getQuality() {
        return DQuality.SUPER;
    }

    @Override
    public void dispose() {
    }

    public Instructions.Builder getInstructions() {
        return this.instructions;
    }

    private void setStrokeAttrs(Instruction.Builder obj) {
        obj.setStrokeColor(this.foreground);
        obj.setCap(this.lineCap);
        obj.setJoin(this.lineJoin);
        obj.setLineWidth(this.lineWidth);
    }
}

