/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.draw.render.svg;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import ro.amiq.dvt.diagrams.uml.draw.obj.DUMLScene;
import ro.amiq.dvt.draw.DExporter;
import ro.amiq.dvt.draw.obj.base.DObject;
import ro.amiq.dvt.draw.obj.design.DDesignScene;
import ro.amiq.dvt.draw.obj.utils.DProperties;
import ro.amiq.dvt.draw.render.DContext;
import ro.amiq.dvt.draw.render.DRenderer;
import ro.amiq.dvt.draw.render.svg.DSVGGraphics;
import ro.amiq.dvt.startup.core.DVTLogger;

public enum DSVGExporter implements DExporter.DExporterImplementation,
DRenderer
{
    INSTANCE;

    public static final DProperties.Key<File> FONTS_FILE;
    public static final DProperties.Key<Boolean> EMBEDDABLE;

    static {
        FONTS_FILE = new DProperties.Key("DSVGExporter.FONTS_FILE");
        EMBEDDABLE = new DProperties.Key("DSVGExporter.EMBEDDABLE");
    }

    @Override
    public void export(File file, DObject content, double expScale, DProperties properties) throws IOException {
        properties.remove(FONTS_FILE);
        properties.remove(EMBEDDABLE);
        Files.write(file.toPath(), this.export(content, expScale, properties).getBytes(), new OpenOption[0]);
    }

    @Override
    public String export(DObject content, double expScale, DProperties properties) {
        DContext dc = null;
        DSVGGraphics graphics = null;
        try {
            int offset;
            File fontsFile = properties.get(FONTS_FILE);
            graphics = new DSVGGraphics(content.getBounds(), fontsFile == null, content instanceof DUMLScene || content instanceof DDesignScene);
            dc = new DContext(graphics, 1.0);
            this.paint(content, dc);
            String[] result = graphics.getSVGDocument();
            if (fontsFile != null) {
                this.exportFonts(fontsFile, result[1]);
            }
            String svg = result[0];
            if (Boolean.TRUE.equals(properties.get(EMBEDDABLE)) && (offset = svg.indexOf("<svg ")) > -1) {
                svg = svg.substring(offset);
            }
            String string = svg;
            return string;
        }
        finally {
            if (dc != null) {
                dc.dispose();
            }
        }
    }

    private void exportFonts(File fontsFile, String content) {
        if (!fontsFile.getPath().isEmpty() && !fontsFile.exists()) {
            try {
                Files.write(fontsFile.toPath(), content.getBytes(), new OpenOption[0]);
            }
            catch (IOException e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }
    }
}

