/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.draw.render.svg;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.geom.GeneralPath;
import java.awt.geom.Path2D;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import ro.amiq.dvt.draw.render.DGraphics;
import ro.amiq.dvt.draw.render.DQuality;
import ro.amiq.dvt.draw.render.svg.DSVGGraphics2D;
import ro.amiq.dvt.draw.utils.AWTUtils;
import ro.amiq.dvt.draw.utils.FontFactory;
import ro.amiq.dvt.startup.core.DVTLogger;

public class DSVGGraphics
implements DGraphics {
    private final Rectangle bounds;
    private int rectangleID = 0;
    private boolean markRectanglesWithID;
    private final boolean embedFonts;
    private final DSVGGraphics2D gc;
    public int fontAscent;
    public Font font;
    public int lineWidth;
    public int lineCap;
    public int lineJoin;
    public float[] lineStyle;
    public Color foreground;
    public Color background;

    public DSVGGraphics(Rectangle bounds, boolean embedFonts, boolean registerId) {
        this.bounds = bounds;
        this.embedFonts = embedFonts;
        this.gc = new DSVGGraphics2D();
        this.gc.setSVGCanvasSize(new Dimension(this.bounds.width, this.bounds.height));
        this.markRectanglesWithID = registerId;
    }

    public void incrementRectangleID() {
        if (this.rectangleID == Integer.MAX_VALUE) {
            this.rectangleID = 0;
        }
        ++this.rectangleID;
    }

    public void resetMarkerID() {
        this.rectangleID = 0;
    }

    public void setRectangleID(int id) {
        this.rectangleID = id;
    }

    public int getRectangleID() {
        return this.rectangleID;
    }

    @Override
    public Rectangle getBounds() {
        return this.bounds;
    }

    @Override
    public void setClipping(int x, int y, int width, int height) {
    }

    @Override
    public void setFont(FontData fontData) {
        this.fontAscent = FontFactory.getInstance().fontAscent(fontData);
        this.font = FontFactory.getInstance().getAWTFont(fontData);
    }

    @Override
    public void setLineWidth(int width) {
        this.lineWidth = width;
    }

    @Override
    public void setLineCap(int cap) {
        this.lineCap = AWTUtils.convertSWTLineCapToAWTLineCap(cap);
    }

    @Override
    public void setLineJoin(int join) {
        this.lineJoin = AWTUtils.convertSWTLineJoinToAWTLineJoin(join);
    }

    @Override
    public void setLineStyle(int style) {
        this.lineStyle = AWTUtils.convertSWTLineStyleToAWTDashPattern(style);
    }

    @Override
    public void setForeground(RGB rgb) {
        this.foreground = AWTUtils.convertSWTRGBToAWTColor(rgb);
    }

    @Override
    public void setBackground(RGB rgb) {
        this.background = AWTUtils.convertSWTRGBToAWTColor(rgb);
    }

    @Override
    public void drawLine(int x1, int y1, int x2, int y2) {
        this.gc.drawLine(x1, y1, x2, y2);
    }

    @Override
    public void drawPolyline(int[] points) {
        AWTUtils.CoorinateArrays arrays = AWTUtils.convertToCoorinateArrays(points);
        this.gc.drawPolyline(arrays.getXCoordinates(), arrays.getYCoordinates(), arrays.getSize());
    }

    @Override
    public void drawPath(int[] points) {
        GeneralPath path = new GeneralPath();
        ((Path2D)path).moveTo(points[0], points[1]);
        int i = 2;
        while (i < points.length) {
            if (points.length - i >= 6) {
                ((Path2D)path).curveTo(points[i], points[i + 1], points[i + 2], points[i + 3], points[i + 4], points[i + 5]);
                i += 6;
                continue;
            }
            if (points.length - i >= 4) {
                ((Path2D)path).quadTo(points[i], points[i + 1], points[i + 2], points[i + 3]);
                i += 4;
                continue;
            }
            if (points.length - i < 2) break;
            ((Path2D)path).lineTo(points[i], points[i + 1]);
            i += 2;
        }
        this.gc.draw(path);
    }

    @Override
    public void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.gc.drawArc(x, y, width, height, startAngle, arcAngle);
    }

    @Override
    public void drawPolygon(int[] points) {
        AWTUtils.CoorinateArrays arrays = AWTUtils.convertToCoorinateArrays(points);
        this.gc.drawPolygon(arrays.getXCoordinates(), arrays.getYCoordinates(), arrays.getSize());
    }

    @Override
    public void fillPolygon(int[] points) {
        AWTUtils.CoorinateArrays arrays = AWTUtils.convertToCoorinateArrays(points);
        this.gc.fillPolygon(arrays.getXCoordinates(), arrays.getYCoordinates(), arrays.getSize());
    }

    @Override
    public void drawRectangle(int x, int y, int width, int height) {
        this.gc.drawRect(x, y, width, height);
    }

    @Override
    public void fillRectangle(int x, int y, int width, int height, String url) {
        this.gc.fillRect(x, y, width, height, url, this.markRectanglesWithID ? "rect_" + String.valueOf(this.rectangleID) : null);
    }

    @Override
    public void drawRoundRectangle(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.gc.drawRoundRect(x, y, width, height, arcWidth, arcHeight);
    }

    @Override
    public void fillRoundRectangle(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.gc.fillRoundRect(x, y, width, height, arcWidth, arcHeight);
    }

    @Override
    public void drawOval(int x, int y, int width, int height) {
        this.gc.drawOval(x, y, width, height);
    }

    @Override
    public void fillOval(int x, int y, int width, int height) {
        this.gc.fillOval(x, y, width, height);
    }

    @Override
    public void drawText(String text, int x, int y, int width, int height) {
        this.gc.drawString(text, x, y + this.fontAscent, width, height, this.font, this.markRectanglesWithID ? "rect_" + String.valueOf(this.rectangleID) : null);
    }

    @Override
    public void updateState(int s) {
        if ((2 & s) != 0) {
            this.gc.setPaint(this.foreground);
            BasicStroke stroke = (BasicStroke)this.gc.getStroke();
            this.gc.setStroke(new BasicStroke(this.lineWidth, this.lineCap, this.lineJoin, stroke.getMiterLimit(), this.lineStyle, 0.0f));
        }
        if ((4 & s) != 0) {
            this.gc.setPaint(this.background);
        }
        if ((8 & s) != 0) {
            this.gc.setPaint(this.foreground);
        }
    }

    @Override
    public DQuality getQuality() {
        return DQuality.SUPER;
    }

    @Override
    public void dispose() {
    }

    public String[] getSVGDocument() {
        StringWriter svgWriter = new StringWriter();
        StringWriter cssWriter = null;
        if (!this.embedFonts) {
            cssWriter = new StringWriter();
        }
        try {
            this.gc.stream(svgWriter, (Writer)cssWriter);
        }
        catch (IOException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        if (cssWriter != null) {
            return new String[]{((Object)svgWriter).toString(), ((Object)cssWriter).toString()};
        }
        return new String[]{((Object)svgWriter).toString()};
    }
}

