/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.draw.render.svg;

import java.awt.Font;
import java.awt.Rectangle;
import java.awt.Shape;
import java.io.IOException;
import java.io.Writer;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.batik.dom.GenericDOMImplementation;
import org.apache.batik.svggen.SVGGeneratorContext;
import org.apache.batik.svggen.SVGGraphics2D;
import org.apache.batik.svggen.SVGGraphics2DIOException;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ro.amiq.dvt.draw.render.svg.DXmlWriter;
import ro.amiq.dvt.draw.utils.FontFactory;

public class DSVGGraphics2D
extends SVGGraphics2D {
    private final Set<String> usedFontFamilies = new HashSet<String>();
    private final String TEXT_RECTANGLE_ID = "rectid";

    private static SVGGeneratorContext createSVGGeneratorContext() {
        SVGGeneratorContext context = SVGGeneratorContext.createDefault((Document)GenericDOMImplementation.getDOMImplementation().createDocument(null, "svg", null));
        context.setComment("Generated using AMIQ DVT/Specador");
        return context;
    }

    public DSVGGraphics2D() {
        super(DSVGGraphics2D.createSVGGeneratorContext(), false);
    }

    public void drawString(String s, int x, int y, int width, int height, Font font, String rectangleID) {
        this.usedFontFamilies.add(font.getName());
        Element text = this.getDOMFactory().createElementNS("http://www.w3.org/2000/svg", "text");
        text.setAttributeNS(null, "x", this.generatorCtx.doubleString((double)x));
        text.setAttributeNS(null, "y", this.generatorCtx.doubleString((double)y));
        text.setAttributeNS(null, "font-size", String.valueOf(height - 1) + "px");
        text.setAttributeNS(null, "textLength", String.valueOf(width) + "px");
        text.setAttributeNS(null, "lengthAdjust", "spacingAndGlyphs");
        if (rectangleID != null) {
            text.setAttributeNS(null, "rectid", rectangleID);
        }
        Map fontAttributes = this.domTreeManager.getGraphicContextConverter().getFontConverter().toSVG(font, this.gc.getFontRenderContext()).getAttributeMap(null);
        for (Map.Entry fontAttribute : fontAttributes.entrySet()) {
            if ("font-size".equals(fontAttribute.getKey())) continue;
            text.setAttributeNS(null, (String)fontAttribute.getKey(), (String)fontAttribute.getValue());
        }
        text.setAttributeNS("http://www.w3.org/XML/1998/namespace", "xml:space", "preserve");
        text.appendChild(this.getDOMFactory().createTextNode(s));
        this.domGroupManager.addElement(text, (short)16);
    }

    public void fillRect(int x, int y, int width, int height, String url, String rectangleID) {
        Rectangle rect = new Rectangle(x, y, width, height);
        Element svgShape = this.shapeConverter.toSVG((Shape)rect);
        if (url != null) {
            svgShape.setAttributeNS("http://www.w3.org/1999/xlink", "href", url);
        }
        if (rectangleID != null) {
            svgShape.setAttributeNS("http://www.w3.org/1999/xlink", "id", rectangleID);
        }
        this.domGroupManager.addElement(svgShape, (short)16);
    }

    public void stream(Writer svgWriter, Writer cssWriter) throws IOException {
        Element root = this.getRoot();
        if (cssWriter == null) {
            Element defs = this.getDOMFactory().createElementNS("http://www.w3.org/2000/svg", "defs");
            defs.setAttributeNS(null, "type", "fontDefs");
            Element style = this.getDOMFactory().createElementNS("http://www.w3.org/2000/svg", "style");
            style.setAttributeNS(null, "type", "text/css");
            CDATASection cdata = this.getDOMFactory().createCDATASection(FontFactory.getInstance().getCSSFonts(this.usedFontFamilies));
            style.appendChild(cdata);
            defs.appendChild(style);
            root.appendChild(defs);
        } else {
            cssWriter.append(FontFactory.getInstance().getCSSFonts(this.usedFontFamilies));
        }
        this.stream(root, svgWriter);
    }

    public void stream(Element svgRoot, Writer writer) throws SVGGraphics2DIOException {
        block13: {
            Node rootParent = svgRoot.getParentNode();
            Node nextSibling = svgRoot.getNextSibling();
            try {
                try {
                    svgRoot.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "http://www.w3.org/2000/svg");
                    svgRoot.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xlink", "http://www.w3.org/1999/xlink");
                    DocumentFragment svgDocument = svgRoot.getOwnerDocument().createDocumentFragment();
                    svgDocument.appendChild(svgRoot);
                    DXmlWriter.writeXml(svgDocument, writer, false);
                    writer.flush();
                }
                catch (SVGGraphics2DIOException e) {
                    this.generatorCtx.getErrorHandler().handleError(e);
                    if (rootParent != null) {
                        if (nextSibling == null) {
                            rootParent.appendChild(svgRoot);
                        } else {
                            rootParent.insertBefore(svgRoot, nextSibling);
                        }
                    }
                }
                catch (IOException e) {
                    block14: {
                        this.generatorCtx.getErrorHandler().handleError(new SVGGraphics2DIOException(e));
                        if (rootParent == null) break block13;
                        if (nextSibling != null) break block14;
                        rootParent.appendChild(svgRoot);
                        break block13;
                    }
                    rootParent.insertBefore(svgRoot, nextSibling);
                }
            }
            finally {
                if (rootParent != null) {
                    if (nextSibling == null) {
                        rootParent.appendChild(svgRoot);
                    } else {
                        rootParent.insertBefore(svgRoot, nextSibling);
                    }
                }
            }
        }
    }
}

