/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.draw.render.swt;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.graphics.Point;
import ro.amiq.dvt.diagrams.DConstants;
import ro.amiq.dvt.draw.DCanvas;
import ro.amiq.dvt.draw.debug.DDebug;
import ro.amiq.dvt.draw.debug.DNullDebug;
import ro.amiq.dvt.draw.handlers.DClickEvent;
import ro.amiq.dvt.draw.handlers.DClickListener;
import ro.amiq.dvt.draw.obj.base.DObject;
import ro.amiq.dvt.draw.render.swt.DDebugShell;

public class DSWTDebug
implements DDebug,
MouseMoveListener,
DisposeListener,
DClickListener {
    private final TreeMap<String, String> debugData;
    private final HashMap<String, Long> timerData;
    private final DCanvas canvas;
    private DDebugShell debugShell;

    public static DDebug getInstance(DCanvas canvas) {
        if (DConstants.DEBUG) {
            return new DSWTDebug(canvas);
        }
        return new DNullDebug();
    }

    private DSWTDebug(DCanvas canvas) {
        this.canvas = canvas;
        this.canvas.addMouseMoveListener(this);
        this.canvas.addDisposeListener(this);
        this.canvas.getClickHandler().addListener(this);
        this.debugData = new TreeMap();
        this.timerData = new HashMap();
        this.debugShell = new DDebugShell(canvas, this.debugData);
        for (Map.Entry<String, String> entry : DConstants.getAll().entrySet()) {
            this.log("constants/" + entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void log(String key, String value) {
        this.debugData.put(key, value);
        this.debugShell.update();
    }

    @Override
    public void log(String key, double value) {
        this.log(key, Double.toString(value));
    }

    @Override
    public void log(String key, long value) {
        this.log(key, Long.toString(value));
    }

    @Override
    public void startTimer(String key) {
        this.timerData.put(key, System.nanoTime());
    }

    @Override
    public void endTimer(String key) {
        long endTime = System.nanoTime();
        Long startTime = this.timerData.remove(key);
        if (startTime != null) {
            this.log(key, (endTime - startTime) / 1000000L);
        }
    }

    @Override
    public void clear(String key) {
        NavigableMap<String, String> clearMap = this.debugData.subMap(key, false, String.valueOf(key) + '\uffff', true);
        clearMap.clear();
    }

    public void mouseMove(MouseEvent e) {
        Point transforemedPoint = this.canvas.getViewport().getTransformedPoint(e.x, e.y);
        this.log("mouse/position/image/x", transforemedPoint.x);
        this.log("mouse/position/image/y", transforemedPoint.y);
        this.log("mouse/position/canvas/x", e.x);
        this.log("mouse/position/canvas/y", e.y);
    }

    public void widgetDisposed(DisposeEvent e) {
        this.debugShell.close();
        this.canvas.getClickHandler().removeListener(this);
        this.canvas.removeMouseMoveListener(this);
        this.canvas.removeDisposeListener(this);
    }

    @Override
    public void handleEvent(DClickEvent event) {
        Point transformedPoint = event.getTransformedPoint();
        this.log("mouse/click/image/x", transformedPoint.x);
        this.log("mouse/click/image/y", transformedPoint.y);
        this.log("mouse/click/image/button", event.getButton());
        this.log("mouse/click/image/mask", event.getStateMask());
        StringBuilder path = new StringBuilder().append("hit/b").append(event.getButton()).append("_m").append(event.getStateMask());
        this.clear(path.toString());
        Collection<DObject> hits = event.getHits();
        for (DObject hit : hits) {
            path = path.append('/').append(hit.nameString());
            this.log(path.toString(), hit.valueString());
        }
    }
}

