/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.draw.render.swt;

import java.io.File;
import java.io.IOException;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import ro.amiq.dvt.draw.DExporter;
import ro.amiq.dvt.draw.obj.base.DObject;
import ro.amiq.dvt.draw.obj.utils.DProperties;
import ro.amiq.dvt.draw.render.DContext;
import ro.amiq.dvt.draw.render.DRenderer;
import ro.amiq.dvt.draw.render.swt.DSWTGraphics;

public enum DSWTExporter implements DExporter.DExporterImplementation,
DRenderer
{
    INSTANCE_BMP(0),
    INSTANCE_JPEG(4),
    INSTANCE_PNG(5);

    private final int format;

    private DSWTExporter(int format) {
        this.format = format;
    }

    @Override
    public void export(File file, DObject content, double expScale, DProperties properties) throws IOException {
        DContext dc = null;
        Image image = null;
        try {
            float[] fArray;
            Rectangle contentBounds = content.getBounds();
            image = new Image((Device)Display.getDefault(), Math.round((float)((double)contentBounds.width * expScale)), Math.round((float)((double)contentBounds.height * expScale)));
            if (expScale == 1.0) {
                fArray = null;
            } else {
                float[] fArray2 = new float[6];
                fArray2[0] = (float)expScale;
                fArray2[1] = 0.0f;
                fArray2[2] = 0.0f;
                fArray2[3] = (float)expScale;
                fArray2[4] = 0.0f;
                fArray = fArray2;
                fArray2[5] = 0.0f;
            }
            float[] transformMatrix = fArray;
            dc = new DContext(new DSWTGraphics(image, new GC((Drawable)image), transformMatrix, contentBounds, false), expScale);
            this.paint(content, dc);
            ImageLoader loader = new ImageLoader();
            loader.data = new ImageData[]{image.getImageData()};
            try {
                loader.save(file.getAbsolutePath(), this.format);
            }
            catch (SWTException e) {
                if (e.code == 39) {
                    throw new IOException(e);
                }
                throw e;
            }
        }
        finally {
            if (dc != null) {
                dc.dispose();
            }
            if (image != null) {
                image.dispose();
            }
        }
    }

    @Override
    public String export(DObject content, double expScale, DProperties properties) {
        throw new UnsupportedOperationException();
    }
}

