/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.draw.render.swt;

import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Transform;
import ro.amiq.dvt.draw.render.DGraphics;
import ro.amiq.dvt.draw.render.DQuality;
import ro.amiq.dvt.draw.utils.ColorFactory;
import ro.amiq.dvt.draw.utils.FontFactory;
import ro.amiq.dvt.draw.utils.GCFactory;

public class DSWTGraphics
implements DGraphics {
    private final Device device;
    private final Rectangle bounds;
    private final boolean invertColors;
    private final GC gc;
    private final Transform transform;
    private final DQuality quality;

    public DSWTGraphics(Image image, GC gc, float[] transformMatrix, Rectangle bounds, boolean invertColors) {
        this.device = image.getDevice();
        this.bounds = bounds;
        this.invertColors = invertColors;
        this.gc = gc;
        this.quality = GCFactory.INSTANCE.setMaxQuality(gc);
        if (this.invertColors) {
            Rectangle size = image.getBounds();
            this.gc.setBackground(ColorFactory.getInstance().getColor(ColorFactory.getInstance().getRGB(0, 0, 0)));
            this.gc.fillRectangle(0, 0, size.width, size.height);
        }
        if (transformMatrix != null) {
            this.transform = new Transform(this.device, transformMatrix);
            this.gc.setTransform(this.transform);
        } else {
            this.transform = null;
        }
    }

    @Override
    public Rectangle getBounds() {
        return this.bounds;
    }

    @Override
    public void setFont(FontData fontData) {
        this.gc.setFont(FontFactory.getInstance().getSWTFont(fontData));
    }

    @Override
    public void setClipping(int x, int y, int width, int height) {
        this.gc.setClipping(x, y, width, height);
    }

    @Override
    public void setLineWidth(int width) {
        this.gc.setLineWidth(width);
    }

    @Override
    public void setLineCap(int cap) {
        this.gc.setLineCap(cap);
    }

    @Override
    public void setLineJoin(int join) {
        this.gc.setLineJoin(join);
    }

    @Override
    public void setLineStyle(int style) {
        this.gc.setLineStyle(style);
    }

    @Override
    public void setForeground(RGB rgb) {
        this.gc.setForeground(ColorFactory.getInstance().getColor(this.invertColors ? ColorFactory.getInstance().invertRGB(rgb) : rgb));
    }

    @Override
    public void setBackground(RGB rgb) {
        this.gc.setBackground(ColorFactory.getInstance().getColor(this.invertColors ? ColorFactory.getInstance().invertRGB(rgb) : rgb));
    }

    @Override
    public void drawRectangle(int x, int y, int width, int height) {
        this.gc.drawRectangle(x, y, width, height);
    }

    @Override
    public void fillRectangle(int x, int y, int width, int height, String url) {
        this.gc.fillRectangle(x, y, width, height);
    }

    @Override
    public void drawRoundRectangle(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.gc.drawRoundRectangle(x, y, width, height, arcWidth, arcHeight);
    }

    @Override
    public void fillRoundRectangle(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.gc.fillRoundRectangle(x, y, width, height, arcWidth, arcHeight);
    }

    @Override
    public void drawLine(int x1, int y1, int x2, int y2) {
        this.gc.drawLine(x1, y1, x2, y2);
    }

    @Override
    public void drawPolyline(int[] points) {
        this.gc.drawPolyline(points);
    }

    @Override
    public void drawPath(int[] points) {
        Path path = new Path(this.device);
        path.moveTo((float)points[0], (float)points[1]);
        int i = 2;
        while (i < points.length) {
            if (points.length - i >= 6) {
                path.cubicTo((float)points[i], (float)points[i + 1], (float)points[i + 2], (float)points[i + 3], (float)points[i + 4], (float)points[i + 5]);
                i += 6;
                continue;
            }
            if (points.length - i >= 4) {
                path.quadTo((float)points[i], (float)points[i + 1], (float)points[i + 2], (float)points[i + 3]);
                i += 4;
                continue;
            }
            if (points.length - i < 2) break;
            path.lineTo((float)points[i], (float)points[i + 1]);
            i += 2;
        }
        this.gc.drawPath(path);
        path.dispose();
    }

    @Override
    public void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.gc.drawArc(x, y, width, height, startAngle, arcAngle);
    }

    @Override
    public void drawOval(int x, int y, int width, int height) {
        this.gc.drawOval(x, y, width, height);
    }

    @Override
    public void fillOval(int x, int y, int width, int height) {
        this.gc.fillOval(x, y, width, height);
    }

    @Override
    public void drawPolygon(int[] points) {
        this.gc.drawPolygon(points);
    }

    @Override
    public void fillPolygon(int[] points) {
        this.gc.fillPolygon(points);
    }

    @Override
    public void drawText(String text, int x, int y, int width, int height) {
        this.gc.drawText(text, x, y, 131079);
    }

    @Override
    public void updateState(int state) {
    }

    @Override
    public DQuality getQuality() {
        return this.quality;
    }

    @Override
    public void dispose() {
        if (this.gc != null && !this.gc.isDisposed()) {
            this.gc.dispose();
        }
        if (this.transform != null && !this.transform.isDisposed()) {
            this.transform.dispose();
        }
    }
}

