/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.draw.render.swt;

import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Region;
import ro.amiq.dvt.diagrams.DConstants;
import ro.amiq.dvt.diagrams.preferences.DiagramPreferenceAdapter;
import ro.amiq.dvt.draw.DCanvas;
import ro.amiq.dvt.draw.DMagnifier;
import ro.amiq.dvt.draw.obj.base.DObject;
import ro.amiq.dvt.draw.render.DContext;
import ro.amiq.dvt.draw.render.DRenderer;
import ro.amiq.dvt.draw.render.swt.DMagnifierGraphics;
import ro.amiq.dvt.draw.render.swt.DSWTGraphics;
import ro.amiq.dvt.draw.utils.ColorFactory;

public class DSWTRenderer
implements DRenderer,
DisposeListener,
Runnable,
PaintListener {
    private long debugTotalFrames = 0L;
    private long debugRenderedFrames = 0L;
    private final DCanvas canvas;
    private final ThreadPoolExecutor renderExecutor;
    private Image image;

    public DSWTRenderer(DCanvas canvas) {
        this.canvas = canvas;
        this.canvas.addDisposeListener(this);
        this.canvas.addPaintListener(this);
        this.renderExecutor = new ThreadPoolExecutor(0, 1, 30L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(1), new ThreadPoolExecutor.DiscardPolicy());
    }

    public void render() {
        if (DConstants.DEBUG) {
            this.canvas.getDebug().log("render/frame/nof/total", ++this.debugTotalFrames);
        }
        if (this.renderExecutor.isShutdown()) {
            return;
        }
        this.renderExecutor.execute(this);
    }

    @Override
    public void run() {
        if (this.canvas.isDisposed()) {
            return;
        }
        this.canvas.getDisplay().syncExec(() -> {
            DObject content;
            if (this.canvas.isDisposed()) {
                return;
            }
            if (DConstants.DEBUG) {
                this.canvas.getDebug().log("render/frame/nof/rendered", ++this.debugRenderedFrames);
                this.canvas.getDebug().startTimer("render/frame/time/total");
            }
            if ((content = this.canvas.getContent()) == null) {
                return;
            }
            DContext dc = null;
            DContext mc = null;
            GC gc = null;
            Path frame = null;
            Region clippingArea = null;
            try {
                DMagnifier magnifier;
                this.disposeImage();
                this.image = new Image((Device)this.canvas.getDisplay(), this.canvas.getViewport().getCanvasSize());
                gc = new GC((Drawable)this.image);
                dc = new DContext(new DSWTGraphics(this.image, gc, this.canvas.getViewport().getTransformMatrix(), this.canvas.getViewport().getTransformedBounds(), DiagramPreferenceAdapter.getInstance().getDiagramInvertColors()), this.canvas.getViewport().getExpScale());
                if (DConstants.DEBUG) {
                    this.canvas.getDebug().startTimer("render/frame/time/paint");
                }
                this.paint(content, dc);
                if (DConstants.DEBUG) {
                    this.canvas.getDebug().endTimer("render/frame/time/paint");
                }
                if (DConstants.DEBUG) {
                    this.canvas.getDebug().log("render/gc/quality", dc.getQuality().toString());
                    this.canvas.getDebug().log("render/gc/draw", dc.debugGCDraws);
                    this.canvas.getDebug().log("render/gc/sets", dc.debugGCSets);
                    this.canvas.getDebug().log("render/paints/total", dc.debugPaintsTotal);
                    this.canvas.getDebug().log("render/paints/visible", dc.debugPaintsVisible);
                    this.canvas.getDebug().log("render/paints/groups", dc.debugPaintsGroup);
                    this.canvas.getDebug().log("render/paints/primitives", dc.debugPaintsPrimitive);
                }
                if ((magnifier = this.canvas.getMagnifier()) == null) {
                    return;
                }
                if (magnifier.getHandler().isVisible() && magnifier.getRadius() > 0) {
                    gc.dispose();
                    gc = new GC((Drawable)this.image);
                    int x = magnifier.getBorderX();
                    int y = magnifier.getBorderY();
                    int diameter = magnifier.getDiameter();
                    int radius = magnifier.getRadius();
                    clippingArea = new Region();
                    clippingArea.add(this.circle(radius, x + radius, y + radius));
                    gc.setClipping(clippingArea);
                    RGB backgroundRGB = ColorFactory.getInstance().getRGB(255, 255, 255);
                    Color backgroundColor = ColorFactory.getInstance().getColor(DiagramPreferenceAdapter.getInstance().getDiagramInvertColors() ? ColorFactory.getInstance().invertRGB(backgroundRGB) : backgroundRGB);
                    gc.setBackground(backgroundColor);
                    gc.fillRectangle(this.canvas.getMagnifier().getCanvasSize());
                    mc = new DContext(new DMagnifierGraphics(this.image, gc, magnifier.getTransformMatrix(), magnifier.getTransformedBounds(), DiagramPreferenceAdapter.getInstance().getDiagramInvertColors()), magnifier.getExpScale());
                    if (DConstants.DEBUG) {
                        this.canvas.getDebug().startTimer("render/frame/time/magnifier/paint");
                    }
                    this.paint(content, mc);
                    gc.dispose();
                    gc = new GC((Drawable)this.image);
                    Color frameColor = ColorFactory.getInstance().getColor(DiagramPreferenceAdapter.getInstance().getDiagramInvertColors() ? ColorFactory.getInstance().invertRGB(DMagnifier.BORDER_COLOR) : DMagnifier.BORDER_COLOR);
                    gc.setForeground(frameColor);
                    gc.setLineWidth(2);
                    frame = new Path(this.image.getDevice());
                    frame.addArc((float)(x + 1), (float)(y + 1), (float)(diameter - 2), (float)(diameter - 2), 0.0f, 360.0f);
                    gc.drawPath(frame);
                    if (DConstants.DEBUG) {
                        this.canvas.getDebug().endTimer("render/frame/time/magnifier/paint");
                    }
                    if (DConstants.DEBUG) {
                        this.canvas.getDebug().log("render/gc/magnifier/quality", mc.getQuality().toString());
                        this.canvas.getDebug().log("render/gc/magnifier/draw", mc.debugGCDraws);
                        this.canvas.getDebug().log("render/gc/magnifier/sets", mc.debugGCSets);
                        this.canvas.getDebug().log("render/paints/magnifier/total", mc.debugPaintsTotal);
                        this.canvas.getDebug().log("render/paints/magnifier/visible", mc.debugPaintsVisible);
                        this.canvas.getDebug().log("render/paints/magnifier/groups", mc.debugPaintsGroup);
                        this.canvas.getDebug().log("render/paints/magnifier/primitives", mc.debugPaintsPrimitive);
                    }
                }
            }
            finally {
                if (gc != null) {
                    gc.dispose();
                }
                if (dc != null) {
                    dc.dispose();
                }
                if (mc != null) {
                    mc.dispose();
                }
                if (frame != null) {
                    frame.dispose();
                }
                if (clippingArea != null) {
                    clippingArea.dispose();
                }
            }
            if (DConstants.DEBUG) {
                this.canvas.getDebug().startTimer("render/frame/time/buffer");
            }
            this.canvas.redraw();
            if (DConstants.DEBUG) {
                this.canvas.getDebug().endTimer("render/frame/time/buffer");
            }
            if (DConstants.DEBUG) {
                this.canvas.getDebug().endTimer("render/frame/time/total");
            }
        });
    }

    public int[] circle(int radius, int offsetX, int offsetY) {
        int[] polygon = new int[8 * radius + 4];
        int i = 0;
        while (i < 2 * radius + 1) {
            int x = i - radius;
            int y = (int)Math.sqrt(Math.pow(radius, 2.0) - Math.pow(x, 2.0));
            polygon[2 * i] = offsetX + x;
            polygon[2 * i + 1] = offsetY + y;
            polygon[8 * radius - 2 * i - 2] = offsetX + x;
            polygon[8 * radius - 2 * i - 1] = offsetY - y;
            ++i;
        }
        return polygon;
    }

    public void paintControl(PaintEvent e) {
        if (this.image != null && e.gc != null && !this.image.isDisposed() && !e.gc.isDisposed()) {
            e.gc.drawImage(this.image, 0, 0);
        }
    }

    private void disposeImage() {
        if (this.image == null) {
            return;
        }
        if (!this.image.isDisposed()) {
            this.image.dispose();
        }
        this.image = null;
    }

    public void widgetDisposed(DisposeEvent e) {
        this.renderExecutor.shutdownNow();
        this.disposeImage();
        this.canvas.removeDisposeListener(this);
    }
}

