/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.draw.utils;

import java.awt.Color;
import java.awt.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;

public class AWTUtils {
    private static final float[] DASH_PATTERN_DASH = new float[]{18.0f, 9.0f};
    private static final float[] DASH_PATTERN_DASH_DOT = new float[]{9.0f, 3.0f, 3.0f, 3.0f};
    private static final float[] DASH_PATTERN_DASH_DOT_DOT = new float[]{9.0f, 3.0f, 3.0f, 3.0f, 3.0f, 3.0f};
    private static final float[] DASH_PATTERN_DOT = new float[]{3.0f, 3.0f};

    public static CoorinateArrays convertToCoorinateArrays(int[] points) {
        return new CoorinateArrays(points);
    }

    public static Font convertSWTFontDataToAWTFont(FontData fontData) {
        String name = fontData.getName();
        int size = fontData.getHeight();
        int swtStyle = fontData.getStyle();
        int awtStyle = 0;
        awtStyle |= !false ? 0 : 0;
        awtStyle |= (swtStyle & 1) == 0 ? 0 : 1;
        return new Font(name, awtStyle |= (swtStyle & 2) == 0 ? 0 : 2, size);
    }

    public static Color convertSWTRGBToAWTColor(RGB rgb) {
        return new Color(rgb.red, rgb.green, rgb.blue);
    }

    public static int convertSWTLineCapToAWTLineCap(int cap) {
        if (cap == 1) {
            return 0;
        }
        if (cap == 2) {
            return 1;
        }
        if (cap == 3) {
            return 2;
        }
        return -1;
    }

    public static int convertSWTLineJoinToAWTLineJoin(int join) {
        if (join == 1) {
            return 0;
        }
        if (join == 2) {
            return 1;
        }
        if (join == 3) {
            return 2;
        }
        return -1;
    }

    public static float[] convertSWTLineStyleToAWTDashPattern(int style) {
        if (style == 1) {
            return null;
        }
        if (style == 2) {
            return DASH_PATTERN_DASH;
        }
        if (style == 4) {
            return DASH_PATTERN_DASH_DOT;
        }
        if (style == 5) {
            return DASH_PATTERN_DASH_DOT_DOT;
        }
        if (style == 3) {
            return DASH_PATTERN_DOT;
        }
        return null;
    }

    public static class CoorinateArrays {
        private final int[] xCoordinates;
        private final int[] yCoordinates;

        public CoorinateArrays(int[] interlacedCoorinates) {
            int size = interlacedCoorinates.length / 2;
            this.xCoordinates = new int[size];
            this.yCoordinates = new int[size];
            int i = 0;
            while (i < interlacedCoorinates.length) {
                this.xCoordinates[i / 2] = interlacedCoorinates[i];
                this.yCoordinates[i / 2] = interlacedCoorinates[i + 1];
                i += 2;
            }
        }

        public int[] getXCoordinates() {
            return this.xCoordinates;
        }

        public int[] getYCoordinates() {
            return this.yCoordinates;
        }

        public int getSize() {
            return this.xCoordinates.length;
        }
    }
}

