/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.draw.utils;

import java.util.HashMap;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import ro.amiq.dvt.draw.utils.ColorFactoryCommon;

public class ColorFactory
extends ColorFactoryCommon {
    private static final ColorFactory instance = new ColorFactory();
    protected final HashMap<RGB, Color> colorMap = new HashMap();

    public static ColorFactory getInstance() {
        return instance;
    }

    protected ColorFactory() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                Display.getDefault().disposeExec(() -> ColorFactory.this.colorMap.values().stream().forEach(color -> color.dispose()));
            }
        });
    }

    public Color getColor(RGB rgb) {
        Color cachedColor = this.colorMap.get(rgb);
        if (cachedColor == null) {
            cachedColor = new Color((Device)Display.getDefault(), rgb);
            this.colorMap.put(rgb, cachedColor);
        }
        return cachedColor;
    }
}

