/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.draw.utils;

import java.awt.Color;
import java.util.HashMap;
import org.eclipse.swt.graphics.RGB;
import ro.amiq.dvt.draw.obj.utils.RGBV;

public abstract class ColorFactoryCommon {
    protected static final int VISIBLE_MASK = 0x1000000;
    protected final HashMap<Integer, RGB> rgbMap = new HashMap();
    protected final HashMap<Integer, RGBV> rgbvMap = new HashMap();

    protected ColorFactoryCommon() {
    }

    public RGB getRGB(int red, int green, int blue) {
        Integer rgbKey = blue << 16 | green << 8 | red;
        RGB cachedRGB = this.rgbMap.get(rgbKey);
        if (cachedRGB == null) {
            cachedRGB = new RGB(red, green, blue);
            this.rgbMap.put(rgbKey, cachedRGB);
        }
        return cachedRGB;
    }

    public RGBV getRGBV(int red, int green, int blue, boolean visible) {
        Integer rgbvKey = (visible ? 0x1000000 : 0) | blue << 16 | green << 8 | red;
        RGBV cachedRGBV = this.rgbvMap.get(rgbvKey);
        if (cachedRGBV == null) {
            cachedRGBV = new RGBV(this.getRGB(red, green, blue), visible);
            this.rgbvMap.put(rgbvKey, cachedRGBV);
        }
        return cachedRGBV;
    }

    public RGB depthRGB(RGB rgb, int depth, int level) {
        float[] hsb = Color.RGBtoHSB(rgb.red, rgb.green, rgb.blue, null);
        hsb[1] = hsb[1] * (float)(level + 1) / (float)depth;
        int rgbValue = Color.HSBtoRGB(hsb[0], hsb[1], hsb[2]);
        return this.getRGB(rgbValue >> 16 & 0xFF, rgbValue >> 8 & 0xFF, rgbValue & 0xFF);
    }

    public RGB getLowSaturationRGB(RGB rgb) {
        float[] hsb = Color.RGBtoHSB(rgb.red, rgb.green, rgb.blue, null);
        hsb[1] = 0.0f;
        hsb[2] = hsb[2] / 2.0f;
        int rgbValue = Color.HSBtoRGB(hsb[0], hsb[1], hsb[2]);
        return this.getRGB(rgbValue >> 16 & 0xFF, rgbValue >> 8 & 0xFF, rgbValue & 0xFF);
    }

    public RGB invertRGB(RGB rgb) {
        return this.getRGB(~rgb.red & 0xFF, ~rgb.green & 0xFF, ~rgb.blue & 0xFF);
    }

    public RGB invertRGB(int red, int green, int blue) {
        return this.getRGB(~red & 0xFF, ~green & 0xFF, ~blue & 0xFF);
    }

    public RGB getRGBFromHexString(String hexRGB) {
        if (hexRGB == null || hexRGB.isEmpty() || hexRGB.length() < 3 || hexRGB.length() > 7) {
            return null;
        }
        if (hexRGB.length() >= 6) {
            if (hexRGB.length() == 7 && hexRGB.startsWith("#")) {
                hexRGB = hexRGB.substring(1);
            }
            try {
                int red = Integer.parseInt(hexRGB.substring(0, 2), 16);
                int green = Integer.parseInt(hexRGB.substring(2, 4), 16);
                int blue = Integer.parseInt(hexRGB.substring(4), 16);
                return this.getRGB(red, green, blue);
            }
            catch (Exception exception) {
                return null;
            }
        }
        if (hexRGB.length() <= 4) {
            if (hexRGB.length() == 4 && hexRGB.startsWith("#")) {
                hexRGB = hexRGB.substring(1);
            }
            try {
                int red = Integer.parseInt(String.valueOf(hexRGB.substring(0, 1)) + hexRGB.substring(0, 1), 16);
                int green = Integer.parseInt(String.valueOf(hexRGB.substring(1, 2)) + hexRGB.substring(1, 2), 16);
                int blue = Integer.parseInt(String.valueOf(hexRGB.substring(2, 3)) + hexRGB.substring(2, 3), 16);
                return this.getRGB(red, green, blue);
            }
            catch (Exception exception) {
                return null;
            }
        }
        return null;
    }
}

