/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.draw.utils;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Stream;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.widgets.Display;
import ro.amiq.dvt.draw.utils.FontFactoryCommon;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.test.TestHelper;

public class FontFactory
extends FontFactoryCommon {
    private static final ReentrantLock LOCK = new ReentrantLock();
    private static volatile FontFactory instance;
    private final HashMap<FontData, Font> swtFontMap = new HashMap();
    private final Image swtImage;
    private final GC swtGC;
    private static final ThreadLocal<Boolean> USE_AWT_FONTS_ON_THIS_THREAD;

    static {
        USE_AWT_FONTS_ON_THIS_THREAD = ThreadLocal.withInitial(() -> Boolean.FALSE);
    }

    public static FontFactory getInstance() {
        if (instance == null) {
            Display display = Display.getCurrent();
            if (display != null) {
                while (!display.isDisposed()) {
                    if (LOCK.tryLock()) {
                        FontFactory.createInstance();
                        break;
                    }
                    if (display.readAndDispatch()) continue;
                    display.sleep();
                }
            } else {
                LOCK.lock();
                FontFactory.createInstance();
            }
        }
        return instance;
    }

    private static void createInstance() {
        try {
            if (instance == null) {
                instance = new FontFactory();
            }
        }
        finally {
            LOCK.unlock();
        }
    }

    protected FontFactory() {
        AtomicReference imageRef = new AtomicReference();
        AtomicReference gcRef = new AtomicReference();
        Display.getDefault().syncExec(() -> {
            Image image = new Image((Device)Display.getDefault(), 100, 100);
            GC gc = new GC((Drawable)image);
            gc.setAdvanced(true);
            gc.setAntialias(1);
            gc.setTextAntialias(1);
            imageRef.set(image);
            gcRef.set(gc);
        });
        this.swtImage = (Image)imageRef.get();
        this.swtGC = (GC)gcRef.get();
        Display.getDefault().syncExec(() -> Display.getDefault().disposeExec(() -> {
            this.swtImage.dispose();
            this.swtGC.dispose();
            this.swtFontMap.values().stream().forEach(Resource::dispose);
        }));
        Display.getDefault().syncExec(this::loadFonts);
    }

    @Override
    protected void loadSWTFonts(Path fontsPath) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (Stream<Path> paths = Files.walk(fontsPath, new FileVisitOption[0]);){
                paths.map(path -> path.toAbsolutePath().toString()).filter(pathString -> pathString.endsWith(".ttf")).forEach(pathString -> {
                    boolean bl = Display.getDefault().loadFont(pathString);
                });
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public Font getSWTFont(FontData fontData) {
        Font cachedFont = this.swtFontMap.get(fontData);
        if (cachedFont == null) {
            cachedFont = new Font((Device)Display.getDefault(), fontData);
            this.swtFontMap.put(fontData, cachedFont);
        }
        return cachedFont;
    }

    @Override
    public Point stringExtent(String text, FontData fontData) {
        if (TestHelper.isTestMode() || USE_AWT_FONTS_ON_THIS_THREAD.get().booleanValue()) {
            return super.stringExtent(text, fontData);
        }
        AtomicReference result = new AtomicReference();
        Display.getDefault().syncExec(() -> {
            this.swtGC.setFont(this.getSWTFont(fontData));
            result.set(this.swtGC.stringExtent(text));
        });
        return (Point)result.get();
    }

    @Override
    public int fontAscent(FontData fontData) {
        if (TestHelper.isTestMode() || USE_AWT_FONTS_ON_THIS_THREAD.get().booleanValue()) {
            return super.fontAscent(fontData);
        }
        AtomicReference result = new AtomicReference();
        Display.getDefault().syncExec(() -> {
            this.swtGC.setFont(this.getSWTFont(fontData));
            result.set(this.swtGC.getFontMetrics().getAscent());
        });
        return (Integer)result.get();
    }

    public static void useAWTFontsOnThisThread() {
        USE_AWT_FONTS_ON_THIS_THREAD.set(Boolean.TRUE);
    }

    public static void restoreDefaultFontsOnThisThread() {
        USE_AWT_FONTS_ON_THIS_THREAD.remove();
    }

    @Override
    protected boolean isTestMode() {
        return TestHelper.isTestMode();
    }
}

