/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.draw.utils;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import ro.amiq.dvt.draw.utils.AWTUtils;
import ro.amiq.dvt.draw.utils.FontFactory;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.test.TestHelper;
import ro.amiq.dvt.utils.DVTDeleteOnExit;
import ro.amiq.dvt.utils.JarUtils;

public abstract class FontFactoryCommon {
    private static final float AWT_DPI_RATIO = 1.3333334f;
    private final HashMap<FontData, FontData> fontDataMap = new HashMap();
    private final HashMap<String, String> cssFontMap = new HashMap();
    private final HashMap<FontData, Font> awtFontMap = new HashMap();
    private final HashMap<FontData, Font> awtSFontMap = new HashMap();
    private final Graphics2D awtGC = (Graphics2D)new BufferedImage(1, 1, 2).getGraphics();

    protected FontFactoryCommon() {
        this.awtGC.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.awtGC.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        this.awtGC.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
    }

    protected void loadFonts() {
        Path fontsPath = this.extractFonts();
        if (fontsPath != null) {
            this.loadSWTFonts(fontsPath);
            this.loadAWTFonts(fontsPath);
            this.loadCSSFonts(fontsPath);
        }
    }

    private Path extractFonts() {
        try {
            Path fontsPath = Files.createTempDirectory("dvt.fonts.", new FileAttribute[0]);
            DVTDeleteOnExit.INSTANCE.registerPath(fontsPath);
            JarUtils.extractDirectory("/resources/fonts", FontFactory.class, true, fontsPath.toAbsolutePath().toString(), true);
            return fontsPath;
        }
        catch (IOException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }

    protected void loadSWTFonts(Path fontsPath) {
    }

    private void loadAWTFonts(Path fontsPath) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (Stream<Path> paths = Files.walk(fontsPath, new FileVisitOption[0]);){
                paths.map(path -> path.toAbsolutePath().toString()).filter(pathString -> pathString.endsWith(".ttf")).forEach(pathString -> {
                    try {
                        Font font = Font.createFont(0, new File((String)pathString));
                        GraphicsEnvironment.getLocalGraphicsEnvironment().registerFont(font);
                    }
                    catch (Exception e) {
                        DVTLogger.INSTANCE.logError((Throwable)e);
                    }
                });
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private void loadCSSFonts(Path fontsPath) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (Stream<Path> paths = Files.walk(fontsPath, new FileVisitOption[0]);){
                Pattern fontNamePattern = Pattern.compile("/\\*\\s*(.*)\\s*\\*/");
                paths.map(path -> path.toAbsolutePath().toString()).filter(pathString -> pathString.endsWith(".css")).forEach(pathString -> {
                    String fontName = this.getCSSFontName((String)pathString, fontNamePattern);
                    if (fontName == null) {
                        return;
                    }
                    this.cssFontMap.put(fontName, (String)pathString);
                });
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getCSSFontName(String fontFileName, Pattern fontNamePattern) {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (BufferedReader reader = new BufferedReader(new FileReader(fontFileName));){
                String fontName = reader.readLine();
                if (fontName == null) {
                    return null;
                }
                Matcher matcher = fontNamePattern.matcher(fontName);
                if (!matcher.matches()) return null;
                return matcher.group(1).trim();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return null;
    }

    private String getCSSFont(String fontName) {
        String fontPath = this.cssFontMap.get(fontName);
        String result = "";
        if (fontPath != null) {
            try {
                result = new String(Files.readAllBytes(Paths.get(fontPath, new String[0])));
            }
            catch (IOException e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }
        return result;
    }

    public FontData getFontData(String name, int height, int style) {
        FontData newFontData = new FontData(name, height, style);
        FontData cachedFontData = this.fontDataMap.get(newFontData);
        if (cachedFontData == null) {
            cachedFontData = newFontData;
            this.fontDataMap.put(cachedFontData, cachedFontData);
        }
        return cachedFontData;
    }

    public FontData depthFontData(FontData fontData, int depth, int level) {
        return this.getFontData(fontData.getName(), fontData.getHeight() * (depth - level - 1), fontData.getStyle());
    }

    public String getCSSFonts(Collection<String> fontNames) {
        StringBuilder sb = new StringBuilder();
        for (String fontName : fontNames) {
            sb.append(this.getCSSFont(fontName));
        }
        return sb.toString();
    }

    public Font getAWTFont(FontData fontData) {
        Font cachedFont = this.awtFontMap.get(fontData);
        if (cachedFont == null) {
            cachedFont = AWTUtils.convertSWTFontDataToAWTFont(fontData);
            this.awtFontMap.put(fontData, cachedFont);
        }
        return cachedFont;
    }

    private Font getScaledAWTFont(FontData fontData) {
        Font cachedFont = this.awtSFontMap.get(fontData);
        if (cachedFont == null) {
            Font originalFont = this.getAWTFont(fontData);
            cachedFont = originalFont.deriveFont((float)fontData.getHeight() * 1.3333334f);
            this.awtSFontMap.put(fontData, cachedFont);
        }
        return cachedFont;
    }

    public Point stringExtent(String text, FontData fontData) {
        if (TestHelper.isTestMode()) {
            float point = (float)fontData.getHeight() * 1.3333334f;
            return new Point(Math.round(point * (float)text.length() / 2.0f), Math.round(point));
        }
        this.awtGC.setFont(this.getScaledAWTFont(fontData));
        Rectangle2D bounds = this.awtGC.getFontMetrics().getStringBounds(text, this.awtGC);
        return new Point(Math.round((float)bounds.getWidth()), Math.round((float)bounds.getHeight()));
    }

    public int fontAscent(FontData fontData) {
        if (this.isTestMode()) {
            return Math.round(0.8333333f * (float)fontData.getHeight() * 1.3333334f);
        }
        this.awtGC.setFont(this.getScaledAWTFont(fontData));
        return this.awtGC.getFontMetrics().getAscent();
    }

    public Point emSize(FontData fontData) {
        return this.stringExtent("M", fontData);
    }

    public String getFontPath(String fontName) {
        return this.cssFontMap.get(fontName);
    }

    protected abstract boolean isTestMode();
}

