/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.draw.utils;

import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import ro.amiq.dvt.draw.render.DQuality;
import ro.amiq.dvt.draw.utils.GCSubpixel;
import ro.amiq.dvt.startup.core.DVTLogger;

public enum GCFactory {
    INSTANCE;

    private DQuality maxQuality = GCFactory.findMaxQuality();

    private static DQuality findMaxQuality() {
        Image image = null;
        GC gc = null;
        try {
            image = new Image((Device)Display.getDefault(), 100, 100);
            gc = new GC((Drawable)image);
            gc.setAdvanced(true);
            if (!gc.getAdvanced()) {
                DQuality dQuality = DQuality.LOW;
                return dQuality;
            }
            gc.setAntialias(1);
            if (gc.getAntialias() != 1) {
                DQuality dQuality = DQuality.MEDIUM;
                return dQuality;
            }
            gc.setTextAntialias(1);
            if (gc.getTextAntialias() != 1) {
                DQuality dQuality = DQuality.MEDIUM;
                return dQuality;
            }
            if (!GCSubpixel.INSTANCE.setSubpixelAntialias(gc)) {
                DQuality dQuality = DQuality.HIGH;
                return dQuality;
            }
            if (!GCSubpixel.INSTANCE.setSubpixelTextAntialias(gc)) {
                DQuality dQuality = DQuality.HIGH;
                return dQuality;
            }
            DQuality dQuality = DQuality.SUPER;
            return dQuality;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        finally {
            if (image != null && !image.isDisposed()) {
                image.dispose();
            }
            if (gc != null && !gc.isDisposed()) {
                gc.dispose();
            }
        }
        return DQuality.LOW;
    }

    private boolean setSuperQuality(GC gc) {
        if (!GCSubpixel.INSTANCE.setSubpixelAntialias(gc)) {
            return false;
        }
        return GCSubpixel.INSTANCE.setSubpixelTextAntialias(gc);
    }

    private void setHighQuality(GC gc) {
        gc.setAntialias(1);
        gc.setTextAntialias(1);
    }

    private void setLowQuality(GC gc) {
        gc.setAntialias(-1);
        gc.setTextAntialias(-1);
    }

    public DQuality setMaxQuality(GC gc) {
        if (this.maxQuality == DQuality.SUPER) {
            if (!this.setSuperQuality(gc)) {
                this.maxQuality = DQuality.HIGH;
                this.setHighQuality(gc);
            }
        } else if (this.maxQuality == DQuality.HIGH) {
            this.setHighQuality(gc);
        } else if (this.maxQuality == DQuality.MEDIUM) {
            this.setLowQuality(gc);
        }
        return this.maxQuality;
    }
}

