/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.dvtcommand;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyDelegatingOperation;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.startup.core.DVTUiUtils;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.Utils;
import ro.amiq.dvt.wizards.predefinedprojects.PredefinedProjectValidationMessage;
import ro.amiq.dvt.wizards.util.PredefinedProjectsUtils;

public class OpenPredefinedProjectUtils {
    public static final String DVT_PREDEFINED_PROJECTS_TARGET = "DVT_PREDEFINED_PROJECTS_TARGET";
    public static final String DVT_PREDEFINED_PROJECTS_TARGET_FILE_NAME = "dvt_predefined_projects_target";
    public static final String DVT_PREDEFINED_PROJECTS = "DVT_PREDEFINED_PROJECTS";

    public static PredefinedProjectValidationMessage validateProjectFields(String projectNewName, String projectNewPath, boolean isOverwrite) {
        File projectNewPathFile;
        try {
            projectNewPath = new File(projectNewPath).getCanonicalPath();
        }
        catch (IOException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        if (projectNewPath.isEmpty()) {
            return PredefinedProjectValidationMessage.EMPTY_TARGET_DIR;
        }
        File parentFile = projectNewPathFile = new File(projectNewPath);
        boolean isWritable = false;
        while (parentFile != null) {
            if (parentFile.canWrite() && parentFile.exists()) {
                isWritable = true;
                break;
            }
            parentFile = parentFile.getParentFile();
        }
        if (!isWritable) {
            return PredefinedProjectValidationMessage.NOT_WRITABLE_TARGET_DIR;
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IPath workspacePath = workspace.getRoot().getLocation();
        if (Path.fromOSString((String)projectNewPath).equals((Object)workspacePath)) {
            return PredefinedProjectValidationMessage.WORKSPACE_OVERLAPS_WITH_TARGET_DIR;
        }
        if (Path.fromOSString((String)projectNewPath).isPrefixOf(workspacePath)) {
            return PredefinedProjectValidationMessage.WORKSPACE_PARENT_TARGET_DIR;
        }
        if (workspacePath.isPrefixOf(Path.fromOSString((String)projectNewPath))) {
            return PredefinedProjectValidationMessage.TARGET_DIR_INSIDE_WORKSPACE;
        }
        if (projectNewName != null && !isOverwrite) {
            IProject newProject = workspace.getRoot().getProject(projectNewName);
            String destinationPath = String.valueOf(projectNewPath) + File.separator + projectNewName;
            File destinationFile = new File(destinationPath);
            if (destinationFile.exists() && newProject.exists()) {
                return PredefinedProjectValidationMessage.PROJECT_AND_TARGET_COLLISION;
            }
            if (destinationFile.exists()) {
                return PredefinedProjectValidationMessage.TARGET_DIR_COLLISION;
            }
            if (newProject.exists()) {
                return PredefinedProjectValidationMessage.PROJECT_NAME_COLLISION;
            }
        }
        return PredefinedProjectValidationMessage.NO_PROBLEM;
    }

    public static boolean copyProjectFolder(final boolean overwrite, final File destFolder, final File sourceFolder) {
        if (!sourceFolder.exists()) {
            return false;
        }
        final Shell shell = DVTUiUtils.getActiveWorkbenchShell();
        if (shell == null) {
            return false;
        }
        final ArrayList notCopiedList = new ArrayList();
        final boolean[] result = new boolean[1];
        shell.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    ProgressMonitorDialog dialog = new ProgressMonitorDialog(shell);
                    dialog.run(true, true, new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) {
                            monitor.beginTask("Opening \"" + destFolder.getName() + "\" ...", -1);
                            if (destFolder.exists() && overwrite) {
                                Utils.deleteFileRecursively(destFolder);
                            }
                            notCopiedList.addAll(DVTFileUtils.getInstance().copyDirectory(sourceFolder, destFolder, new String[]{"CVS"}, true));
                        }
                    });
                    if (!notCopiedList.isEmpty()) {
                        String fileNamesList = "";
                        for (File file : notCopiedList) {
                            fileNamesList = String.valueOf(fileNamesList) + file.getAbsolutePath() + System.getProperty("line.separator");
                        }
                        new MessageDialog(shell, "IOException when copying files", null, "The following files were not copied because of an IOException:\n\n" + fileNamesList, 4, new String[]{IDialogConstants.OK_LABEL}, 0).open();
                        return;
                    }
                    result[0] = true;
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                }
            }
        });
        return result[0];
    }

    public static boolean createProject(File destFolder, File destinationProject, IProjectDescription destinationProjectDescr, String openFile, IConfigurationElement configElement) {
        if (destinationProject == null || destinationProjectDescr == null) {
            return false;
        }
        CreateProjectRunnable createProjectRunnable = new CreateProjectRunnable(destinationProjectDescr);
        WorkspaceModifyDelegatingOperation newProjectOp = new WorkspaceModifyDelegatingOperation((IRunnableWithProgress)createProjectRunnable);
        IWorkbenchWindow activeWorkbenchWindow = DVTUiUtils.getActiveWorkbenchWindow();
        if (activeWorkbenchWindow == null) {
            return false;
        }
        boolean[] result = new boolean[]{OpenPredefinedProjectUtils.runProjectOperation((IRunnableWithProgress)newProjectOp, activeWorkbenchWindow)};
        BasicNewProjectResourceWizard.updatePerspective((IConfigurationElement)configElement);
        IProject project = createProjectRunnable.getProject();
        if (project == null) {
            return result[0];
        }
        DVTPlugin.getSelectionManager().selectAndReveal((IResource)project, activeWorkbenchWindow);
        if (openFile != null) {
            try {
                IFile file;
                IWorkbenchPage activePage = DVTUiUtils.getActivePage();
                if (activePage != null && (file = project.getFile(Path.fromOSString((String)openFile))).exists()) {
                    IDE.openEditor((IWorkbenchPage)activePage, (IFile)file);
                }
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }
        return result[0];
    }

    public static boolean performFinishWithNoWizard(String destinationProjectFolder, String sourceProjectFolder, boolean overwrite, String openFile, IConfigurationElement configElement) {
        File destFolder = new File(destinationProjectFolder);
        File sourceFolder = new File(sourceProjectFolder);
        if (overwrite) {
            OpenPredefinedProjectUtils.deleteExistingProject(destFolder);
        }
        if (!OpenPredefinedProjectUtils.copyProjectFolder(overwrite, destFolder, sourceFolder)) {
            return false;
        }
        File destinationProject = PredefinedProjectsUtils.getProjectFileFromDirectory(destFolder);
        IProjectDescription destinationProjectDescr = Utils.getProjectDescription(destinationProject);
        return OpenPredefinedProjectUtils.createProject(destFolder, destinationProject, destinationProjectDescr, openFile, configElement);
    }

    private static Map<IProjectDescription, String> getPredefinedProjects() {
        String systemVarPath = System.getenv(DVT_PREDEFINED_PROJECTS);
        HashMap<IProjectDescription, String> projectsPaths = new HashMap();
        if (PredefinedProjectsUtils.getAllEnvVars().isEmpty()) {
            return null;
        }
        File projectDir = new File(systemVarPath);
        if (!projectDir.exists()) {
            return null;
        }
        projectsPaths = PredefinedProjectsUtils.getPredefinedProjects(false);
        return projectsPaths;
    }

    public static String getSelectedProjectPath(String selectedProjectName) {
        Map<IProjectDescription, String> projectsPaths = OpenPredefinedProjectUtils.getPredefinedProjects();
        if (projectsPaths == null) {
            return null;
        }
        IProjectDescription pd = OpenPredefinedProjectUtils.getProjDesc(selectedProjectName, projectsPaths);
        String selectedProjectPath = projectsPaths.get(pd);
        if (selectedProjectPath == null) {
            return null;
        }
        return selectedProjectPath;
    }

    private static IProjectDescription getProjDesc(String projectName, Map<IProjectDescription, String> projectsPaths) {
        for (IProjectDescription pd : projectsPaths.keySet()) {
            if (!pd.getName().equals(projectName)) continue;
            return pd;
        }
        return null;
    }

    private static boolean runProjectOperation(final IRunnableWithProgress projectOp, final IWorkbenchWindow activeWorkbenchWindow) {
        final boolean[] result = new boolean[1];
        activeWorkbenchWindow.getShell().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    activeWorkbenchWindow.run(false, true, projectOp);
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                    return;
                }
                result[0] = true;
            }
        });
        return result[0];
    }

    public static boolean deleteExistingProject(File destFolder) {
        if (destFolder == null) {
            return false;
        }
        DeleteProjectRunnable deleteProjectRunnable = new DeleteProjectRunnable(destFolder);
        WorkspaceModifyDelegatingOperation deleteProjectOp = new WorkspaceModifyDelegatingOperation((IRunnableWithProgress)deleteProjectRunnable);
        IWorkbenchWindow activeWorkbenchWindow = DVTUiUtils.getActiveWorkbenchWindow();
        if (activeWorkbenchWindow == null) {
            return false;
        }
        return OpenPredefinedProjectUtils.runProjectOperation((IRunnableWithProgress)deleteProjectOp, activeWorkbenchWindow);
    }

    private static final class CreateProjectRunnable
    implements IRunnableWithProgress {
        private final IProjectDescription destinationProjectDescr;
        private IProject fProject;

        private CreateProjectRunnable(IProjectDescription destinationProjectDescr) {
            this.destinationProjectDescr = destinationProjectDescr;
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            try {
                IProjectDescription description = this.destinationProjectDescr;
                if (description == null) {
                    monitor.done();
                    return;
                }
                String projectName = description.getName();
                IWorkspace workspace = ResourcesPlugin.getWorkspace();
                this.fProject = workspace.getRoot().getProject(projectName);
                monitor.beginTask("Creating Project...", 100);
                if (this.fProject.exists()) {
                    return;
                }
                try {
                    this.fProject.create(description, (IProgressMonitor)new SubProgressMonitor(monitor, 33));
                    this.fProject.open(0, (IProgressMonitor)new SubProgressMonitor(monitor, 33));
                }
                catch (CoreException e) {
                    throw new InvocationTargetException(e);
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                }
            }
            finally {
                monitor.done();
            }
        }

        public IProject getProject() {
            return this.fProject;
        }
    }

    private static final class DeleteProjectRunnable
    implements IRunnableWithProgress {
        private final File fDestinationFolder;

        private DeleteProjectRunnable(File destinationFolder) {
            this.fDestinationFolder = destinationFolder;
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            if (this.fDestinationFolder == null) {
                monitor.done();
                return;
            }
            try {
                for (IProject project : this.getProjectsToDelete()) {
                    if (project == null || !project.exists()) continue;
                    project.delete(false, true, (IProgressMonitor)new SubProgressMonitor(monitor, 33));
                    ro.amiq.dvt.ui.Utils.closeOpenEditors(PlatformUI.getWorkbench().getDisplay(), project);
                }
            }
            catch (CoreException e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }

        private List<IProject> getProjectsToDelete() {
            ArrayList<IProject> result = new ArrayList<IProject>();
            result.add(this.getNameConflictingProject());
            result.add(this.getLocationConflictingProject());
            return result;
        }

        private IProject getLocationConflictingProject() {
            IProject[] projects;
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IProject[] iProjectArray = projects = workspace.getRoot().getProjects();
            int n = projects.length;
            int n2 = 0;
            while (n2 < n) {
                IProject project = iProjectArray[n2];
                if (project.getLocation().toFile().equals(this.fDestinationFolder)) {
                    return project;
                }
                ++n2;
            }
            return null;
        }

        private IProject getNameConflictingProject() {
            String projectName = this.fDestinationFolder.getName();
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            return workspace.getRoot().getProject(projectName);
        }
    }
}

