/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.dynamicactions.launchconfigs;

import java.util.HashMap;
import java.util.List;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.jface.bindings.Binding;
import org.eclipse.jface.bindings.BindingManagerEvent;
import org.eclipse.jface.bindings.IBindingManagerListener;
import org.eclipse.ui.PlatformUI;
import ro.amiq.dvt.dynamicactions.launchconfigs.DynamicLaunchConfigToolbar;
import ro.amiq.dvt.dynamicactions.launchconfigs.DynamicLaunchConfigUtils;
import ro.amiq.dvt.startup.core.DVTLogger;

public class DVTBindingManagerListener
implements IBindingManagerListener {
    public void bindingManagerChanged(BindingManagerEvent event) {
        try {
            Binding[] allBindings;
            if (DynamicLaunchConfigToolbar.INSTANCE.fNameLaunchConfigMap.isEmpty() || PlatformUI.getWorkbench().isStarting() || PlatformUI.getWorkbench().isClosing()) {
                return;
            }
            HashMap<String, String> commandIdAccelerator = new HashMap<String, String>();
            boolean triggerRefesh = false;
            Binding[] bindingArray = allBindings = event.getManager().getBindings();
            int n = allBindings.length;
            int n2 = 0;
            while (n2 < n) {
                Binding binding = bindingArray[n2];
                if (binding.getParameterizedCommand() != null && binding.getParameterizedCommand().getCommand() != null) {
                    commandIdAccelerator.put(binding.getParameterizedCommand().getCommand().getId(), binding.getTriggerSequence().toString());
                }
                ++n2;
            }
            List<ILaunchConfiguration> currentLaunchConfigurations = DynamicLaunchConfigToolbar.INSTANCE.getLaunchConfigList(DebugUIPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.debug.ui.PREF_FILTER_WORKING_SETS"), true);
            for (ILaunchConfiguration configuration : currentLaunchConfigurations) {
                if (!configuration.exists()) continue;
                String accelerator = (String)commandIdAccelerator.get(DynamicLaunchConfigUtils.createCommandId(configuration));
                if (accelerator == null) {
                    accelerator = "";
                }
                if (accelerator.equals(DynamicLaunchConfigUtils.getActionBinding(configuration))) continue;
                ILaunchConfigurationWorkingCopy configCopy = configuration.getWorkingCopy();
                configCopy.setAttribute("ro.amiq.dvt.launch.SHORTCUT_BINDING", accelerator);
                configCopy.setAttribute("ro.amiq.dvt.launch.CREATE_ACCELERATOR", !accelerator.isEmpty());
                DynamicLaunchConfigToolbar.INSTANCE.fNameLaunchConfigMap.put(configuration.getName(), configCopy);
                triggerRefesh = true;
            }
            if (triggerRefesh) {
                DynamicLaunchConfigToolbar.INSTANCE.asyncRefresh();
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }
}

