/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.dynamicactions.launchconfigs;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.commands.Command;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.bindings.Binding;
import org.eclipse.jface.bindings.IBindingManagerListener;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.keys.IBindingService;
import ro.amiq.dvt.dynamicactions.launchconfigs.DVTBindingManagerListener;
import ro.amiq.dvt.dynamicactions.launchconfigs.DynamicCommandHandler;
import ro.amiq.dvt.dynamicactions.launchconfigs.DynamicLaunchConfigUtils;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.startup.core.DVTUiUtils;
import ro.amiq.dvt.startup.core.EclipseUtils;

public enum DynamicLaunchConfigToolbar implements IWindowListener
{
    INSTANCE;

    public static final String TOOLBAR_ID = "ro.amiq.dvt.dynamicactions";
    public final DVTBindingManagerListener fGlobalBindingManagerListener = new DVTBindingManagerListener();
    public final ConcurrentHashMap<String, ILaunchConfigurationWorkingCopy> fNameLaunchConfigMap = new ConcurrentHashMap();
    private IBindingService fBindingService;
    private boolean cleanE4ModelDisabled = false;

    public void init() {
        this.fBindingService = (IBindingService)PlatformUI.getWorkbench().getService(IBindingService.class);
        this.fBindingService.addBindingManagerListener((IBindingManagerListener)this.fGlobalBindingManagerListener);
        PlatformUI.getWorkbench().addWindowListener((IWindowListener)this);
        this.refresh();
    }

    public void refresh() {
        try {
            final List<ILaunchConfiguration> currentLaunchConfigurations = this.getLaunchConfigList(DebugUIPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.debug.ui.PREF_FILTER_WORKING_SETS"), false);
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        Set<Binding> bindings = DynamicLaunchConfigUtils.getBindings();
                        boolean bindingsChanged = false;
                        if (DynamicLaunchConfigToolbar.this.fNameLaunchConfigMap.isEmpty()) {
                            for (ILaunchConfiguration iLaunchConfiguration : currentLaunchConfigurations) {
                                try {
                                    if (!iLaunchConfiguration.exists()) continue;
                                    bindingsChanged |= DynamicLaunchConfigUtils.removeBinding(iLaunchConfiguration, bindings);
                                    bindingsChanged |= DynamicLaunchConfigUtils.addBinding(iLaunchConfiguration, bindings);
                                    DynamicLaunchConfigToolbar.this.fNameLaunchConfigMap.put(iLaunchConfiguration.getName(), iLaunchConfiguration.getWorkingCopy());
                                }
                                catch (DebugException e) {
                                    DVTLogger.INSTANCE.logError((Throwable)e);
                                }
                            }
                        } else {
                            for (ILaunchConfiguration iLaunchConfiguration : currentLaunchConfigurations) {
                                try {
                                    ILaunchConfiguration storedConfig;
                                    if (!iLaunchConfiguration.exists() || (storedConfig = (ILaunchConfiguration)DynamicLaunchConfigToolbar.this.fNameLaunchConfigMap.get(iLaunchConfiguration.getName())) == null || DynamicLaunchConfigUtils.areConfigsEqual(storedConfig, iLaunchConfiguration)) continue;
                                    bindingsChanged |= DynamicLaunchConfigUtils.removeBinding(storedConfig, bindings);
                                    bindingsChanged |= DynamicLaunchConfigUtils.removeBinding(iLaunchConfiguration, bindings);
                                    bindingsChanged |= DynamicLaunchConfigUtils.addBinding(iLaunchConfiguration, bindings);
                                    DynamicLaunchConfigToolbar.this.fNameLaunchConfigMap.put(iLaunchConfiguration.getName(), iLaunchConfiguration.getWorkingCopy());
                                }
                                catch (DebugException e) {
                                    DVTLogger.INSTANCE.logError((Throwable)e);
                                }
                            }
                        }
                        if (bindingsChanged) {
                            DynamicLaunchConfigUtils.saveBindings(bindings);
                        }
                    }
                    catch (Exception e) {
                        DVTLogger.INSTANCE.logError((Throwable)e);
                    }
                }
            });
            IToolBarManager toolbarManager = DVTUiUtils.getToolbarManager((String)TOOLBAR_ID);
            if (toolbarManager == null) {
                return;
            }
            IContributionItem[] items = toolbarManager.getItems();
            toolbarManager.removeAll();
            if (EclipseUtils.isEclipse4x()) {
                this.cleanE4Model(items);
            }
            for (ILaunchConfiguration configuration : currentLaunchConfigurations) {
                if (!configuration.exists() || !DynamicLaunchConfigUtils.shouldCreateToolItem(configuration)) continue;
                Command command = DynamicLaunchConfigUtils.getCommand(configuration, true);
                command.setEnabled(null);
                toolbarManager.add((IAction)new RunAction(configuration));
            }
            DVTUiUtils.redrawToolbarInCoolbar((String)TOOLBAR_ID);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public void asyncRefresh() {
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                DynamicLaunchConfigToolbar.this.refresh();
            }
        });
    }

    private void cleanE4Model(IContributionItem[] items) {
        if (this.cleanE4ModelDisabled) {
            return;
        }
        try {
            Method[] methods;
            IWorkbenchWindow window = DVTUiUtils.getActiveWorkbenchWindow();
            Field rendererFactoryF = window.getClass().getDeclaredField("rendererFactory");
            rendererFactoryF.setAccessible(true);
            Object rendererFactoryO = rendererFactoryF.get(window);
            Field toolbarRendererF = rendererFactoryO.getClass().getDeclaredField("toolbarRenderer");
            toolbarRendererF.setAccessible(true);
            Object toolbarRendererO = toolbarRendererF.get(rendererFactoryO);
            Method getToolElementM = toolbarRendererO.getClass().getMethod("getToolElement", IContributionItem.class);
            Method clearModelToContributionM = null;
            Method[] methodArray = methods = toolbarRendererO.getClass().getMethods();
            int n = methods.length;
            int n2 = 0;
            while (n2 < n) {
                Method method = methodArray[n2];
                if (method.getName().equals("clearModelToContribution")) {
                    clearModelToContributionM = method;
                    break;
                }
                ++n2;
            }
            if (clearModelToContributionM != null) {
                methodArray = items;
                n = items.length;
                n2 = 0;
                while (n2 < n) {
                    Method getParentM;
                    Object parentO;
                    Method item = methodArray[n2];
                    Object elemO = getToolElementM.invoke(toolbarRendererO, item);
                    if (elemO != null && (parentO = (getParentM = elemO.getClass().getMethod("getParent", new Class[0])).invoke(elemO, new Object[0])) != null) {
                        Method getChildrenM = parentO.getClass().getMethod("getChildren", new Class[0]);
                        Object childrenO = getChildrenM.invoke(parentO, new Object[0]);
                        if (childrenO != null && childrenO instanceof List) {
                            ((List)childrenO).remove(elemO);
                        }
                        clearModelToContributionM.invoke(toolbarRendererO, elemO, item);
                    }
                    ++n2;
                }
            }
        }
        catch (ReflectiveOperationException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            this.cleanE4ModelDisabled = true;
        }
        catch (Throwable e) {
            DVTLogger.INSTANCE.logError(e);
        }
    }

    private Display getDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    public List<ILaunchConfiguration> getLaunchConfigList(boolean applyWorkingSet, boolean filterReadOnly) {
        try {
            ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
            ILaunchConfiguration[] launchConfigurations = launchManager.getLaunchConfigurations();
            if (PlatformUI.getWorkbench() == null || PlatformUI.getWorkbench().getActiveWorkbenchWindow() == null || PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage() == null) {
                return new ArrayList<ILaunchConfiguration>();
            }
            IWorkingSet[] workingSets = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getWorkingSets();
            ArrayList<IAdaptable> elems = new ArrayList<IAdaptable>();
            IWorkingSet[] iWorkingSetArray = workingSets;
            int n = workingSets.length;
            int n2 = 0;
            while (n2 < n) {
                IWorkingSet iWorkingSet = iWorkingSetArray[n2];
                elems.addAll(Arrays.asList(iWorkingSet.getElements()));
                ++n2;
            }
            HashSet<String> wsProjectNames = new HashSet<String>();
            HashSet<IProject> wsProjects = new HashSet<IProject>();
            for (IAdaptable iAdaptable : elems) {
                IProject project;
                IResource res = (IResource)iAdaptable.getAdapter(IResource.class);
                if (res == null || (project = res.getProject()) == null) continue;
                wsProjects.add(project);
            }
            for (IProject iProject : wsProjects) {
                wsProjectNames.add(iProject.getName());
            }
            LinkedList<ILaunchConfiguration> runModeLaunchConfigurations = new LinkedList<ILaunchConfiguration>();
            ILaunchConfiguration[] iLaunchConfigurationArray = launchConfigurations;
            int n3 = launchConfigurations.length;
            int n4 = 0;
            while (n4 < n3) {
                IProject proj;
                ILaunchConfiguration launchConfiguration = iLaunchConfigurationArray[n4];
                if (launchConfiguration.exists() && (launchConfiguration.supportsMode("run") || launchConfiguration.supportsMode("ro.amiq.dvt.linter.launch.mode")) && ((proj = DynamicLaunchConfigUtils.getProject(launchConfiguration)) == null || proj.isAccessible())) {
                    if (!wsProjectNames.isEmpty() && applyWorkingSet && proj != null) {
                        String projectName = proj.getName();
                        if (wsProjectNames.contains(projectName)) {
                            runModeLaunchConfigurations.add(launchConfiguration);
                        }
                    } else {
                        runModeLaunchConfigurations.add(launchConfiguration);
                    }
                }
                ++n4;
            }
            if (filterReadOnly) {
                return this.orderLaunchConfigsToolbarPosition(this.filterReadOnlyLaunchConfig(runModeLaunchConfigurations));
            }
            return this.orderLaunchConfigsToolbarPosition(runModeLaunchConfigurations);
        }
        catch (CoreException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return new ArrayList<ILaunchConfiguration>();
        }
    }

    private List<ILaunchConfiguration> filterReadOnlyLaunchConfig(List<ILaunchConfiguration> configs) {
        ArrayList<ILaunchConfiguration> result = new ArrayList<ILaunchConfiguration>();
        for (ILaunchConfiguration iLaunchConfiguration : configs) {
            if (iLaunchConfiguration.isReadOnly()) continue;
            result.add(iLaunchConfiguration);
        }
        return result;
    }

    private List<ILaunchConfiguration> orderLaunchConfigsToolbarPosition(List<ILaunchConfiguration> configs) {
        LinkedHashMap<Integer, List> orderedConfigsMap = new LinkedHashMap<Integer, List>();
        for (ILaunchConfiguration configuration : configs) {
            try {
                String orderStr = (String)configuration.getAttributes().get("ro.amiq.dvt.launch.SHORTCUT_TOOLBAR_ORDER");
                Integer order = 0;
                if (orderStr != null && (order = Integer.valueOf(Integer.parseInt(orderStr))) < 0) {
                    order = 0;
                }
                if (!orderedConfigsMap.containsKey(order)) {
                    orderedConfigsMap.put(order, new LinkedList());
                }
                List mapConfigs = (List)orderedConfigsMap.get(order);
                mapConfigs.add(configuration);
                orderedConfigsMap.put(order, mapConfigs);
            }
            catch (Exception exception) {
                if (!orderedConfigsMap.containsKey(0)) {
                    orderedConfigsMap.put(0, new LinkedList());
                }
                List mapConfigs = (List)orderedConfigsMap.get(0);
                mapConfigs.add(configuration);
                orderedConfigsMap.put(0, mapConfigs);
            }
        }
        LinkedList<ILaunchConfiguration> orderedList = new LinkedList<ILaunchConfiguration>();
        LinkedList keys = new LinkedList(orderedConfigsMap.keySet());
        Collections.sort(keys);
        for (Integer key : keys) {
            List values = (List)orderedConfigsMap.get(key);
            if (values.size() > 1) {
                Collections.sort(values, new Comparator<ILaunchConfiguration>(){

                    @Override
                    public int compare(ILaunchConfiguration o1, ILaunchConfiguration o2) {
                        return o1.getName().compareTo(o2.getName());
                    }
                });
            }
            orderedList.addAll(values);
        }
        return orderedList;
    }

    public void windowActivated(IWorkbenchWindow window) {
        this.asyncRefresh();
    }

    public void windowOpened(IWorkbenchWindow window) {
        this.asyncRefresh();
    }

    public void windowDeactivated(IWorkbenchWindow window) {
    }

    public void windowClosed(IWorkbenchWindow window) {
    }

    private class RunAction
    extends Action {
        private final ILaunchConfiguration fConfiguration;

        public RunAction(ILaunchConfiguration configuration) {
            this.fConfiguration = configuration;
            this.setId(configuration.getName());
            String shortcutTooltip = "";
            if (DynamicLaunchConfigUtils.shouldCreateKeyBinding(configuration)) {
                shortcutTooltip = " (" + DynamicLaunchConfigUtils.getActionBinding(configuration) + ")";
            }
            this.setToolTipText(String.valueOf(configuration.getName()) + shortcutTooltip);
            Image image = DynamicLaunchConfigUtils.getImage(configuration);
            if (image != null) {
                this.setImageDescriptor(ImageDescriptor.createFromImage((Image)image));
            }
        }

        public boolean isEnabled() {
            return true;
        }

        public boolean isHandled() {
            return true;
        }

        public void run() {
            DynamicCommandHandler.launch(this.fConfiguration);
        }
    }
}

