/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.dynamicactions.launchconfigs;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.commands.Category;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jface.bindings.Binding;
import org.eclipse.jface.bindings.IBindingManagerListener;
import org.eclipse.jface.bindings.Trigger;
import org.eclipse.jface.bindings.keys.KeyBinding;
import org.eclipse.jface.bindings.keys.KeySequence;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.keys.IBindingService;
import ro.amiq.dvt.dynamicactions.launchconfigs.DynamicCommandHandler;
import ro.amiq.dvt.dynamicactions.launchconfigs.DynamicLaunchConfigToolbar;
import ro.amiq.dvt.dynamicactions.launchconfigs.IconGenerator;
import ro.amiq.dvt.launch.ui.DVTShortcutsTab;
import ro.amiq.dvt.startup.core.DVTLogger;

public class DynamicLaunchConfigUtils {
    public static final String COMMAND_NAME_PREFIX = "Launch ";
    public static final String COMMAND_ID_PREFIX = "dynamic.action.";
    public static final String DEFAULT_ACTION_BINDING = "";
    public static final String DEFAULT_ICON_LABEL = "1";
    public static final String DEFAULT_ICON_BGCOLOR = "ffffff";
    public static final IBindingService fBindingService = (IBindingService)PlatformUI.getWorkbench().getService(IBindingService.class);
    public static final ICommandService fCommandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
    public static final Category fCategory = fCommandService.getCategory("z.runconfig.dynamic.action.category");
    public static final ConcurrentHashMap<String, Image> fIconsCache = new ConcurrentHashMap();

    public static Set<Binding> getBindings() {
        LinkedHashSet<Binding> bindings = new LinkedHashSet<Binding>(Arrays.asList(fBindingService.getBindings()));
        return bindings;
    }

    public static void saveBindings(Set<Binding> allBindings) {
        DynamicLaunchConfigUtils.removeBindingListener();
        try {
            fBindingService.savePreferences(fBindingService.getActiveScheme(), allBindings.toArray(new Binding[allBindings.size()]));
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        DynamicLaunchConfigUtils.addBidingListener();
    }

    public static boolean removeBinding(ILaunchConfiguration launchConfiguration, Set<Binding> allBindings) {
        Binding originalBinding;
        block6: {
            block5: {
                if (launchConfiguration != null) break block5;
                return false;
            }
            try {
                String commandId = DynamicLaunchConfigUtils.createCommandId(launchConfiguration);
                originalBinding = null;
                for (Binding binding : allBindings) {
                    if (binding.getParameterizedCommand() == null || binding.getTriggerSequence() == null || !binding.getParameterizedCommand().getId().equals(commandId)) continue;
                    originalBinding = binding;
                }
                if (originalBinding != null) break block6;
                return false;
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                return false;
            }
        }
        return allBindings.remove(originalBinding);
    }

    public static boolean addBinding(ILaunchConfiguration launchConfiguration, Set<Binding> allBindings) {
        KeyBinding kb;
        block7: {
            block6: {
                block5: {
                    try {
                        if (launchConfiguration != null && launchConfiguration.exists()) break block5;
                        return false;
                    }
                    catch (Exception e) {
                        DVTLogger.INSTANCE.logError((Throwable)e);
                        return false;
                    }
                }
                if (DynamicLaunchConfigUtils.shouldCreateKeyBinding(launchConfiguration)) break block6;
                return false;
            }
            kb = DynamicLaunchConfigUtils.createKeyBinding(launchConfiguration);
            if (kb != null) break block7;
            return false;
        }
        return allBindings.add((Binding)kb);
    }

    public static KeyBinding createKeyBinding(ILaunchConfiguration launchConfiguration) {
        KeySequence keySequence;
        ParameterizedCommand parameterizedCommand;
        block5: {
            String actionBinding;
            block4: {
                try {
                    actionBinding = DynamicLaunchConfigUtils.getActionBinding(launchConfiguration);
                    if (!actionBinding.isEmpty()) break block4;
                    return null;
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                    return null;
                }
            }
            Command command = DynamicLaunchConfigUtils.getCommand(launchConfiguration, true);
            command.setEnabled(null);
            actionBinding = actionBinding.replaceAll(" ", DEFAULT_ACTION_BINDING).toUpperCase();
            parameterizedCommand = ParameterizedCommand.generateCommand((Command)command, null);
            keySequence = KeySequence.getInstance((String)actionBinding);
            if (keySequence.isComplete()) break block5;
            return null;
        }
        KeyBinding keyBinding = new KeyBinding(keySequence, parameterizedCommand, "org.eclipse.ui.defaultAcceleratorConfiguration", "org.eclipse.ui.contexts.window", null, null, null, 1);
        return keyBinding;
    }

    public static void removeBindingListener() {
        ((IBindingService)PlatformUI.getWorkbench().getService(IBindingService.class)).removeBindingManagerListener((IBindingManagerListener)DynamicLaunchConfigToolbar.INSTANCE.fGlobalBindingManagerListener);
    }

    public static void addBidingListener() {
        ((IBindingService)PlatformUI.getWorkbench().getService(IBindingService.class)).addBindingManagerListener((IBindingManagerListener)DynamicLaunchConfigToolbar.INSTANCE.fGlobalBindingManagerListener);
    }

    public static Command getCommand(ILaunchConfiguration configuration, boolean shouldDefine) {
        String commandId = DynamicLaunchConfigUtils.createCommandId(configuration);
        Command command = fCommandService.getCommand(commandId);
        if (!fCategory.isDefined()) {
            fCategory.define("DVT Dynamic Actions", "DVT Dynamic Run Configuration Actions");
        }
        if (!command.isDefined()) {
            if (!shouldDefine) {
                return null;
            }
            command.define(COMMAND_NAME_PREFIX + configuration.getName(), "DO NOT MODIFY FROM HERE! To modify it, go to \"Run Configurations -> select " + configuration.getName() + " -> Shortcuts Tab -> deselect Create Accelerator\"", fCategory);
        }
        if (!command.isHandled()) {
            IHandlerService serv = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
            serv.activateHandler(commandId, (IHandler)new DynamicCommandHandler(configuration), null, true);
        }
        return command;
    }

    public static String createCommandId(ILaunchConfiguration configuration) {
        return COMMAND_ID_PREFIX + configuration.getName().replaceAll(" ", "_");
    }

    public static String getLaunchConfigurationNameFromCommandId(String commandId) {
        return commandId.replace(COMMAND_ID_PREFIX, DEFAULT_ACTION_BINDING).replaceAll("_", " ");
    }

    public static boolean shouldCreateKeyBinding(ILaunchConfiguration configuration) {
        boolean result = false;
        if (configuration == null || !configuration.exists()) {
            return result;
        }
        try {
            result = configuration.getAttribute("ro.amiq.dvt.launch.CREATE_ACCELERATOR", false);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return result;
    }

    public static boolean shouldCreateToolItem(ILaunchConfiguration configuration) {
        boolean result = false;
        if (configuration == null || !configuration.exists()) {
            return result;
        }
        try {
            result = configuration.getAttribute("ro.amiq.dvt.launch.CREATE_SHORTCUT", false);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return result;
    }

    public static String getActionBinding(ILaunchConfiguration configuration) {
        String actionBinding = DEFAULT_ACTION_BINDING;
        if (configuration == null || !configuration.exists()) {
            return actionBinding;
        }
        try {
            actionBinding = configuration.getAttribute("ro.amiq.dvt.launch.SHORTCUT_BINDING", DEFAULT_ACTION_BINDING);
            KeySequence keySequence = KeySequence.getInstance((String)actionBinding.replaceAll(" ", DEFAULT_ACTION_BINDING).toUpperCase());
            return keySequence.toString();
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return actionBinding;
        }
    }

    public static Image getImage(ILaunchConfiguration configuration) {
        File iconFile;
        block5: {
            try {
                if (configuration != null && configuration.exists()) break block5;
                return null;
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                return null;
            }
        }
        String iconPath = configuration.getAttribute("ro.amiq.dvt.launch.SHORTCUT_ICON_PATH", DEFAULT_ACTION_BINDING);
        if (iconPath != null && !iconPath.isEmpty() && (iconPath = DVTShortcutsTab.getFullPathOfIcon(iconPath, configuration)) != null && (iconFile = new File(iconPath)).canRead() && iconFile.isFile()) {
            Image result = fIconsCache.get(iconPath);
            if (result != null) {
                return result;
            }
            result = new Image((Device)Display.getDefault(), iconPath);
            fIconsCache.put(iconPath, result);
            return result;
        }
        return DynamicLaunchConfigUtils.getGeneratedImage(configuration);
    }

    public static Image getGeneratedImage(ILaunchConfiguration configuration) throws Exception {
        String iconLabel = configuration.getAttribute("ro.amiq.dvt.launch.SHORTCUT_ICON_LETTER", DEFAULT_ICON_LABEL);
        String iconBgColor = configuration.getAttribute("ro.amiq.dvt.launch.SHORTCUT_ICON_BGCOLOR", DEFAULT_ICON_BGCOLOR);
        String key = String.valueOf(iconLabel) + "-" + iconBgColor;
        Image result = fIconsCache.get(key);
        if (result != null) {
            return result;
        }
        result = IconGenerator.generateIcon(iconLabel, iconBgColor);
        fIconsCache.put(key, result);
        return result;
    }

    public static boolean validateAccelerator(String accelerator) {
        try {
            KeySequence.getInstance((String)accelerator.replaceAll(" ", DEFAULT_ACTION_BINDING).toUpperCase());
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public static boolean areConfigsEqual(ILaunchConfiguration configuration1, ILaunchConfiguration configuration2) {
        block3: {
            try {
                if (DynamicLaunchConfigUtils.shouldCreateKeyBinding(configuration1) == DynamicLaunchConfigUtils.shouldCreateKeyBinding(configuration2)) break block3;
                return false;
            }
            catch (Exception exception) {
                return false;
            }
        }
        return DynamicLaunchConfigUtils.getActionBinding(configuration1).equalsIgnoreCase(DynamicLaunchConfigUtils.getActionBinding(configuration2));
    }

    public static List<Binding> getBindingsForAccelerator(String accelerator) {
        block10: {
            if (!accelerator.isEmpty()) break block10;
            return null;
        }
        try {
            Binding[] bindings;
            ArrayList<Binding> bindingsForAccelerator = new ArrayList<Binding>();
            KeySequence keySequence = KeySequence.getInstance((String)accelerator.replaceAll(" ", DEFAULT_ACTION_BINDING).toUpperCase());
            Trigger[] triggers1 = keySequence.getTriggers();
            HashSet<Binding> systemBindings = new HashSet<Binding>();
            HashSet<Binding> userBindings = new HashSet<Binding>();
            Binding[] bindingArray = bindings = fBindingService.getBindings();
            int n = bindings.length;
            int n2 = 0;
            while (n2 < n) {
                Binding binding = bindingArray[n2];
                Trigger[] triggers2 = binding.getTriggerSequence().getTriggers();
                if (triggers1[0].toString().equalsIgnoreCase(triggers2[0].toString())) {
                    if (binding.getType() == 0) {
                        systemBindings.add(binding);
                    } else if (binding.getType() == 1) {
                        userBindings.add(binding);
                    }
                }
                ++n2;
            }
            Iterator sysIt = systemBindings.iterator();
            block4: while (sysIt.hasNext()) {
                Binding systemBinding = (Binding)sysIt.next();
                Iterator userIt = userBindings.iterator();
                while (userIt.hasNext()) {
                    Binding userBinding = (Binding)userIt.next();
                    if (userBinding.getParameterizedCommand() != null || !DynamicLaunchConfigUtils.userBindingRemovesSystemBinding(systemBinding, userBinding)) continue;
                    sysIt.remove();
                    userIt.remove();
                    continue block4;
                }
            }
            bindingsForAccelerator.addAll(systemBindings);
            bindingsForAccelerator.addAll(userBindings);
            return bindingsForAccelerator;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static boolean userBindingRemovesSystemBinding(Binding systemBinding, Binding userBinding) {
        boolean deletes = true;
        deletes &= userBinding.getContextId().equals(systemBinding.getContextId());
        deletes &= userBinding.getTriggerSequence().equals((Object)systemBinding.getTriggerSequence());
        if (userBinding.getLocale() != null) {
            deletes &= userBinding.getLocale().equals(systemBinding.getLocale());
        }
        if (userBinding.getPlatform() != null) {
            deletes &= userBinding.getPlatform().equals(systemBinding.getPlatform());
        }
        deletes &= systemBinding.getType() == 0;
        return deletes &= userBinding.getParameterizedCommand() == null;
    }

    public static IProject getProject(ILaunchConfiguration configuration) {
        String pName;
        block3: {
            try {
                pName = null;
                pName = configuration.getType().getIdentifier().equals("ro.amiq.dvt.linter.launch.SVLintLaunchConfiguration") ? configuration.getAttribute("ro.amiq.dvt.linter.launch.project", DEFAULT_ACTION_BINDING) : configuration.getAttribute("ro.amiq.dvt.launch.PROJECT_ATTR", DEFAULT_ACTION_BINDING);
                if (pName != null && !pName.isEmpty()) break block3;
                return null;
            }
            catch (CoreException coreException) {
                return null;
            }
        }
        return ResourcesPlugin.getWorkspace().getRoot().getProject(pName);
    }

    public static String getProjectLocation(ILaunchConfiguration configuration) {
        IProject proj = DynamicLaunchConfigUtils.getProject(configuration);
        if (proj == null) {
            return DEFAULT_ACTION_BINDING;
        }
        return proj.getLocation().toOSString();
    }

    public static String getSchemeForBinding(Binding binding) {
        try {
            return fBindingService.getScheme(binding.getSchemeId()).getName();
        }
        catch (NotDefinedException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }
}

