/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.dynamicactions.launchconfigs;

import java.util.Arrays;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class IconGenerator {
    public static final int ICON_DIMENSION = 16;
    public static final int PREVIEW_ICON_DIMENSION = 64;
    public static final boolean IS_WIN = "win32".equals(Platform.getOS());

    private static RGB stringToRGB(String string) {
        if (string.length() != 6) {
            return new RGB(0, 0, 0);
        }
        int red = 0;
        int green = 0;
        int blue = 0;
        try {
            red = Integer.decode("0x" + string.substring(0, 2));
            green = Integer.decode("0x" + string.substring(2, 4));
            blue = Integer.decode("0x" + string.substring(4, 6));
        }
        catch (Exception exception) {
            return new RGB(0, 0, 0);
        }
        return new RGB(red, green, blue);
    }

    public static String rgbToString(RGB rgb) {
        String red = Integer.toHexString(rgb.red);
        String green = Integer.toHexString(rgb.green);
        String blue = Integer.toHexString(rgb.blue);
        if (red.length() == 1) {
            red = String.valueOf(red) + red;
        }
        if (green.length() == 1) {
            green = String.valueOf(green) + green;
        }
        if (blue.length() == 1) {
            blue = String.valueOf(blue) + blue;
        }
        return String.valueOf(red) + green + blue;
    }

    public static Image generateIcon(String character, String hexColor) throws Exception {
        return IconGenerator.generateSWTImage(16, character, hexColor);
    }

    public static Image generatePreview(String character, String hexColor) throws Exception {
        return IconGenerator.generateSWTImage(64, character, hexColor);
    }

    private static Image generateSWTImage(int dimension, String character, String hexColor) {
        if (character == null) {
            character = "1";
        }
        if (character.length() > 1) {
            character = Character.toString(character.charAt(0));
        }
        RGB rgb = IconGenerator.stringToRGB(hexColor);
        Display display = Display.getDefault();
        Image image = IconGenerator.createOpaqueImage(dimension);
        GC gc = new GC((Drawable)image);
        gc.setAdvanced(true);
        gc.setAntialias(1);
        gc.setTextAntialias(1);
        gc.setBackground(display.getSystemColor(1));
        gc.fillRectangle(0, 0, dimension, dimension);
        int lineWidth = dimension / 16;
        if (rgb.blue == 0 && rgb.red == 0 && rgb.green == 0) {
            rgb = new RGB(1, 1, 1);
        }
        Color fillColor = new Color((Device)display, rgb);
        gc.setBackground(fillColor);
        gc.fillOval(lineWidth, lineWidth, dimension - 2 * lineWidth, dimension - 2 * lineWidth);
        fillColor.dispose();
        ImageData imageData = image.getImageData();
        double spot = (double)dimension / 4.0;
        int col = 0;
        while (col < dimension) {
            int row = 0;
            while (row < dimension) {
                int oldB;
                int oldG;
                int oldR;
                double dx = (double)col - spot;
                double dy = (double)row - spot;
                double dist = Math.sqrt(dx * dx + dy * dy);
                if (dist > (double)dimension) {
                    dist = dimension;
                }
                int currColor = imageData.getPixel(col, row);
                if (IS_WIN) {
                    oldR = currColor >>> 8 & 0xFF;
                    oldG = currColor >>> 16 & 0xFF;
                    oldB = currColor >>> 24 & 0xFF;
                } else {
                    oldR = currColor >>> 16 & 0xFF;
                    oldG = currColor >>> 8 & 0xFF;
                    oldB = currColor >>> 0 & 0xFF;
                }
                if (oldR != 0 || oldB != 0 || oldG != 0) {
                    double coef = 0.8 - 0.8 * dist / (double)dimension;
                    int dr = 255 - oldR;
                    int dg = 255 - oldG;
                    int db = 255 - oldB;
                    int newR = (int)((double)oldR + coef * (double)dr);
                    int newG = (int)((double)oldG + coef * (double)dg);
                    int newB = (int)((double)oldB + coef * (double)db);
                    Color color = new Color((Device)display, new RGB(newR, newG, newB));
                    gc.setForeground(color);
                    gc.drawPoint(col, row);
                    color.dispose();
                }
                ++row;
            }
            ++col;
        }
        gc.setLineWidth(lineWidth);
        gc.setForeground(display.getSystemColor(2));
        gc.drawOval(lineWidth / 2, lineWidth / 2, dimension - lineWidth, dimension - lineWidth);
        Font font = new Font((Device)display, new FontData("Sans", dimension / 2, 1));
        gc.setFont(font);
        Point textSize = gc.stringExtent(character);
        gc.drawString(character, (dimension - textSize.x + 1) / 2, (dimension - textSize.y + 1) / 2, true);
        font.dispose();
        imageData = image.getImageData();
        image.dispose();
        return IconGenerator.createTransparentImage(imageData, dimension);
    }

    private static Image createOpaqueImage(int dimension) {
        ImageData opaqueImageData = new ImageData(dimension, dimension, 32, new PaletteData(0xFF0000, 65280, 255));
        byte[] alphas = new byte[dimension * dimension];
        Arrays.fill(alphas, (byte)-1);
        opaqueImageData.setAlphas(0, 0, dimension * dimension, alphas, 0);
        return new Image((Device)Display.getDefault(), opaqueImageData);
    }

    private static Image createTransparentImage(ImageData imageData, int dimension) {
        int row;
        int col = 0;
        while (col < dimension) {
            row = 0;
            while (row < dimension / 2) {
                if (!IconGenerator.setTransparency(imageData, col, row)) break;
                ++row;
            }
            ++col;
        }
        col = 0;
        while (col < dimension) {
            row = dimension - 1;
            while (row >= dimension / 2) {
                if (!IconGenerator.setTransparency(imageData, col, row)) break;
                --row;
            }
            ++col;
        }
        return new Image((Device)Display.getDefault(), imageData);
    }

    private static boolean setTransparency(ImageData imageData, int col, int row) {
        int b;
        int g;
        int r;
        int currColor = imageData.getPixel(col, row);
        if (IS_WIN) {
            r = currColor >>> 8 & 0xFF;
            g = currColor >>> 16 & 0xFF;
            b = currColor >>> 24 & 0xFF;
        } else {
            r = currColor >>> 16 & 0xFF;
            g = currColor >>> 8 & 0xFF;
            b = currColor >>> 0 & 0xFF;
        }
        if (r == 0 && g == 0 && b == 0) {
            return false;
        }
        if (r == 255 && g == 255 && b == 255) {
            imageData.setAlpha(col, row, 0);
        } else if (r == g && g == b) {
            imageData.setPixel(col, row, 0);
            imageData.setAlpha(col, row, 255 - r);
            return false;
        }
        return true;
    }
}

