/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.dynamicactions.launchconfigs;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Set;
import org.eclipse.core.commands.Command;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationListener;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jface.bindings.Binding;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import ro.amiq.dvt.dynamicactions.launchconfigs.DynamicLaunchConfigToolbar;
import ro.amiq.dvt.dynamicactions.launchconfigs.DynamicLaunchConfigUtils;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.startup.core.DVTUiUtils;
import ro.amiq.dvt.startup.core.EclipseUtils;

public enum LaunchConfigListener implements ILaunchConfigurationListener
{
    INSTANCE;

    private static final String DVT_LAUNCH_CONFIG_TYPE_ID = "ro.amiq.dvt.launch.DVTGenericLaunchConfigurationType";
    private static final String SVLINT_LAUNCH_CONFIG_TYPE_ID = "ro.amiq.dvt.linter.launch.SVLintLaunchConfiguration";
    private boolean cleanE4ModelDisabled = false;

    public void launchConfigurationAdded(final ILaunchConfiguration configuration) {
        if (!this.isValidLaunchConfigurationType(configuration)) {
            return;
        }
        if (configuration.isWorkingCopy() && ((ILaunchConfigurationWorkingCopy)configuration).isDirty()) {
            return;
        }
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    if (!LaunchConfigListener.this.isValidLaunchConfigurationType(configuration)) {
                        return;
                    }
                    Set<Binding> bindings = DynamicLaunchConfigUtils.getBindings();
                    boolean bindingsChanged = DynamicLaunchConfigUtils.addBinding(configuration, bindings);
                    if (bindingsChanged) {
                        DynamicLaunchConfigUtils.saveBindings(bindings);
                    }
                    DynamicLaunchConfigToolbar.INSTANCE.fNameLaunchConfigMap.put(configuration.getName(), configuration.getWorkingCopy());
                    if (DynamicLaunchConfigUtils.shouldCreateToolItem(configuration)) {
                        DynamicLaunchConfigToolbar.INSTANCE.refresh();
                    }
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                }
            }
        });
    }

    public void launchConfigurationChanged(final ILaunchConfiguration configuration) {
        if (!this.isValidLaunchConfigurationType(configuration)) {
            return;
        }
        if (configuration.isWorkingCopy() && ((ILaunchConfigurationWorkingCopy)configuration).isDirty()) {
            return;
        }
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                LaunchConfigListener.this.launchConfigurationRemoved(configuration);
                LaunchConfigListener.this.launchConfigurationAdded(configuration);
            }
        });
    }

    public void launchConfigurationRemoved(final ILaunchConfiguration configuration) {
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    Set<Binding> bindings = DynamicLaunchConfigUtils.getBindings();
                    boolean bindingsChanged = DynamicLaunchConfigUtils.removeBinding(configuration, bindings);
                    if (bindingsChanged) {
                        DynamicLaunchConfigUtils.saveBindings(bindings);
                    }
                    DynamicLaunchConfigToolbar.INSTANCE.fNameLaunchConfigMap.remove(configuration.getName());
                    Command command = DynamicLaunchConfigUtils.getCommand(configuration, false);
                    if (command != null) {
                        command.undefine();
                        if (EclipseUtils.isEclipse4x()) {
                            LaunchConfigListener.this.cleanE4Model(command);
                        }
                    }
                    DynamicLaunchConfigToolbar.INSTANCE.refresh();
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                }
            }
        });
    }

    private boolean isValidLaunchConfigurationType(ILaunchConfiguration configuration) {
        boolean result = false;
        try {
            result = configuration != null && configuration.getType() != null && (DVT_LAUNCH_CONFIG_TYPE_ID.equals(configuration.getType().getIdentifier()) || SVLINT_LAUNCH_CONFIG_TYPE_ID.equals(configuration.getType().getIdentifier()));
        }
        catch (CoreException coreException) {
            result = false;
        }
        return result;
    }

    private void cleanE4Model(Command command) {
        block5: {
            if (this.cleanE4ModelDisabled) {
                return;
            }
            try {
                IWorkbenchWindow window = DVTUiUtils.getActiveWorkbenchWindow();
                Field applicationF = window.getClass().getDeclaredField("application");
                applicationF.setAccessible(true);
                Object applicationO = applicationF.get(window);
                Method getCommandsM = applicationO.getClass().getMethod("getCommands", new Class[0]);
                Object mCommandsO = getCommandsM.invoke(applicationO, new Object[0]);
                if (mCommandsO == null || !(mCommandsO instanceof List)) break block5;
                List mCommandsList = (List)mCommandsO;
                for (Object mCommand : mCommandsList) {
                    Method getElementIdM = mCommand.getClass().getMethod("getElementId", new Class[0]);
                    Object commandIDO = getElementIdM.invoke(mCommand, new Object[0]);
                    if (commandIDO == null || !(commandIDO instanceof String) || !((String)commandIDO).equals(command.getId())) continue;
                    mCommandsList.remove(mCommand);
                    break;
                }
            }
            catch (ReflectiveOperationException e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                this.cleanE4ModelDisabled = true;
            }
            catch (Throwable e) {
                DVTLogger.INSTANCE.logError(e);
            }
        }
    }
}

