/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.elaboration;

import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.elaboration.ELConstants;
import ro.amiq.dvt.elaboration.ELUtils;
import ro.amiq.dvt.elaboration.core.ELInstance;
import ro.amiq.dvt.elaboration.core.ELManager;
import ro.amiq.dvt.elaboration.model.ELParamValues;
import ro.amiq.dvt.elaboration.model.IELMemory;
import ro.amiq.dvt.elaboration.model.IELParamValue;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IRfFieldElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.util.DesignUtils;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.pathmanager.DesignPathManager;

public final class ELBatchUtils
implements ELConstants {
    private ELBatchUtils() {
    }

    public static final IELParamValue getParameterValue(IRfFieldElement param, IRfScopeElement scope, ELManager manager, ITextEditor textEditor, int offset) {
        if (manager == null || param == null) {
            return null;
        }
        if (offset < 0) {
            return null;
        }
        IELMemory memory = manager.getMemory();
        if (memory == null) {
            return null;
        }
        if (!(textEditor instanceof DVTEditor)) {
            return null;
        }
        ElementPath pathFromManager = DesignPathManager.getInstance().getPathFor((DVTEditor)textEditor, offset, param, scope, true, false);
        if (pathFromManager == null || pathFromManager == DesignPathManager.FROZEN_MANAGER_EL_PATH) {
            return null;
        }
        return ELBatchUtils.getParameterValueFromPath(param, memory, pathFromManager);
    }

    public static IELParamValue getParameterValueFromPath(IRfFieldElement param, IELMemory memory, ElementPath path) {
        String paramName = param.getName();
        IRfScopeElement enclosingScope = param.getEnclosingScope();
        if (ELUtils.isVLOGEnumName(param) && enclosingScope != null) {
            enclosingScope = enclosingScope.getEnclosingScope();
        }
        boolean isVHDLArchitecture = DesignUtils.getDesignKind(enclosingScope) == IRfNamedElement.ElementKind.VHDL_ARCHITECTURE;
        while (path != null && !path.isEmpty()) {
            ELInstance instanceFor = memory.instanceFor(path);
            if (instanceFor == null) break;
            IRfNamedElement binding = instanceFor.getBinding(!isVHDLArchitecture);
            if (binding == enclosingScope) {
                IELParamValue value;
                ELParamValues paramValues = instanceFor.getParamValues();
                if (paramValues != null && (value = paramValues.getValueDirectly(paramName)) != null) {
                    return value;
                }
                return IELParamValue.UNDEFINED_VALUE;
            }
            if (!instanceFor.isBlock()) break;
            path = ElementPath.upperPathOf(path);
        }
        return null;
    }

    public static final IELParamValue getParameterOrConstantValue(IRfFieldElement param, IRfScopeElement scope, ELManager manager, ITextEditor textEditor, int offset) {
        if (param == null || manager == null) {
            return null;
        }
        IELParamValue actualValue = ELBatchUtils.getParameterValue(param, scope, manager, textEditor, offset);
        if (actualValue != null) {
            return actualValue;
        }
        IRfScopeElement searchScope = param.getEnclosingScope();
        if (ELUtils.isVLOGEnumName(param) && searchScope != null) {
            searchScope = searchScope.getEnclosingScope();
        }
        if (searchScope == null) {
            return null;
        }
        ELParamValues externalConstants = manager.getExternalConstants((IRfNamedElement)searchScope);
        if (externalConstants != null && (actualValue = externalConstants.getValueDirectly(param.getName())) == null) {
            return IELParamValue.UNDEFINED_VALUE;
        }
        return actualValue;
    }

    public static final IELParamValue getParameterOrConstantValue(IRfFieldElement param, ELManager manager, ElementPath path) {
        if (param == null || manager == null) {
            return null;
        }
        IELParamValue actualValue = ELBatchUtils.getParameterValueFromPath(param, manager.getMemory(), path);
        if (actualValue != null) {
            return actualValue;
        }
        IRfScopeElement searchScope = param.getEnclosingScope();
        if (ELUtils.isVLOGEnumName(param) && searchScope != null) {
            searchScope = searchScope.getEnclosingScope();
        }
        if (searchScope == null) {
            return null;
        }
        ELParamValues externalConstants = manager.getExternalConstants((IRfNamedElement)searchScope);
        if (externalConstants != null && (actualValue = externalConstants.getValueDirectly(param.getName())) == null) {
            return IELParamValue.UNDEFINED_VALUE;
        }
        return actualValue;
    }
}

