/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.elaboration;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.buildconfig.ElabLiblist;
import ro.amiq.dvt.buildconfig.ElaborationDebugZone;
import ro.amiq.dvt.buildconfig.ElaborationExpressionControl;
import ro.amiq.dvt.elaboration.ELConstants;
import ro.amiq.dvt.elaboration.core.ELContext;
import ro.amiq.dvt.elaboration.core.ELInstance;
import ro.amiq.dvt.elaboration.core.ELManager;
import ro.amiq.dvt.elaboration.model.ELLiblist;
import ro.amiq.dvt.elaboration.model.ELParamValueScope;
import ro.amiq.dvt.elaboration.model.ELParamValues;
import ro.amiq.dvt.elaboration.model.ELParamValuesHidEvaluator;
import ro.amiq.dvt.elaboration.model.IELDesign;
import ro.amiq.dvt.elaboration.model.IELMemory;
import ro.amiq.dvt.elaboration.model.IELParamValue;
import ro.amiq.dvt.interpreter.IXSim;
import ro.amiq.dvt.interpreter.XArrayValueHolder;
import ro.amiq.dvt.interpreter.XQueueValues;
import ro.amiq.dvt.interpreter.XStopThreadException;
import ro.amiq.dvt.interpreter.XThread;
import ro.amiq.dvt.interpreter.XUtils;
import ro.amiq.dvt.interpreter.XValueHolder;
import ro.amiq.dvt.interpreter.XValueHolderFactory;
import ro.amiq.dvt.model.BuildCancelException;
import ro.amiq.dvt.model.reflection.DVTErrorConfiguration;
import ro.amiq.dvt.model.reflection.DVTImplicitConfiguration;
import ro.amiq.dvt.model.reflection.DummyInstance;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.ErrorDesignElement;
import ro.amiq.dvt.model.reflection.IRfAssociatedTypeElement;
import ro.amiq.dvt.model.reflection.IRfBlockElement;
import ro.amiq.dvt.model.reflection.IRfConfiguration;
import ro.amiq.dvt.model.reflection.IRfConfigurationRule;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfEntityComplement;
import ro.amiq.dvt.model.reflection.IRfFieldElement;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.IRfLibraryElement;
import ro.amiq.dvt.model.reflection.IRfMethodElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfPackageElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.NotNull;
import ro.amiq.dvt.model.reflection.RfMixedLangProject;
import ro.amiq.dvt.model.reflection.semantic.extension.ConstructorCallInConstantFunctionException;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidAccess;
import ro.amiq.dvt.model.reflection.semantic.extension.HidEvalJumpStatementException;
import ro.amiq.dvt.model.reflection.semantic.extension.HidEvaluationGuardianCacheImpl;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorVisitor;
import ro.amiq.dvt.model.reflection.semantic.extension.HidQualifierCache;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IDataType;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluationGuardian;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOccurrenceHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.IllegalPartSelectIndexException;
import ro.amiq.dvt.model.reflection.semantic.extension.IllegalRangeException;
import ro.amiq.dvt.model.reflection.semantic.extension.OutOfBoundsAggregateException;
import ro.amiq.dvt.model.reflection.semantic.extension.OutOfBoundsSelectException;
import ro.amiq.dvt.model.reflection.semantic.extension.ReversedPartSelectException;
import ro.amiq.dvt.model.reflection.semantic.extension.SkipLongExpressionEvaluationException;
import ro.amiq.dvt.model.reflection.semantic.extension.UnknownEvaluationException;
import ro.amiq.dvt.model.reflection.semantic.extension.UnknownHidObjectEvaluationException;
import ro.amiq.dvt.model.reflection.semantic.extension2.SDataUtils;
import ro.amiq.dvt.model.reflection.util.DesignUtils;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.BitSetUtils;
import ro.amiq.dvt.utils.BitVectorContext;
import ro.amiq.dvt.utils.DVTNumber;
import ro.amiq.dvt.utils.DVTStringBuilder;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.MaskType;
import ro.amiq.dvt.utils.OptimizedIdentityHashSet;
import ro.amiq.dvt.utils.VlogBitVector;

public final class ELUtils
implements ELConstants {
    private ELUtils() {
    }

    public static ElementPath appendToPath(ElementPath parentPath, Object element) {
        return ElementPath.join(parentPath, element.toString());
    }

    public static ElementPath upperPathOf(ElementPath parentPath) {
        return ElementPath.upperPathOf(parentPath);
    }

    public static ElementPath upperPathOfIgnoreGenerates(ElementPath path, IELMemory mem) {
        if (path == null || path.isEmpty() || mem == null) {
            return path;
        }
        ElementPath parentPath = ElementPath.upperPathOf(path);
        while (parentPath != null && !parentPath.isEmpty()) {
            if (!mem.isGenerateBlock(parentPath)) {
                return parentPath;
            }
            parentPath = ElementPath.upperPathOf(parentPath);
        }
        return parentPath;
    }

    public static ElementPath arrayOfInstancesPath(ElementPath dummyBlockPath) {
        String range = dummyBlockPath.lastSegment();
        String instanceName = dummyBlockPath.prevLastSegment();
        String arrayWithRange = String.valueOf(instanceName) + range;
        ElementPath grandParent = dummyBlockPath.removeLastSegment().removeLastSegment();
        return ElementPath.create(grandParent, arrayWithRange);
    }

    public static ELInstance resolvePathToInstance(ElementPath contextPath, @NotNull ElementPath currentPath, @NotNull ELManager manager, boolean useThreadSafeAccess) {
        Function<ElementPath, ELInstance> instanceFor;
        Function<ElementPath, ELInstance> function = useThreadSafeAccess ? manager::safeMemInstanceFor : (instanceFor = manager.getMemory()::instanceFor);
        if (currentPath.hasRootPrefix()) {
            return instanceFor.apply(currentPath.removeFirstSegment());
        }
        String bindingName = null;
        ElementPath currentNoBindingPath = null;
        ELInstance instance;
        while ((instance = instanceFor.apply(ElementPath.join(contextPath, currentPath))) == null) {
            if (contextPath == null) {
                return null;
            }
            if (bindingName == null) {
                bindingName = ElementPath.firstPathOf(currentPath).getSegmentName();
            }
            if ((instance = instanceFor.apply(contextPath)) != null && instance.getBinding(false).getName().equals(bindingName)) {
                if (currentPath.length() == 1) {
                    return instance;
                }
                if (currentNoBindingPath == null) {
                    currentNoBindingPath = currentPath.removeFirstSegment();
                }
                if ((instance = instanceFor.apply(ElementPath.join(contextPath, currentNoBindingPath))) != null) {
                    return instance;
                }
            }
            contextPath = ElementPath.upperPathOf(contextPath);
        }
        return instance;
    }

    public static boolean hasValidBinding(ELInstance instance) {
        IRfNamedElement binding = instance.getBinding(false);
        return binding instanceof IELDesign && !(binding instanceof ErrorDesignElement);
    }

    public static boolean isVHDL(IRfScopeElement namedElement) {
        return namedElement instanceof IRfNamedElement && ((IRfNamedElement)namedElement).getLanguageKind() == LanguageKind.VHDL;
    }

    public static boolean isVLOG(IRfScopeElement namedElement) {
        return namedElement instanceof IRfNamedElement && ((IRfNamedElement)namedElement).getLanguageKind() == LanguageKind.VLOG;
    }

    public static boolean isVLOGPortListParam(IRfFieldElement param, boolean hasMissingParameterPortList) {
        return param != null && !param.isLocalParameter() && (hasMissingParameterPortList || param.isInParameterPortList());
    }

    public static IELDesign getValidDesign(IRfNamedElement candidate) {
        return candidate instanceof IELDesign ? (IELDesign)candidate : ELConstants.UNRESOLVED_INSTANCE_TYPE;
    }

    @NotNull
    public static ELParamValues getValidParamValues(ELParamValues paramValues) {
        if (paramValues == null) {
            return ELParamValues.EMPTY;
        }
        if (paramValues.isEmpty()) {
            return paramValues.isCaseSensitive() ? ELParamValues.EMPTY : ELParamValues.EMPTY_CASE_INSENSITIVE;
        }
        return paramValues;
    }

    @NotNull
    public static IRfDesignElement computeBindingFromConfig(IRfConfiguration config, IRfDesignElement binding, ElementPath pathPrefix) {
        IRfDesignElement topArchitecture;
        IRfNamedElement topArchitecture2;
        IRfConfigurationRule selectedRule;
        if (config.getLanguageKind() == LanguageKind.VHDL && (selectedRule = config.getSelectedBlockConfigRule()) != null && (topArchitecture2 = selectedRule.getResolvedDesignMapping(pathPrefix)) instanceof IRfDesignElement) {
            binding = (IRfDesignElement)topArchitecture2;
        }
        if (DesignUtils.isVHDLEntity(binding) && (topArchitecture = binding.getArchitecture()) instanceof IRfDesignElement) {
            binding = topArchitecture;
        }
        return binding;
    }

    public static Collection<? extends IRfConfigurationRule> computeChildrenRulesFromConfig(IRfConfiguration topConfig, ElementPath pathPrefix) {
        IRfNamedElement topArchitecture;
        IRfConfigurationRule selectedRule;
        if (topConfig.getLanguageKind() == LanguageKind.VHDL && (selectedRule = topConfig.getSelectedBlockConfigRule()) != null && (topArchitecture = selectedRule.getResolvedDesignMapping(pathPrefix)) instanceof IRfDesignElement) {
            return selectedRule.getLocalRules();
        }
        return null;
    }

    public static Collection<? extends IRfConfigurationRule> computeChildrenRulesFromConfigRule(IRfConfigurationRule configRule) {
        IRfConfigurationRule firstBlockRule;
        if (configRule == null) {
            return null;
        }
        Collection<? extends IRfConfigurationRule> childrenRules = configRule.getLocalRules();
        if (childrenRules != null && childrenRules.size() == 1 && (firstBlockRule = childrenRules.iterator().next()) != null && firstBlockRule.isBlockRule()) {
            return firstBlockRule.getLocalRules();
        }
        return null;
    }

    @NotNull
    public static ELLiblist computeLiblist(IRfConfiguration topConfig, RfMixedLangProject mixedLangProject) {
        List<IRfLibraryElement> defaultLiblist = topConfig.getDefaultLiblist();
        if (defaultLiblist != null && !defaultLiblist.isEmpty()) {
            return ELLiblist.of(defaultLiblist, !(topConfig instanceof DVTImplicitConfiguration));
        }
        if (topConfig.getLanguageKind() == LanguageKind.VLOG) {
            IRfLibraryElement enclosingLibrary = topConfig.getEnclosingLibrary();
            if (enclosingLibrary != null) {
                String enclosingLibraryName = enclosingLibrary.getName();
                ArrayList<IRfLibraryElement> result = new ArrayList<IRfLibraryElement>(2);
                result.add(enclosingLibrary);
                List<IRfLibraryElement> crossLangLibraries = mixedLangProject.getLibrariesWithPrefix(topConfig.getRfProject(), enclosingLibraryName, 1);
                if (crossLangLibraries != null && !crossLangLibraries.isEmpty()) {
                    result.add(crossLangLibraries.get(0));
                }
                return ELLiblist.of(result, !(topConfig instanceof DVTImplicitConfiguration));
            }
            return ELLiblist.EMPTY_LIBLIST;
        }
        defaultLiblist = mixedLangProject.getAllLibraries();
        if (defaultLiblist != null && !defaultLiblist.isEmpty()) {
            return ELLiblist.of(defaultLiblist, !(topConfig instanceof DVTImplicitConfiguration));
        }
        return ELLiblist.EMPTY_LIBLIST;
    }

    @NotNull
    public static ELLiblist computeLiblist(ELContext context, IRfConfiguration config) {
        ELLiblist inheritated;
        if (config != null) {
            ELLiblist existing;
            if (context != null && context.getConfig() == config && (existing = context.getLiblist()) != null) {
                return existing;
            }
            List<IRfLibraryElement> defaultLiblist = config.getDefaultLiblist();
            if (defaultLiblist != null && !defaultLiblist.isEmpty()) {
                return ELLiblist.of(defaultLiblist, !(config instanceof DVTImplicitConfiguration));
            }
        }
        if (context != null && (inheritated = context.getLiblist()) != null) {
            return inheritated;
        }
        return ELLiblist.EMPTY_LIBLIST;
    }

    public static boolean isValidTopConfig(IRfConfiguration candidate) {
        return candidate != null && !(candidate instanceof DVTErrorConfiguration);
    }

    public static List<IRfInstanceElement> elaborateConditionalBlockParameters(final IRfBlockElement blockElement, boolean hasCondition, ELParamValues paramValues, final ElementPath hierarchyPath, final ELManager manager) {
        manager.checkBuildCanceled();
        if (manager.isControlEachGenerateBlockOnce()) {
            return Collections.singletonList(GENERATE_BLOCK_DEFAULT_INSTANCE);
        }
        final String blockName = blockElement.getName();
        IHidHolder holder = blockElement.getHidHolder();
        if (holder == null || holder.isHidObjectsEmpty()) {
            if (hasCondition) {
                manager.reportProblemForElement(ElaborationDebugZone.EVAL, true, "MISSING_GENERATE_CONDITION: No condition found for generate ''{0}''", blockElement, hierarchyPath, blockName);
                return Collections.singletonList(GENERATE_BLOCK_UNDEFINED_INSTANCE);
            }
            return Collections.singletonList(GENERATE_BLOCK_DEFAULT_INSTANCE);
        }
        final IRfInstanceElement[] result = new IRfInstanceElement[1];
        final ELParamValuesHidEvaluator evaluator = paramValues.getHidEvaluator(manager);
        final IHidEvaluationGuardian guardian = ELUtils.getEvalGuardian(ELConstants.EvalExceptionZone.GENERATE_BLOCK, blockElement, hierarchyPath, false, manager);
        guardian.updateElements(blockElement, (IRfNamedElement)blockElement.getEnclosingScope());
        holder.visitHidObject(null, new HidOperatorVisitor(null){

            @Override
            public boolean visit(HidOperator operator) {
                ELParamValueScope conditionalResult;
                List<? extends IRfFieldElement> arguments;
                IRfNamedElement potential;
                if (!operator.isIfCondition() && !operator.isCaseItemCondition()) {
                    return true;
                }
                if (result[0] == GENERATE_BLOCK_UNDEFINED_INSTANCE || result[0] == GENERATE_BLOCK_FALSE_INSTANCE) {
                    return false;
                }
                guardian.markEvaluated(operator);
                IHidObject condition = operator.getLHValue();
                if (condition == null) {
                    manager.reportProblemForElement(ElaborationDebugZone.EVAL, true, "MISSING_GENERATE_CONDITION: No condition found for generate ''{0}''", blockElement, hierarchyPath, blockName);
                    result[0] = GENERATE_BLOCK_UNDEFINED_INSTANCE;
                    return false;
                }
                BitVectorContext defaultContext = BitVectorContext.of((IRfNamedElement)blockElement.getEnclosingScope(), true);
                if (blockElement.getLanguageKind() == LanguageKind.VHDL && (potential = SDataUtils.getVariableElement(operator.getOperatorResolvedType())) instanceof IRfMethodElement && "\"??\"".equals(potential.getName()) && !(arguments = ((IRfMethodElement)potential).getArguments()).isEmpty() && arguments.get(0) instanceof IRfAssociatedTypeElement) {
                    defaultContext = ((IRfAssociatedTypeElement)arguments.get(0)).getDataTypeBitVectorContext(evaluator, false, null, manager);
                }
                if (XUtils.getValue(conditionalResult = ELUtils.evaluate(condition, evaluator, defaultContext, guardian)) == null) {
                    manager.reportProblemForElement(ElaborationDebugZone.EVAL, true, "UNRESOLVED_GENERATE_CONDITION: Cannot resolve generate ''{0}'' condition ''{1}''", blockElement, hierarchyPath, blockName, blockElement.getLanguageKind() == LanguageKind.VHDL ? HidUtils.toNiceStringVHDL(condition) : HidUtils.toNiceString(condition));
                    result[0] = GENERATE_BLOCK_UNDEFINED_INSTANCE;
                    return false;
                }
                if (ELUtils.isUnsuccessfulEval(conditionalResult)) {
                    result[0] = GENERATE_BLOCK_UNDEFINED_INSTANCE;
                    return false;
                }
                if (ELUtils.isFalse(XUtils.getValue(conditionalResult))) {
                    result[0] = GENERATE_BLOCK_FALSE_INSTANCE;
                    return false;
                }
                result[0] = GENERATE_BLOCK_DEFAULT_INSTANCE;
                return true;
            }
        });
        if (result[0] == null) {
            if (hasCondition) {
                manager.reportProblemForElement(ElaborationDebugZone.EVAL, true, "MISSING_GENERATE_CONDITION: No condition found for generate ''{0}''", blockElement, hierarchyPath, blockName);
                return Collections.singletonList(GENERATE_BLOCK_UNDEFINED_INSTANCE);
            }
            return Collections.singletonList(GENERATE_BLOCK_DEFAULT_INSTANCE);
        }
        return result[0] == GENERATE_BLOCK_DEFAULT_INSTANCE || result[0] == GENERATE_BLOCK_UNDEFINED_INSTANCE ? Collections.singletonList(result[0]) : null;
    }

    public static void reportBindingProblem(IRfNamedElement binding, IRfNamedElement entityElement, IRfInstanceElement description, String assocTypeName, IRfConfigurationRule elaborationRule, ElementPath hierarchyPath, ELManager manager) {
        IRfDefElement declaration = description.getDeclaration();
        if (declaration == null || assocTypeName == null) {
            return;
        }
        if (ELUtils.isVHDL(description)) {
            boolean isNonImplicitConfigRule;
            IDataType dataType = description.getDataType();
            int offsetStart = dataType != null ? dataType.getOffset() : declaration.getStartOffset();
            int offsetEnd = offsetStart + assocTypeName.length();
            int line = declaration.getStartLine();
            boolean bl = isNonImplicitConfigRule = elaborationRule != null && !elaborationRule.isImplicit();
            if (binding == ELConstants.RECURRENCE_INSTANCE_TYPE) {
                HashMap<String, Object> attributes = new HashMap<String, Object>(4);
                attributes.put("QUICKFIX_ELEMENT_NAME", assocTypeName);
                attributes.put("QUICKFIX_KIND", 54);
                manager.reportProblem(ElaborationDebugZone.FIRST_PASS, true, "RECURRENCE_DETECTED: Recurrence detected for instance type ''{0}''", description, declaration, offsetStart, offsetEnd, line, attributes, hierarchyPath, assocTypeName);
            } else if (entityElement != null && binding == null) {
                String pattern = isNonImplicitConfigRule ? "UNRESOLVED_ENTITY_ARCHITECTURE: Entity ''{0}'' does not have an architecture (instance ''{1}'' cannot be resolved)" : "UNRESOLVED_ENTITY_ARCHITECTURE: Entity ''{0}'' does not have an architecture";
                HashMap<String, Object> attributes = new HashMap<String, Object>(4);
                attributes.put("QUICKFIX_ELEMENT_NAME", assocTypeName);
                attributes.put("QUICKFIX_KIND", 56);
                manager.reportProblem(ElaborationDebugZone.FIRST_PASS, true, pattern, description, declaration, offsetStart, offsetEnd, line, attributes, hierarchyPath, entityElement.getName(), hierarchyPath);
            } else if (entityElement == null && DesignUtils.isVHDLComponent(description.getVHDLPreElaborationDesign())) {
                String pattern = isNonImplicitConfigRule ? "UNRESOLVED_COMPONENT: Component ''{0}'' of instance ''{1}'' is not bound (instance ''{2}'' cannot be resolved)" : "UNRESOLVED_COMPONENT: Component ''{0}'' of instance ''{1}'' is not bound";
                HashMap<String, Object> attributes = new HashMap<String, Object>(4);
                attributes.put("QUICKFIX_ELEMENT_NAME", assocTypeName);
                attributes.put("QUICKFIX_KIND", 55);
                manager.reportProblem(ElaborationDebugZone.FIRST_PASS, true, pattern, description, declaration, offsetStart, offsetEnd, line, attributes, hierarchyPath, assocTypeName, description.getName(), hierarchyPath);
            }
        } else {
            IDataType dataType = description.getDataType();
            int offsetStart = dataType != null ? dataType.getOffset() : declaration.getStartOffset();
            int offsetEnd = offsetStart + assocTypeName.length();
            int line = declaration.getStartLine();
            if (binding == ELConstants.RECURRENCE_INSTANCE_TYPE) {
                HashMap<String, Object> attributes = new HashMap<String, Object>(4);
                attributes.put("QUICKFIX_ELEMENT_NAME", assocTypeName);
                attributes.put("QUICKFIX_KIND", 54);
                manager.reportProblem(ElaborationDebugZone.FIRST_PASS, true, "RECURRENCE_DETECTED: Recurrence detected for instance type ''{0}''", description, declaration, offsetStart, offsetEnd, line, attributes, hierarchyPath, assocTypeName);
            } else {
                String pattern = elaborationRule != null ? "UNDECLARED_MODULE: Module ''{0}'' is not declared (instance ''{1}'' cannot be resolved)" : "UNDECLARED_MODULE: Module ''{0}'' is not declared";
                HashMap<String, Object> attributes = new HashMap<String, Object>(4);
                attributes.put("QUICKFIX_ELEMENT_NAME", assocTypeName);
                attributes.put("QUICKFIX_KIND", 15);
                manager.reportProblem(ElaborationDebugZone.FIRST_PASS, true, pattern, description, declaration, offsetStart, offsetEnd, line, attributes, hierarchyPath, assocTypeName, hierarchyPath);
            }
        }
    }

    private static boolean isValueParameter(IRfNamedElement candidate) {
        if (!(candidate instanceof IRfFieldElement)) {
            return false;
        }
        switch (((IRfFieldElement)candidate).getFieldKind()) {
            case 128: 
            case 8192: 
            case 16384: 
            case 32768: {
                return true;
            }
        }
        return false;
    }

    public static boolean isFalse(IELParamValue candidateValue) {
        if (ELUtils.isUnsuccessfulEval(candidateValue)) {
            return true;
        }
        DVTNumber candidate = candidateValue.getDVTNumber();
        if (!(candidate instanceof VlogBitVector)) {
            return true;
        }
        if (candidate == VlogBitVector.ZERO) {
            return true;
        }
        return ((VlogBitVector)candidate).equalsNoMask(VlogBitVector.ZERO);
    }

    public static final boolean isUnsuccessfulEval(IELParamValue candidateValue) {
        if (candidateValue == IELParamValue.BLACK_BOX_VALUE) {
            throw new IELParamValue.BBoxEvaluationException();
        }
        return candidateValue == null || candidateValue == IELParamValue.UNDEFINED_VALUE || candidateValue instanceof ELParamValues.ParamValueExpression;
    }

    public static final boolean isUnsuccessfulEval(ELParamValueScope candidateValue) {
        if (candidateValue == ELParamValueScope.BLACK_BOX_VALUE || candidateValue != null && candidateValue.value == IELParamValue.BLACK_BOX_VALUE) {
            throw new IELParamValue.BBoxEvaluationException();
        }
        return candidateValue == null || candidateValue.value == null || candidateValue == ELParamValueScope.UNDEFINED_VALUE || candidateValue.value == IELParamValue.UNDEFINED_VALUE || candidateValue.value instanceof ELParamValues.ParamValueExpression;
    }

    public static boolean isParamValueNumber(IELParamValue candidateValue) {
        return candidateValue instanceof ELParamValues.ParamValueNumber;
    }

    public static boolean isActualValueConstant(IRfNamedElement field) {
        return ELUtils.isVLOGConstant(field) || ELUtils.isVHDLConstantVariable(field);
    }

    public static boolean isVLOGConstant(IRfNamedElement field) {
        if (!(field instanceof IRfFieldElement)) {
            return false;
        }
        int fieldKind = ((IRfFieldElement)field).getFieldKind();
        return (fieldKind & 0x388) != 0;
    }

    public static boolean isVHDLConstant(IRfNamedElement field) {
        if (!(field instanceof IRfFieldElement)) {
            return false;
        }
        int fieldKind = ((IRfFieldElement)field).getFieldKind();
        return fieldKind == 0x400000 | fieldKind == 16384;
    }

    public static boolean isVHDLEnumName(IRfNamedElement field) {
        return field instanceof IRfFieldElement && ((IRfFieldElement)field).getFieldKind() == 0x400000;
    }

    public static boolean isVHDLConstantVariable(IRfNamedElement field) {
        return field instanceof IRfFieldElement && ((IRfFieldElement)field).getFieldKind() == 16384;
    }

    public static boolean isVHDLEffectiveConstant(IRfNamedElement field) {
        return field instanceof IRfFieldElement && !((IRfFieldElement)field).isParameter() && ELUtils.isVHDLConstant(field);
    }

    public static boolean isVLOGParam(IRfNamedElement field) {
        if (!(field instanceof IRfFieldElement)) {
            return false;
        }
        int fieldKind = ((IRfFieldElement)field).getFieldKind();
        return fieldKind == 128 | fieldKind == 256;
    }

    public static boolean isVLOGEnumName(IRfNamedElement field) {
        return field instanceof IRfFieldElement && ((IRfFieldElement)field).getFieldKind() == 8;
    }

    public static boolean isVLOGGenvar(IRfNamedElement field) {
        return field instanceof IRfFieldElement && ((IRfFieldElement)field).getFieldKind() == 512;
    }

    public static boolean isVLOGTypeParam(IRfNamedElement field) {
        int fieldKind;
        int n = fieldKind = field instanceof IRfFieldElement ? ((IRfFieldElement)field).getFieldKind() : -1;
        return fieldKind == 256;
    }

    public static IRfNamedElement unwrapArchitecture(IRfNamedElement element) {
        return element instanceof IRfEntityComplement ? ((IRfEntityComplement)((Object)element)).getEntity() : element;
    }

    public static IHidEvaluationGuardian getEvalGuardian(ELConstants.EvalExceptionZone evalZone, IRfNamedElement element, ElementPath hierarchicalPath, boolean isWidthChecking, ELManager manager) {
        if (manager == null) {
            return IHidEvaluationGuardian.DUMMY_EVAL_GUARDIAN;
        }
        return new HidEvaluationGuardian(evalZone, element, hierarchicalPath, 0, isWidthChecking, manager);
    }

    public static BitVectorContext makeEvaluatorContext(IHidEvaluator evaluator, IRfNamedElement param, ElementPath hierarchyPath, ELManager manager) {
        if (!(param instanceof IRfAssociatedTypeElement)) {
            return null;
        }
        return ((IRfAssociatedTypeElement)param).getDataTypeBitVectorContext(evaluator, false, hierarchyPath, manager);
    }

    @NotNull
    public static ELParamValueScope evaluate(IHidObject hidObject, IHidEvaluator evaluator, BitVectorContext context, IHidEvaluationGuardian guardian) {
        try {
            guardian.resetStepCount();
            if (hidObject == null) {
                return null;
            }
            ELParamValueScope eLParamValueScope = hidObject.evaluate(evaluator, context, guardian);
            return eLParamValueScope;
        }
        catch (SkipLongExpressionEvaluationException skipLongExpressionEvaluationException) {
            guardian.report(new UnknownHidObjectEvaluationException(hidObject, String.valueOf(HidUtils.toNiceString(hidObject)) + " [LONG EXPRESSION]"));
            return null;
        }
        catch (XStopThreadException | XThread.XSuspendThreadException | BuildCancelException | HidEvalJumpStatementException ex) {
            throw ex;
        }
        catch (IELParamValue.BBoxEvaluationException bBoxEvaluationException) {
            if (guardian.simulatorMode() == IXSim.XSimMode.UVM_RUNTIME_ELAB && guardian.isAddExtraDebugInfo()) {
                guardian.logError("BlackBox path found: '" + HidUtils.toNiceString(hidObject) + "'");
            }
            ELParamValueScope eLParamValueScope = ELParamValueScope.BLACK_BOX_VALUE;
            return eLParamValueScope;
        }
        catch (IllegalRangeException ex) {
            guardian.report(ex);
            ELParamValueScope eLParamValueScope = ELParamValueScope.UNDEFINED_VALUE;
            return eLParamValueScope;
        }
        catch (UnknownEvaluationException ex) {
            guardian.report(ex);
            guardian.logError("UnknownEvaluation: " + DVTStringUtil.truncateLongText(hidObject, 200, 300));
            return null;
        }
        catch (ArithmeticException | UnsupportedOperationException runtimeException) {
            guardian.report(new UnknownHidObjectEvaluationException(hidObject, String.valueOf(HidUtils.toNiceString(hidObject)) + " [UNSUPPORTED]"));
            guardian.logError("ELUtils.evaluate(): Unexpected Exception!");
            return null;
        }
        catch (XQueueValues.ExceedMaxSize ex) {
            guardian.logWarning(ex.getMessage());
        }
        catch (Exception ex) {
            DVTLogger.INSTANCE.logError((Throwable)ex);
            guardian.logError("ELUtils.evaluate(): Unexpected Exception!");
        }
        finally {
            guardian.checkEvaluationStepLimit(hidObject);
        }
        return ELParamValueScope.UNDEFINED_VALUE;
    }

    @NotNull
    public static ELParamValueScope evaluateForSize(IHidObject hidObject, IHidEvaluator evaluator, IRfNamedElement origin, IHidEvaluationGuardian guardian) {
        try {
            guardian.resetStepCount();
            if (hidObject == null) {
                return null;
            }
            ELParamValueScope eLParamValueScope = hidObject.evaluateForSize(evaluator, origin, guardian);
            return eLParamValueScope;
        }
        catch (SkipLongExpressionEvaluationException skipLongExpressionEvaluationException) {
            guardian.report(new UnknownHidObjectEvaluationException(hidObject, String.valueOf(HidUtils.toNiceString(hidObject)) + " [LONG EXPRESSION]"));
            ELParamValueScope eLParamValueScope = ELParamValueScope.UNDEFINED_VALUE;
            return eLParamValueScope;
        }
        catch (IELParamValue.BBoxEvaluationException bBoxEvaluationException) {
            ELParamValueScope eLParamValueScope = ELParamValueScope.BLACK_BOX_VALUE;
            return eLParamValueScope;
        }
        catch (IllegalRangeException illegalRangeException) {
            ELParamValueScope eLParamValueScope = ELParamValueScope.UNDEFINED_VALUE;
            return eLParamValueScope;
        }
        catch (XStopThreadException | BuildCancelException | HidEvalJumpStatementException ex) {
            throw ex;
        }
        catch (UnknownEvaluationException ex) {
            guardian.report(ex);
            return null;
        }
        catch (ArithmeticException | UnsupportedOperationException runtimeException) {
            guardian.report(new UnknownHidObjectEvaluationException(hidObject, String.valueOf(HidUtils.toNiceString(hidObject)) + " [UNSUPPORTED]"));
            return null;
        }
        catch (Exception ex) {
            DVTLogger.INSTANCE.logError((Throwable)ex);
        }
        finally {
            guardian.checkEvaluationStepLimit(hidObject);
        }
        return ELParamValueScope.UNDEFINED_VALUE;
    }

    public static IELParamValue evaluateCondition(IHidObject condition, IHidEvaluator evaluator, BitVectorContext noContext, IHidEvaluationGuardian guardian) {
        ELParamValueScope result = null;
        XThread xThread = guardian.getActiveThread();
        try {
            guardian.callbackStartStatement(xThread, XUtils.toOperator(condition));
            result = ELUtils.evaluate(condition, evaluator, noContext, guardian);
        }
        finally {
            guardian.callbackEndStatement(xThread, condition);
        }
        if (ELUtils.isUnsuccessfulEval(result)) {
            return ELParamValues.ParamValueNumber.of(VlogBitVector.BIT_UNKNOWN);
        }
        if (ELUtils.isParamValueNumber(XUtils.getValue(result))) {
            DVTNumber resultNumber = result.getDVTNumber();
            if (resultNumber == VlogBitVector.BIT_UNKNOWN || resultNumber == VlogBitVector.BIT_ONE || resultNumber == VlogBitVector.BIT_ZERO || resultNumber == VlogBitVector.BIT_X) {
                return ELParamValues.ParamValueNumber.of(resultNumber);
            }
            if ((resultNumber = DVTNumber.vlogEq(resultNumber, VlogBitVector.BIT_ZERO)) == VlogBitVector.BIT_ONE) {
                return ELParamValues.ParamValueNumber.of(VlogBitVector.BIT_ZERO);
            }
            if (resultNumber == VlogBitVector.BIT_ZERO) {
                return ELParamValues.ParamValueNumber.of(VlogBitVector.BIT_ONE);
            }
            return ELParamValues.ParamValueNumber.of(resultNumber);
        }
        return ELParamValues.ParamValueNumber.of(XUtils.getValue(result).isUnknown() ? VlogBitVector.BIT_UNKNOWN : (result.isNull() ? VlogBitVector.BIT_ZERO : VlogBitVector.BIT_ONE));
    }

    @Deprecated
    public static int getMinimumNofBits(BigInteger number) {
        boolean signed;
        boolean bl = signed = number.signum() == -1;
        return number.intValue() == 0 ? 1 : (int)StrictMath.floor(StrictMath.log(signed ? Math.abs(number.doubleValue()) : number.doubleValue()) / StrictMath.log(2.0)) + 1;
    }

    public static VlogBitVector getVlogBitVector(IELParamValue value) {
        if (ELUtils.isUnsuccessfulEval(value)) {
            return null;
        }
        DVTNumber number = value.getDVTNumber();
        if (DVTNumber.isUndefined(number)) {
            return null;
        }
        if (!(number instanceof VlogBitVector)) {
            return null;
        }
        return (VlogBitVector)number;
    }

    public static void setUnknownValue(IELParamValue value) {
        if (value instanceof XValueHolder) {
            IRfNamedElement namedElement = ((XValueHolder)value).getNamedElement();
            IELParamValue iELParamValue = value = XUtils.getRefValue(((XValueHolder)value).getRefValueHolder()) != null ? XUtils.getRefValue(((XValueHolder)value).getRefValueHolder()) : value;
            if ((namedElement.xIsDynamicArray() || namedElement.xIsQueue() || namedElement.xIsAssociativeArray()) && value instanceof XArrayValueHolder) {
                ((XArrayValueHolder)value).setHasUnknownSize(true);
            } else {
                ((XValueHolder)value).setIsUnknown(true);
                if (value instanceof XArrayValueHolder) {
                    ((XArrayValueHolder)value).foreach((key, elementValue) -> {
                        ELUtils.setUnknownValue(elementValue);
                        return true;
                    });
                }
            }
            return;
        }
        if (value instanceof ELParamValues.ParamValueNumber) {
            value.updateValue(ELParamValues.ParamValueNumber.of(DVTNumber.getUnknownNumber(value.getDVTNumber())), null);
            return;
        }
    }

    public static IELParamValue createUnknownValue(IELParamValue contextValue) {
        if (contextValue instanceof XValueHolder) {
            XValueHolder value = (XValueHolder)((XValueHolder)contextValue).newHolder();
            IRfNamedElement namedElement = value.getNamedElement();
            if (namedElement.xIsDynamicArray() || namedElement.xIsQueue() || namedElement.xIsAssociativeArray()) {
                ((XArrayValueHolder)value).setHasUnknownSize(true);
            } else {
                value.setIsUnknown(true);
                if (value instanceof XArrayValueHolder) {
                    ((XArrayValueHolder)value).foreach((key, elementValue) -> {
                        ELUtils.setUnknownValue(elementValue);
                        return true;
                    });
                }
            }
            return value;
        }
        if (contextValue instanceof ELParamValues.ParamValueNumber) {
            return ELParamValues.ParamValueNumber.of(DVTNumber.getUnknownNumber(contextValue.getDVTNumber()), contextValue.getElement(), contextValue.getEnumTypeWrapper());
        }
        return ELParamValues.ParamValueNumber.of(DVTNumber.getUnknownNumber(null));
    }

    public static DVTNumber convertToString(IELParamValue value) {
        DVTNumber number;
        if (value == null) {
            return null;
        }
        if (value instanceof ELParamValues.ParamValueNumber && (number = ((ELParamValues.ParamValueNumber)value).getDVTNumber()) instanceof VlogBitVector) {
            return BitVectorContext.of(VlogBitVector.create(false, 0, 0, null, false, true), null).transform(number);
        }
        return null;
    }

    public static String valueToString(IELParamValue value) {
        VlogBitVector vlogNumber;
        DVTNumber dvtNumber;
        if (value == null) {
            return null;
        }
        if (value instanceof ELParamValues.ParamValueNumber && !(value instanceof ELParamValues.ParamValueType) && (dvtNumber = ((ELParamValues.ParamValueNumber)value).getDVTNumber()) instanceof VlogBitVector && (vlogNumber = (VlogBitVector)dvtNumber).isString()) {
            return vlogNumber.stringValue(true);
        }
        return value.toStringRadix(10);
    }

    public static IELParamValue stringToValue(String text) {
        if (text == null) {
            return IELParamValue.UNDEFINED_VALUE;
        }
        return ELParamValues.ParamValueNumber.of(VlogBitVector.stringToValue(text));
    }

    public static Number parseNumberVLOG(String text, Number defaultValue, BitSet[] masks, BitVectorContext context, int[] numberInfo, boolean isRealtimeNumber) {
        if (text == null) {
            return defaultValue;
        }
        if ("0".equals(text)) {
            numberInfo[0] = 32;
            return BigInteger.ZERO;
        }
        if ("1".equals(text)) {
            numberInfo[0] = 32;
            return BigInteger.ONE;
        }
        int length = text.length();
        StringBuilder number = new StringBuilder(length);
        StringBuilder numberX = new StringBuilder(length);
        StringBuilder numberZ = new StringBuilder(length);
        int tickIndex = -1;
        int numberBase = 10;
        int specifiedNumberBase = -1;
        int finalNofBits = 0;
        int baseLength = 1;
        int firstXIndex = -1;
        int firstZIndex = -1;
        try {
            boolean isSpecifiedSize = false;
            int i = 0;
            while (i < length) {
                char currChar = text.charAt(i);
                if (currChar == '.') {
                    return Float.valueOf(Float.MAX_VALUE);
                }
                if (currChar != '_') {
                    if (currChar == '\'') {
                        tickIndex = i;
                        int n = finalNofBits = number.length() == 0 ? 0 : Integer.parseInt(number.toString());
                        if (finalNofBits > 0) {
                            isSpecifiedSize = true;
                            numberInfo[1] = finalNofBits;
                        }
                        number.setLength(0);
                        numberX.setLength(0);
                        numberZ.setLength(0);
                        if (i + 1 >= length) {
                            return defaultValue;
                        }
                        char first = text.charAt(i + 1);
                        if (Character.isAlphabetic(first)) {
                            char baseChar = first;
                            ++i;
                            if (first == 's' || first == 'S') {
                                if (i + 1 >= length) {
                                    return defaultValue;
                                }
                                baseChar = text.charAt(i + 1);
                                ++i;
                            }
                            if ((numberBase = DVTStringUtil.numberBaseVLOG(baseChar)) <= 0) {
                                return defaultValue;
                            }
                            baseLength = numberBase == 2 ? 1 : (numberBase == 8 ? 3 : (numberBase == 16 ? 4 : 1));
                            specifiedNumberBase = numberBase;
                            numberInfo[2] = numberBase;
                        }
                        first = text.charAt(i + 1);
                        while (Character.isWhitespace(first)) {
                            if (++i + 1 >= length) {
                                return defaultValue;
                            }
                            first = text.charAt(i + 1);
                        }
                    } else if (Character.isDigit(currChar)) {
                        number.append(currChar);
                        numberZ.append("0");
                        numberX.append("0");
                    } else if (currChar == 'X' || currChar == 'x' || currChar == 'z' || currChar == 'Z' || currChar == '?') {
                        int currentIndex = number.length() * baseLength;
                        if (currChar == 'X' || currChar == 'x') {
                            numberX.append((char)(numberBase == 16 ? 70 : (numberBase == 8 ? 55 : 49)));
                            numberZ.append("0");
                            if (firstXIndex == -1) {
                                firstXIndex = currentIndex;
                            }
                        } else if (currChar == 'Z' || currChar == 'z' || currChar == '?') {
                            numberZ.append((char)(numberBase == 16 ? 70 : (numberBase == 8 ? 55 : 49)));
                            numberX.append("0");
                            if (firstZIndex == -1) {
                                firstZIndex = currentIndex;
                            }
                        }
                        number.append("0");
                    } else {
                        if (tickIndex == -1 || numberBase != 16) {
                            if (currChar == 'E' || currChar == 'e' || currChar == 'M' || currChar == 'm' || currChar == 'K' || currChar == 'k' || currChar == 'u' || currChar == 'n' || currChar == 'p' || currChar == 'f' || currChar == 'a') {
                                return Float.valueOf(Float.MAX_VALUE);
                            }
                            return defaultValue;
                        }
                        number.append(currChar);
                        numberZ.append("0");
                        numberX.append("0");
                    }
                }
                ++i;
            }
            if (number.length() == 0) {
                return defaultValue;
            }
            BigInteger result = new BigInteger(number.toString(), numberBase);
            if (!isSpecifiedSize) {
                finalNofBits = isRealtimeNumber ? 64 : (specifiedNumberBase > 0 ? (numberBase == 16 || numberBase == 8 || numberBase == 2 ? Math.max(32, number.length() * baseLength) : Math.max(32, result.equals(BigInteger.ZERO) ? 1 : result.bitLength())) : 32);
            }
            numberInfo[0] = finalNofBits;
            if (firstXIndex >= 0 || firstZIndex >= 0) {
                boolean zPadding;
                if (numberBase == 10) {
                    numberBase = 2;
                }
                boolean xPadding = firstXIndex == 0;
                boolean bl = zPadding = firstZIndex == 0;
                if (xPadding || zPadding) {
                    if (context != null) {
                        finalNofBits = Integer.max(finalNofBits, context.getSize());
                    }
                    int numberLength = number.length();
                    DVTStringBuilder sbX = new DVTStringBuilder(numberX.toString());
                    DVTStringBuilder sbZ = new DVTStringBuilder(numberZ.toString());
                    while (numberLength < finalNofBits / baseLength) {
                        if (xPadding) {
                            sbX.prepend((char)(numberBase == 16 ? 70 : (numberBase == 8 ? 55 : 49)));
                        } else if (zPadding) {
                            sbZ.prepend((char)(numberBase == 16 ? 70 : (numberBase == 8 ? 55 : 49)));
                        }
                        ++numberLength;
                    }
                    masks[0] = BitSetUtils.toBitSet(new BigInteger(sbX.toString(), numberBase));
                    masks[1] = BitSetUtils.toBitSet(new BigInteger(sbZ.toString(), numberBase));
                } else {
                    masks[0] = BitSetUtils.toBitSet(new BigInteger(numberX.toString(), numberBase));
                    masks[1] = BitSetUtils.toBitSet(new BigInteger(numberZ.toString(), numberBase));
                }
            }
            switch (numberBase) {
                case 2: 
                case 8: 
                case 10: 
                case 16: {
                    return result;
                }
            }
            return defaultValue;
        }
        catch (Exception exception) {
            return defaultValue;
        }
    }

    public static VlogBitVector parseIntegerNumberVLOG(String name, Number defaultValue, BitVectorContext context) {
        if (name == null || name.isEmpty()) {
            return null;
        }
        BitSet[] tmpMask = new BitSet[2];
        int[] nofBits = new int[]{-1, -1, -1};
        Number number = ELUtils.parseNumberVLOG(name, defaultValue, tmpMask, context, nofBits, false);
        if (!(number instanceof BigInteger)) {
            return null;
        }
        int nofBitsFinal = nofBits[0];
        EnumMap<MaskType, BitSet> masks = null;
        if (tmpMask[0] != null || tmpMask[1] != null) {
            masks = new EnumMap<MaskType, BitSet>(MaskType.class);
            if (tmpMask[0] != null && !tmpMask[0].isEmpty()) {
                masks.put(MaskType.X, VlogBitVector.createMask(nofBitsFinal, tmpMask[0]));
            }
            if (tmpMask[1] != null && !tmpMask[1].isEmpty()) {
                masks.put(MaskType.Z, VlogBitVector.createMask(nofBitsFinal, tmpMask[1]));
            }
            if (masks.isEmpty()) {
                masks = null;
            }
        }
        boolean isSigned = false;
        int index = name.indexOf(39);
        if (index < 0) {
            isSigned = true;
        } else {
            int charSign = index + 1 < name.length() ? (int)name.charAt(index + 1) : 48;
            isSigned = charSign == 115 || charSign == 83;
        }
        return VlogBitVector.create(isSigned, nofBitsFinal - 1, 0, null, true, false, false, false, null, masks, (BigInteger)number);
    }

    public static IRfDesignElement getEntityFromMapContainer(IRfNamedElement element) {
        IRfDesignElement candidate = element instanceof IRfInstanceElement ? ((IRfInstanceElement)element).getVHDLPreElaborationDesign() : (element instanceof IRfConfigurationRule ? ((IRfConfigurationRule)element).getResolvedDesignMapping(null) : null);
        return candidate instanceof IRfDesignElement ? (IRfDesignElement)ELUtils.unwrapArchitecture(candidate) : null;
    }

    @NotNull
    public static Map<String, IRfNamedElement> internalComputeConstantsMap(IRfDesignElement binding, IRfInstanceElement description) {
        List<? extends IRfNamedElement> localParameters;
        IRfFieldElement overrideParam;
        boolean isCaseSensitive;
        if (binding == null) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, IRfNamedElement> result = new LinkedHashMap<String, IRfNamedElement>(4);
        boolean isVHDLBinding = ELUtils.isVHDL(binding);
        boolean bl = isCaseSensitive = !isVHDLBinding && !ELUtils.isVHDL(description);
        if (description instanceof DummyInstance && (overrideParam = ((DummyInstance)description).getBlockParameter()) != null) {
            result.put(overrideParam.getElabName(isCaseSensitive), overrideParam);
        }
        if ((localParameters = binding.getLocalElabConstants()) != null) {
            for (IRfNamedElement iRfNamedElement : localParameters) {
                result.put(iRfNamedElement.getElabName(isCaseSensitive), iRfNamedElement);
            }
        }
        return result;
    }

    @NotNull
    public static Map<String, IRfNamedElement> internalComputeParamMap(IRfDesignElement binding, IRfNamedElement descriptionOrConfigRule) {
        if (binding == null || descriptionOrConfigRule instanceof DummyInstance) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, IRfNamedElement> result = new LinkedHashMap<String, IRfNamedElement>();
        boolean isCaseSensitive = !ELUtils.isVHDL(binding) && !ELUtils.isVHDL(descriptionOrConfigRule);
        List<? extends IRfNamedElement> localParameters = binding.getPortListParameters();
        if (localParameters != null) {
            for (IRfNamedElement iRfNamedElement : localParameters) {
                result.put(iRfNamedElement.getElabName(isCaseSensitive), iRfNamedElement);
            }
        }
        return result;
    }

    public static Set<IRfNamedElement> computeVisited(Set<IRfNamedElement> visited, boolean makeCopy) {
        if (!makeCopy) {
            return visited;
        }
        OptimizedIdentityHashSet<IRfNamedElement> result = new OptimizedIdentityHashSet<IRfNamedElement>();
        if (visited != null && !visited.isEmpty()) {
            result.addAll(visited);
        }
        return result;
    }

    public static void computeVisitedAndDepthFromElementPath(ElementPath originalPath, Set<IRfNamedElement> visited, int[] depth, IELMemory memory) {
        ElementPath starting = ElementPath.upperPathOf(originalPath);
        if (starting == null || starting.isEmpty()) {
            return;
        }
        do {
            ELInstance instance;
            if ((instance = memory.instanceFor(starting)) == null) {
                return;
            }
            IRfNamedElement binding = instance.getBinding(false);
            visited.add(binding);
            if (DesignUtils.isBlock(binding)) continue;
            depth[0] = depth[0] + 1;
        } while ((starting = ELUtils.upperPathOf(starting)) != null && !starting.isEmpty());
    }

    public static int computeDepth(ElementPath visitedPath, IELMemory memory) {
        ElementPath starting = ElementPath.upperPathOf(visitedPath);
        if (starting == null || starting.isEmpty()) {
            return 0;
        }
        int depth = 0;
        do {
            ELInstance instance;
            if ((instance = memory.instanceFor(starting)) == null) {
                return depth;
            }
            IRfNamedElement binding = instance.getBinding(false);
            if (DesignUtils.isBlock(binding)) continue;
            ++depth;
        } while ((starting = ELUtils.upperPathOf(starting)) != null && !starting.isEmpty());
        return depth;
    }

    public static void adjustNonCustomLiblist(IRfConfiguration topConfig, RfMixedLangProject mixedLangProject) {
        if (!(topConfig instanceof DVTImplicitConfiguration) && topConfig.getDefaultLiblist() != null && !topConfig.getDefaultLiblist().isEmpty()) {
            return;
        }
        ElabLiblist elabLiblistWrapper = BuildConfigManager.getElabLiblist(mixedLangProject.getProject());
        if (elabLiblistWrapper == null || elabLiblistWrapper.isEmpty()) {
            return;
        }
        List<IRfLibraryElement> allLibraries = mixedLangProject.getAllLibraries();
        ArrayList<IRfLibraryElement> result = new ArrayList<IRfLibraryElement>(2);
        for (String elabLiblist : elabLiblistWrapper.getElabListlists()) {
            for (IRfLibraryElement lib : allLibraries) {
                if (!elabLiblist.equals(lib.getName())) continue;
                result.add(lib);
            }
        }
        if (!result.isEmpty()) {
            topConfig.setDefaultLiblist(result);
        }
    }

    public static List<ELInstance> getChildInstances(IELMemory memory, ElementPath parent, int limit) {
        if (memory == null) {
            return Collections.emptyList();
        }
        Map<ElementPath, ELInstance> subtree = memory.subtreeOf(parent, false);
        if (subtree == null) {
            return Collections.emptyList();
        }
        ArrayList<ELInstance> childInstanceList = new ArrayList<ELInstance>();
        for (ElementPath candidate : subtree.keySet()) {
            if (parent.isDirectParentOf(candidate)) {
                childInstanceList.add(memory.instanceFor(candidate));
            }
            if (childInstanceList.size() != limit) continue;
            return childInstanceList;
        }
        return childInstanceList;
    }

    public static IRfScopeElement computeElaboratedScope(IRfScopeElement scope) {
        if (scope == null) {
            return null;
        }
        if (scope instanceof IRfPackageElement) {
            return ((IRfPackageElement)scope).getSemanticEnableRaw() == 3 ? scope : null;
        }
        if (scope instanceof IRfDesignElement) {
            return ((IRfDesignElement)scope).getSemanticEnableRaw() == 3 ? scope : null;
        }
        return ELUtils.computeElaboratedScope(scope.getEnclosingScope());
    }

    public static class HidEvaluationGuardian
    extends HidEvaluationGuardianCacheImpl {
        private ELManager manager;
        private ELConstants.EvalExceptionZone evalZone;
        private Set<ElaborationExpressionControl> controlGroup;
        private Set<String> controlText;
        private IRfNamedElement problemsElement;
        private IRfNamedElement originElement;
        private ElementPath hierarchyPath;
        private int count;
        private boolean skipLongExpressions;
        private boolean markEvaluated;

        private HidEvaluationGuardian(ELConstants.EvalExceptionZone evalZone, IRfNamedElement element, ElementPath hierarchyPath, int count, boolean isWidthChecking, ELManager manager) {
            this.manager = manager;
            this.skipLongExpressions = manager.skipLongExpressions();
            this.controlGroup = manager.getExpressionControl();
            if (this.controlGroup == null) {
                this.controlGroup = Collections.emptySet();
            }
            this.controlText = manager.getExpressionOperatorControl();
            if (this.controlText == null) {
                this.controlText = Collections.emptySet();
            }
            this.evalZone = evalZone;
            this.problemsElement = element;
            this.originElement = element;
            this.hierarchyPath = hierarchyPath;
            this.count = count;
            this.isEvalForSize = isWidthChecking;
            this.markEvaluated = manager.markElabHidObjects();
        }

        @Override
        public XValueHolderFactory getFactory() {
            return null;
        }

        @Override
        public boolean isInRangeEvalZone() {
            return this.evalZone == ELConstants.EvalExceptionZone.RANGE;
        }

        @Override
        public boolean isInPortConnectionZone() {
            return this.evalZone == ELConstants.EvalExceptionZone.PORT_CONNECTION;
        }

        @Override
        public boolean isInElaborationZone() {
            return this.evalZone == ELConstants.EvalExceptionZone.GENERATE_BLOCK || this.evalZone == ELConstants.EvalExceptionZone.DEFAULT_VALUE_PARAM || this.evalZone == ELConstants.EvalExceptionZone.CONFIG_PARAM || this.evalZone == ELConstants.EvalExceptionZone.DEFPARAM_ASSIGN || this.evalZone == ELConstants.EvalExceptionZone.INSTANCE_PARAM;
        }

        @Override
        public boolean useHidAccessResolved() {
            return this.evalZone == ELConstants.EvalExceptionZone.TYPE_MATCHING;
        }

        @Override
        public ELManager getManager() {
            return this.manager;
        }

        @Override
        public void updateElements(IRfNamedElement problemsElement, IRfNamedElement originElement) {
            this.problemsElement = problemsElement;
            this.originElement = originElement;
        }

        @Override
        public IRfNamedElement getOriginElement() {
            return this.originElement;
        }

        @Override
        public IRfNamedElement getProblemsElement() {
            return this.problemsElement;
        }

        @Override
        public ElementPath getHierarchyPath() {
            return this.hierarchyPath;
        }

        @Override
        public void report(UnknownEvaluationException ex) {
            this.manager.reportEvalProblem(ex, this.evalZone, this.problemsElement, this.hierarchyPath);
        }

        @Override
        public void report(IllegalRangeException evalEx) {
            int offsetEnd;
            int offsetStart;
            HidOccurrence occurrence;
            int line;
            if (this.problemsElement == null) {
                return;
            }
            IRfSingleLangProject rfProject = this.problemsElement.getRfProject();
            if (rfProject == null) {
                return;
            }
            IRfDefElement declaration = this.problemsElement.getDeclaration();
            if (declaration == null) {
                return;
            }
            IHidObject causeObject = evalEx.getCauseObject();
            if (HidUtils.isHidAccess(causeObject)) {
                causeObject = ((HidAccess)causeObject).getParentHid();
            }
            if ((line = HidUtils.getLine(occurrence = causeObject instanceof IHidOccurrenceHolder ? ((IHidOccurrenceHolder)((Object)causeObject)).getOccurrence() : null)) < 0) {
                line = declaration.getStartLine();
            }
            if ((offsetStart = HidUtils.getStartOffset(occurrence)) < 0) {
                offsetStart = declaration.getStartOffset();
            }
            if ((offsetEnd = HidUtils.getEndOffset(causeObject, offsetStart, occurrence)) < 0) {
                offsetEnd = offsetStart + 1;
            }
            if (evalEx instanceof OutOfBoundsAggregateException) {
                OutOfBoundsAggregateException boundsEx = (OutOfBoundsAggregateException)evalEx;
                rfProject.addSemanticError(1, "OUT_OF_BOUNDS_VALUE_IN_AGGREGATE: ''{0}'' is not in the range ''{1}''", this.problemsElement.getLibPkgScope(), offsetStart, offsetEnd, null, line, declaration.getParserPath(), boundsEx.getOutsideValue(), boundsEx.getCauseMessage());
            } else if (evalEx instanceof ReversedPartSelectException) {
                rfProject.addSemanticError(1, "REVERSED_PART_SELECT: Part-select ''{0}'' indices must be reversed", this.problemsElement.getLibPkgScope(), offsetStart, offsetEnd, null, line, declaration.getParserPath(), HidUtils.toStringBuilder(causeObject, true, true, false, true, true, false, this.problemsElement.getLanguageKind()));
            } else if (evalEx instanceof IllegalPartSelectIndexException) {
                boolean isIndexPartSelect = causeObject instanceof HidOperator && (((IHidOperator)causeObject).isPlusIndexPartSelect() || ((IHidOperator)causeObject).isMinusIndexPartSelect());
                rfProject.addSemanticError(1, isIndexPartSelect ? "ILLEGAL_INDEXED_PART_SELECT: Indexed part-select ''{0}'' width cannot evaluate to ''x' or ''z'" : "ILLEGAL_PART_SELECT: Part-select ''{0}'' indices cannot evaluate to ''x' or ''z'", this.problemsElement.getLibPkgScope(), offsetStart, offsetEnd, null, line, declaration.getParserPath(), HidUtils.toStringBuilder(causeObject, true, true, false, true, true, false, this.problemsElement.getLanguageKind()));
            } else if (evalEx instanceof ConstructorCallInConstantFunctionException) {
                String parentClassName = ((ConstructorCallInConstantFunctionException)evalEx).getParentClassName();
                rfProject.addSemanticError(1, "ILLEGAL_NONCONSTANT_EXPRESSION: Cannot call constructor of ''{0}'' in constant function", this.problemsElement.getLibPkgScope(), offsetStart, offsetEnd, null, line, declaration.getParserPath(), HidUtils.toStringBuilder(causeObject, true, true, false, true, true, false, this.problemsElement.getLanguageKind()), parentClassName);
            } else if (evalEx instanceof OutOfBoundsSelectException) {
                String[] outsideValues;
                OutOfBoundsSelectException boundsEx = (OutOfBoundsSelectException)evalEx;
                String dimension = boundsEx.getPackedDimension();
                String[] stringArray = outsideValues = boundsEx.getOutsideValues();
                int n = outsideValues.length;
                int n2 = 0;
                while (n2 < n) {
                    String value = stringArray[n2];
                    rfProject.addSemanticError(1, "OUT_OF_BOUNDS_SELECT: Index ''{0}'' of part-select is out of ''{1}'' bounds", this.problemsElement.getLibPkgScope(), offsetStart, offsetEnd, null, line, declaration.getParserPath(), value, dimension);
                    ++n2;
                }
            }
        }

        @Override
        public void incrementStepCount(int value) {
            this.count += value;
            if (this.skipLongExpressions && (long)this.count > 50L) {
                throw new SkipLongExpressionEvaluationException();
            }
        }

        @Override
        public void checkEvaluationStepLimit(IHidObject hidObject) {
            if ((long)this.count >= 50L) {
                this.manager.logger.debugToLog(ElaborationDebugZone.EVAL, "\n[ELABORATION] Long expression:", HidUtils.toNiceString(hidObject));
            }
        }

        @Override
        public void resetStepCount() {
            this.count = 0;
        }

        @Override
        public void checkBuildCanceled() {
            this.manager.checkBuildCanceled();
        }

        @Override
        public void markEvaluated(Hid hid) {
            if (this.markEvaluated) {
                hid.addQualifier(HidQualifierCache.ELABORATED_HID_QUALIFIER);
            }
        }

        @Override
        public void markEvaluated(IHidOperator opi) {
            if (this.markEvaluated && opi instanceof HidOperator) {
                ((HidOperator)opi).addQualifier(HidQualifierCache.IS_ELABORATED_OPI_QUALIFIER);
            }
        }

        @Override
        public boolean shouldSkip(IHidObject obj) {
            if (this.controlGroup.isEmpty() && this.controlText.isEmpty()) {
                return false;
            }
            switch (obj.getHidKind()) {
                case HID: {
                    return this.controlGroup.contains(ElaborationExpressionControl.HIDS);
                }
                case ACCESS: {
                    return this.controlGroup.contains(ElaborationExpressionControl.ACCESS);
                }
                case IMPLICIT: {
                    return this.controlGroup.contains(ElaborationExpressionControl.LITERALS);
                }
                case OPERATOR: {
                    if (this.controlGroup.contains(ElaborationExpressionControl.OPERATORS)) {
                        return true;
                    }
                    HidOperator operator = (HidOperator)obj;
                    switch (operator.getOperatorKind()) {
                        case BINARY_OPERATOR: {
                            if (this.controlGroup.contains(ElaborationExpressionControl.BINARY_OP)) {
                                return true;
                            }
                        }
                        case TERNARY_OPERATOR: {
                            if (this.controlGroup.contains(ElaborationExpressionControl.TERNARY_OP)) {
                                return true;
                            }
                        }
                        case UNARY_OPERATOR: {
                            if (this.controlGroup.contains(ElaborationExpressionControl.UNARY_OP)) {
                                return true;
                            }
                        }
                        case VARIADIC_OPERATOR: {
                            if (!this.controlGroup.contains(ElaborationExpressionControl.VARIADIC_OP)) break;
                            return true;
                        }
                    }
                    String operatorText = operator.getOperatorText();
                    if (!this.controlText.contains(operatorText)) break;
                    return true;
                }
            }
            return false;
        }

        @Override
        public boolean isInterpreter() {
            return false;
        }

        @Override
        public IXSim.XSimMode simulatorMode() {
            return null;
        }
    }
}

