/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.elaboration;

import java.util.EnumMap;
import java.util.Set;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.Display;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.elaboration.FullElabUtils;
import ro.amiq.dvt.model.FileCompileInfo;
import ro.amiq.dvt.model.reflection.RfMixedLangManager;
import ro.amiq.dvt.model.reflection.RfMixedLangProject;
import ro.amiq.dvt.ui.editor.floatingwidgets.FWidgetFactory;
import ro.amiq.dvt.ui.editor.floatingwidgets.FWidgetType;

public class FullElabNotificationHandler
extends AbstractHandler {
    private static final String JOB_NAME = "DVT: Performing full design elaboration...";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IProject project = DVTPlugin.getSelectionManager().getLastSelectedProject();
        if (project == null) {
            return null;
        }
        new FullElabCommandJob(JOB_NAME, project).schedule();
        return null;
    }

    private static class FullElabCommandJob
    extends Job {
        private IProject project;

        public FullElabCommandJob(String name, IProject project) {
            super(name);
            this.setRule((ISchedulingRule)project.getWorkspace().getRoot());
            this.project = project;
        }

        protected IStatus run(IProgressMonitor monitor) {
            EnumMap<LanguageKind, Set<FileCompileInfo>> changedFiles = FullElabUtils.computeChangedFiles(this.project);
            if (changedFiles == null) {
                return Status.OK_STATUS;
            }
            RfMixedLangProject rfMixedLangProject = RfMixedLangManager.getInstance().getRfMixedLangProject(this.project, false);
            rfMixedLangProject.setBuildProgressMonitor(monitor);
            FullElabUtils.performFullDesignElaboration(changedFiles, this.project);
            Display.getDefault().asyncExec(() -> FWidgetFactory.INSTANCE.disposeAll(FWidgetType.DB_OUT_OF_SYNC, this.project));
            return Status.OK_STATUS;
        }
    }
}

