/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.elaboration;

import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.buildconfig.IBuildConfigParserConstants;
import ro.amiq.dvt.buildconfig.IncrementalElaborationKind;
import ro.amiq.dvt.model.BuildCancelException;
import ro.amiq.dvt.model.DVTMixedLangModelManager;
import ro.amiq.dvt.model.FileCompileInfo;
import ro.amiq.dvt.model.reflection.RfMixedLangManager;
import ro.amiq.dvt.resources.properties.PropertiesManager;
import ro.amiq.dvt.resources.properties.PropertyTypes;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.Utils;

public class FullElabUtils {
    public static void performFullDesignElaboration(EnumMap<LanguageKind, Set<FileCompileInfo>> changedFiles, IProject project) {
        try {
            Set<FileCompileInfo> changedVLOGFiles = changedFiles.get((Object)LanguageKind.VLOG);
            Set<FileCompileInfo> changedVHDLFiles = changedFiles.get((Object)LanguageKind.VHDL);
            if ((changedVLOGFiles == null || changedVLOGFiles.isEmpty()) && (changedVHDLFiles == null || changedVHDLFiles.isEmpty())) {
                RfMixedLangManager.getInstance().incrementalElaborate(project, IncrementalElaborationKind.FULL);
            }
            DVTMixedLangModelManager.getInstance().notifyBuildListenersMixedLangPostIncrementalBuild(project, changedFiles, IncrementalElaborationKind.FULL);
        }
        catch (Exception e) {
            if (e instanceof BuildCancelException) {
                return;
            }
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public static EnumMap<LanguageKind, Set<FileCompileInfo>> computeChangedFiles(IProject project) {
        List<IFile> currentlyEditedFiles = Utils.getCurrentlyEditedFiles();
        if (currentlyEditedFiles == null) {
            return null;
        }
        EnumMap<LanguageKind, Set<FileCompileInfo>> changedFiles = new EnumMap<LanguageKind, Set<FileCompileInfo>>(LanguageKind.class);
        currentlyEditedFiles.stream().filter(f -> project.equals((Object)f.getProject())).forEach(f -> {
            String editorIdOrLanguageSyntax = PropertiesManager.getSessionProperty((IResource)f, PropertyTypes.QN_IMPORTED_FILE);
            if (editorIdOrLanguageSyntax == null) {
                return;
            }
            IBuildConfigParserConstants.LanguageSyntax languageSyntax = IBuildConfigParserConstants.LanguageSyntax.from(editorIdOrLanguageSyntax);
            if (languageSyntax == null) {
                return;
            }
            HashSet<FileCompileInfo> langChangedFiles = (HashSet<FileCompileInfo>)changedFiles.get((Object)languageSyntax.languageKind);
            if (langChangedFiles == null) {
                langChangedFiles = new HashSet<FileCompileInfo>();
                changedFiles.put(languageSyntax.languageKind, langChangedFiles);
            }
            langChangedFiles.add(new FileCompileInfo((IFile)f));
        });
        return changedFiles;
    }
}

