/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.elaboration.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import ro.amiq.dvt.elaboration.core.ELInstance;
import ro.amiq.dvt.elaboration.core.ELSpecialization;
import ro.amiq.dvt.elaboration.model.ELLiblist;
import ro.amiq.dvt.elaboration.model.ELParamValues;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IRfConfiguration;
import ro.amiq.dvt.model.reflection.IRfConfigurationRule;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.utils.OptimizedUtils;

public class ELContext {
    private final ELInstance instance;
    private List<ELInstance> defparamInstances;

    private ELContext(ELInstance instance) {
        this.instance = instance;
    }

    public static ELContext of(ELInstance instance) {
        if (instance == null) {
            return null;
        }
        return new ELContext(instance);
    }

    public ELContext newContext(ELInstance newInstance) {
        return ELContext.of(newInstance);
    }

    public IRfConfiguration getConfig() {
        return this.instance.getElaborationConfig();
    }

    public ElementPath getHierarchyPath() {
        return this.instance.getHierarchyPath();
    }

    public ELLiblist getLiblist() {
        return this.instance.getElaborationLiblist();
    }

    public Collection<? extends IRfConfigurationRule> getChildrenRules() {
        return this.instance.getElaborationChildrenRules();
    }

    public IRfNamedElement getBinding(boolean stripToEntity) {
        if (this.instance == null) {
            return null;
        }
        return this.instance.getBinding(stripToEntity);
    }

    public void addDefparamInstance(ELInstance defparamInstance) {
        if (this.defparamInstances == null) {
            this.defparamInstances = OptimizedUtils.listCreate(1);
        }
        this.defparamInstances.add(defparamInstance);
    }

    public ELParamValues getParamValues() {
        return this.instance.getParamValues();
    }

    public ELSpecialization getSpecialization() {
        return this.instance.getSpecialization();
    }

    public List<ELParamValues> getParamValuesForDefparams() {
        if (this.defparamInstances == null || this.defparamInstances.isEmpty()) {
            return null;
        }
        ArrayList<ELParamValues> values = new ArrayList<ELParamValues>();
        for (ELInstance defparamParent : this.defparamInstances) {
            ELParamValues defparamContext = defparamParent.getParamValues();
            if (defparamContext == null || defparamContext.isEmpty()) continue;
            values.add(defparamContext);
        }
        return values;
    }

    public String toString() {
        StringBuilder str = new StringBuilder().append(this.instance);
        if (this.defparamInstances != null && !this.defparamInstances.isEmpty()) {
            str.append(this.defparamInstances);
        }
        return str.toString();
    }
}

