/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.elaboration.core;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import ro.amiq.dvt.buildconfig.ElaborationDebugZone;
import ro.amiq.dvt.elaboration.ELConstants;
import ro.amiq.dvt.elaboration.ELUtils;
import ro.amiq.dvt.elaboration.core.ELContext;
import ro.amiq.dvt.elaboration.core.ELInstance;
import ro.amiq.dvt.elaboration.core.ELManager;
import ro.amiq.dvt.elaboration.model.ELLiblist;
import ro.amiq.dvt.model.reflection.BindingRuleWrapper;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IRfConfiguration;
import ro.amiq.dvt.model.reflection.IRfConfigurationRule;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.IRfLibraryElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.util.DesignUtils;
import ro.amiq.dvt.utils.DVTStringUtil;

public interface ELCore {
    public static BindingRuleWrapper getInstanceType(IRfInstanceElement description, String instanceTypeName, ElementPath instancePath, ELLiblist liblist, IRfConfiguration config, IRfLibraryElement parentCellLibrary, boolean ignoreCase) {
        IRfConfigurationRule bindingRule;
        if (description == null || instanceTypeName == null || liblist == null) {
            return null;
        }
        List<IRfLibraryElement> configLiblist = config != null && !config.isDummyConfig() ? config.getDefaultLiblist() : null;
        BindingRuleWrapper bindingResult = description.elaborateBinding(instanceTypeName, instancePath, liblist.content, liblist.isCustom, configLiblist, parentCellLibrary, ignoreCase);
        if (bindingResult != null && bindingResult.design != null && config != null && !config.isDummyConfig() && (bindingRule = config.getCellRule(bindingResult.design.getEnclosingLibrary(), instanceTypeName)) != null) {
            return BindingRuleWrapper.fromRule(bindingRule, instancePath);
        }
        return bindingResult;
    }

    public static void validateConfigBinding(ELInstance instance, ELContext context, IRfInstanceElement description, IRfNamedElement binding, String assocTypeName, ELLiblist liblist, IRfConfiguration config, IRfConfigurationRule configRule, Collection<? extends IRfConfigurationRule> childrenRules, boolean isUnderProgram, Set<IRfNamedElement> visited, ELManager manager) {
        IRfDefElement declaration;
        if (binding instanceof IRfConfiguration) {
            config = (IRfConfiguration)binding;
            liblist = ELUtils.computeLiblist(context, config);
            binding = ELUtils.computeBindingFromConfig(config, config.getFirstDesignTop(), instance.getHierarchyPath());
            childrenRules = ELUtils.computeChildrenRulesFromConfig(config, instance.getHierarchyPath());
        }
        IRfDesignElement entityElement = null;
        if (binding != null && DesignUtils.isVHDLEntity(binding)) {
            entityElement = (IRfDesignElement)binding;
            binding = ((IRfDesignElement)binding).getArchitecture();
        }
        if (binding != null) {
            if (visited.contains(binding) && ELCore.testRecurrenceDepth(description, binding, instance.getHierarchyPath(), manager)) {
                IRfNamedElement recurrenceElement = ELUtils.unwrapArchitecture(binding);
                assocTypeName = recurrenceElement.getName();
                binding = ELConstants.RECURRENCE_INSTANCE_TYPE;
            }
            visited.add(binding);
        }
        if (configRule != null) {
            configRule.validate(manager.shouldTriggerElabError(), manager.isPermanentElaboration());
        }
        instance.setBinding(ELUtils.getValidDesign(binding));
        instance.setElaborationConfig(config);
        instance.setElaborationLiblist(liblist);
        instance.setElaborationRule(configRule);
        instance.setElaborationChildrenRules(childrenRules);
        if (!ELUtils.hasValidBinding(instance)) {
            ELUtils.reportBindingProblem(binding, entityElement, description, assocTypeName, configRule, instance.getHierarchyPath(), manager);
        } else if (isUnderProgram && DesignUtils.getDesignKind(binding) != IRfNamedElement.ElementKind.VLOG_CHECKER && (declaration = description.getDeclaration()) != null) {
            String type = DesignUtils.getDesignKindInstanceText(binding);
            String descrName = description.getName();
            int offsetStart = declaration.getLabelStartOffset();
            int offsetEnd = offsetStart + descrName.length();
            int line = declaration.getStartLine();
            HashMap<String, Object> attributes = new HashMap<String, Object>(4);
            attributes.put("QUICKFIX_ELEMENT_NAME", descrName);
            attributes.put("QUICKFIX_KIND", 63);
            manager.reportProblem(1, ElaborationDebugZone.FIRST_PASS, false, "NON_CHECKER_INSTANCE_INSIDE_PROGRAM: {0} instance ''{1}'' not allowed inside program", description, declaration, offsetStart, offsetEnd, line, attributes, instance.getHierarchyPath(), DVTStringUtil.toTitleCase(type), descrName);
        }
    }

    public static boolean testRecurrenceDepth(IRfInstanceElement description, IRfNamedElement binding, ElementPath hierarchyPath, ELManager manager) {
        return !DesignUtils.isBlock(description.getEnclosingScope()) || manager.maxGenerateRecurrenceDepthReached(binding, hierarchyPath);
    }
}

