/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.elaboration.core;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import ro.amiq.dvt.elaboration.core.ELManager;
import ro.amiq.dvt.elaboration.model.IELGraphVertex;
import ro.amiq.dvt.elaboration.model.IELGraphVertexValues;
import ro.amiq.dvt.elaboration.model.IELVertexId;
import ro.amiq.dvt.model.reflection.NotNull;
import ro.amiq.dvt.optimized.collections.fast.LinkedKHMap;
import ro.amiq.dvt.utils.DVTPair;
import ro.amiq.dvt.utils.OptimizedLinkedHashMap;
import ro.amiq.dvt.utils.OptimizedUtils;

public class ELGraph<P extends IELVertexId, T extends IELGraphVertex<P>, V extends IELGraphVertexValues> {
    private Map<P, List<Edge>> edges;
    private List<PossibleEdge> possibleEdges;
    private static final int VERTICES_REMOVE_CUTOFF = 500000;
    private Map<P, T> vertices;

    private void addEdge(T src, T dest, boolean isOriginal) {
        if (this.edges == null) {
            this.edges = new OptimizedLinkedHashMap<P, List<Edge>>();
        }
        List newEdges = this.edges.computeIfAbsent((IELVertexId)src.getID(), key -> OptimizedUtils.listCreate(4));
        newEdges.add(new Edge(this, dest, isOriginal));
    }

    public void addEdge(T src, T dest) {
        this.addEdge(src, dest, true);
    }

    public void addPossibleEdge(T src, P destID) {
        if (this.possibleEdges == null) {
            this.possibleEdges = OptimizedUtils.listCreate(4);
        }
        this.possibleEdges.add(new PossibleEdge(this, src, destID));
    }

    public void addVertex(T vertex, ELManager manager) {
        IELGraphVertex prev;
        if (this.vertices == null) {
            this.vertices = new LinkedKHMap<P, T>();
        }
        if ((prev = (IELGraphVertex)this.vertices.put((IELVertexId)vertex.getID(), vertex)) != null) {
            manager.state.increaseNofCompleteInstances();
        }
    }

    public Map<P, T> getVertices() {
        return this.vertices;
    }

    @NotNull
    private List<Edge> getEdges(T src) {
        if (this.edges == null || this.edges.isEmpty()) {
            return Collections.emptyList();
        }
        List<Edge> srcEdges = this.edges.get(src.getID());
        return srcEdges != null ? srcEdges : Collections.emptyList();
    }

    /*
     * WARNING - void declaration
     */
    public int topologicalSort(Function<T, V> secondPhaseHandler, BiConsumer<T, V> thirdPhaseHandler, ELManager manager) {
        void var4_9;
        int n;
        if (this.vertices == null || this.vertices.isEmpty()) {
            return 0;
        }
        if (this.vertices.size() == 1) {
            manager.checkBuildCanceled();
            IELGraphVertex iELGraphVertex = (IELGraphVertex)this.vertices.values().iterator().next();
            IELGraphVertexValues values = (IELGraphVertexValues)secondPhaseHandler.apply(iELGraphVertex);
            thirdPhaseHandler.accept(iELGraphVertex, values);
            return 0;
        }
        manager.checkBuildCanceled();
        if (this.possibleEdges != null) {
            for (PossibleEdge possibleEdge : this.possibleEdges) {
                IELGraphVertex actualVertex = (IELGraphVertex)this.vertices.get(possibleEdge.destID);
                if (actualVertex == null) continue;
                this.addEdge(possibleEdge.src, actualVertex, false);
            }
        }
        this.possibleEdges = null;
        if (this.edges != null) {
            for (Map.Entry entry : this.edges.entrySet()) {
                manager.checkBuildCanceled();
                for (Edge edge : (List)entry.getValue()) {
                    if (!this.vertices.containsKey(entry.getKey())) continue;
                    edge.dest.increaseDegree();
                }
            }
        }
        boolean shouldRemoveVertices = (n = this.vertices.size()) > 500000;
        ArrayDeque<IELGraphVertex<Object>> work = new ArrayDeque<IELGraphVertex<Object>>();
        Iterator<T> iterator = this.vertices.values().iterator();
        while (iterator.hasNext()) {
            IELGraphVertex iELGraphVertex = (IELGraphVertex)iterator.next();
            manager.checkBuildCanceled();
            if (iELGraphVertex.getDegree() != 0) continue;
            work.add(iELGraphVertex);
            if (!shouldRemoveVertices) continue;
            iterator.remove();
        }
        if (shouldRemoveVertices) {
            this.vertices = null;
        }
        ArrayList<DVTPair<IELGraphVertex, IELGraphVertexValues>> collected = new ArrayList<DVTPair<IELGraphVertex, IELGraphVertexValues>>(work.size());
        while (!work.isEmpty()) {
            manager.checkBuildCanceled();
            IELGraphVertex iELGraphVertex = (IELGraphVertex)work.poll();
            IELGraphVertexValues values = (IELGraphVertexValues)secondPhaseHandler.apply(iELGraphVertex);
            collected.add(DVTPair.of(iELGraphVertex, values));
            for (Edge meEdge : this.getEdges(iELGraphVertex)) {
                meEdge.dest.decreaseDegree();
                if (!meEdge.isOriginal) {
                    meEdge.dest.collectSource(iELGraphVertex);
                }
                if (meEdge.dest.getDegree() != 0) continue;
                work.add((IELGraphVertex<Object>)meEdge.dest);
            }
            --var4_9;
        }
        for (DVTPair dVTPair : collected) {
            manager.checkBuildCanceled();
            thirdPhaseHandler.accept((IELGraphVertex)dVTPair.getKey(), (IELGraphVertexValues)dVTPair.getValue());
        }
        return (int)var4_9;
    }

    public void clean() {
        if (this.possibleEdges != null) {
            this.possibleEdges = null;
        }
        if (this.edges != null) {
            this.edges = null;
        }
        if (this.vertices != null) {
            this.vertices = null;
        }
    }

    private class Edge {
        public T dest;
        public boolean isOriginal = true;
        final /* synthetic */ ELGraph this$0;

        /*
         * WARNING - Possible parameter corruption
         */
        public Edge(T dest, boolean isOriginal) {
            this.this$0 = (ELGraph)n;
            this.dest = dest;
            this.isOriginal = isOriginal;
        }

        public String toString() {
            return "" + this.dest;
        }
    }

    private static class PossibleEdge {
        public T src;
        public P destID;
        final /* synthetic */ ELGraph this$0;

        public PossibleEdge(T src, P dest) {
            this.this$0 = var1_1;
            this.src = src;
            this.destID = dest;
        }

        public String toString() {
            return "<" + this.src + ", " + this.destID + ">";
        }
    }
}

